<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\Attendance;
use Carbon\Carbon;

class AttendanceOvertimeTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->artisan('migrate', ['--env' => 'testing']);
    }

    public function test_get_overtime_hours_normal_day()
    {
        $employee = \App\Models\Employee::factory()->create();

        $att = Attendance::create([
            'employee_id' => $employee->id,
            'date' => Carbon::today()->toDateString(),
            'check_in' => '09:00:00',
            'check_out' => '18:00:00',
            'scheduled_check_in' => '09:00',
            'scheduled_check_out' => '17:00',
            'work_duration' => null,
        ]);

        $this->assertEqualsWithDelta(1.0, $att->getOvertimeHours(), 0.0001);
    }

    public function test_get_overtime_hours_overnight()
    {
        $employee = \App\Models\Employee::factory()->create();

        $att = Attendance::create([
            'employee_id' => $employee->id,
            'date' => Carbon::today()->toDateString(),
            'check_in' => '22:00:00',
            'check_out' => '06:00:00',
            'scheduled_check_in' => '22:00',
            'scheduled_check_out' => '06:00',
        ]);

        $this->assertEqualsWithDelta(0.0, $att->getOvertimeHours(), 0.0001);
    }

    public function test_get_overtime_when_no_scheduled_hours()
    {
        $employee = \App\Models\Employee::factory()->create();

        $att = Attendance::create([
            'employee_id' => $employee->id,
            'date' => Carbon::today()->toDateString(),
            'check_in' => '09:00:00',
            'check_out' => '13:00:00',
            'scheduled_check_in' => null,
            'scheduled_check_out' => null,
        ]);

        // scheduled 0 => overtime = worked
        $this->assertEqualsWithDelta(4.0, $att->getOvertimeHours(), 0.0001);
    }
}
