<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\Employee;
use Carbon\Carbon;

class AccrueLeavesToggleTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        $this->artisan('migrate', ['--env' => 'testing']);
    }

    public function test_accrue_leaves_disabled_results_in_zero_grant()
    {
        $employee = Employee::create([
            'employee_id' => 'EMP20250002',
            'name' => 'No Accrue',
            'salary' => 1000,
            'incentives' => 0,
            'monthly_leave_days_allowed' => 2,
            'hire_date' => Carbon::now()->subMonths(3)->toDateString(),
            'status' => 'active',
            'accrue_leaves' => false,
        ]);

        $balance = $employee->getLeaveBalanceAtEndOfMonthNew(Carbon::now()->year, Carbon::now()->month);
        $this->assertEquals(0, $balance);

        $monthlyGrant = $employee->getMonthlyGrant();
        $this->assertEquals(0, $monthlyGrant);
    }
}
