<?php
// Simple test without external dependencies

$start = \DateTime::createFromFormat('Y-m-d', '2025-12-06');
$end = \DateTime::createFromFormat('Y-m-d', '2025-12-27');

// Calculate excluding weekends (0=Sunday, 5=Friday, 6=Saturday in format('w'))
$count = 0;
$dates = [];

$current = clone $start;
while ($current <= $end) {
    $dow = (int)$current->format('w'); // 0=Sun...6=Sat
    
    $isWeekend = in_array($dow, [0, 6]); // Sunday=0, Saturday=6
    
    if (!$isWeekend) {
        $count++;
        $dayNames = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
        $dates[] = $current->format('Y-m-d') . ' (' . $dayNames[$dow] . ') - format(w)=' . $dow;
    }
    
    $current->modify('+1 day');
}

echo "Working days from 2025-12-06 to 2025-12-27 (no holidays):\n";
foreach ($dates as $d) {
    echo "  $d\n";
}
echo "\nTotal: $count days\n";
?>



