<?php
$base = __DIR__ . '/../';
$langDir = $base . 'resources/lang/';
$langs = ['en','ar','es','fr'];

foreach ($langs as $lang) {
    $dir = $langDir . $lang . '/';
    if (!is_dir($dir)) continue;
    $files = glob($dir . 'app.php.bak.*');
    if (!$files) {
        echo "No backup for $lang\n";
        continue;
    }
    // get latest by name
    usort($files, function($a,$b){return strcmp($b,$a);});
    $latest = $files[0];
    $target = $dir . 'app.php';
    if (copy($latest, $target)) {
        echo "Restored $lang from $latest\n";
    } else {
        echo "Failed to restore $lang\n";
    }
}
echo "Done restore.\n";
