<?php
// Apply machine-translated placeholders for missing translation keys.
// Creates backups and writes arrays using var_export to preserve structure.

$root = realpath(__DIR__ . '/..');
$report = $root . '/scripts/reports/translation_report_20251121203349.json';
if (!file_exists($report)) {
    echo "Report not found: $report\n";
    exit(1);
}
$data = json_decode(file_get_contents($report), true);
if (!is_array($data)) {
    echo "Invalid JSON report\n";
    exit(1);
}

$langs = ['ar','en','es','fr'];
$enFile = $root . '/resources/lang/en/app.php';
if (!file_exists($enFile)) {
    echo "English file missing: $enFile\n";
    exit(1);
}
$en = include $enFile;
if (!is_array($en)) $en = [];

$modified = [];
foreach ($data as $entry) {
    $key = $entry['key'];
    $presence = isset($entry['langs']) ? $entry['langs'] : [];
    foreach ($langs as $lang) {
        if ($lang === 'en') continue;
        $has = isset($presence[$lang]) && $presence[$lang];
        if ($has) continue;

        $langFile = $root . "/resources/lang/{$lang}/app.php";
        if (!file_exists($langFile)) {
            // create directory and file from scratch by copying en file
            @mkdir(dirname($langFile), 0755, true);
            $arr = [];
        } else {
            $arr = include $langFile;
            if (!is_array($arr)) $arr = [];
        }

        if (array_key_exists($key, $arr)) continue; // skip if present

        $value = isset($en[$key]) ? $en[$key] : $key;
        $mt = '[MT] ' . $value;

        // backup original file
        if (file_exists($langFile)) {
            $bak = $langFile . '.bak_mt_' . time();
            copy($langFile, $bak);
        }

        $arr[$key] = $mt;

        // write back safely
        $export = "<?php\n\nreturn " . var_export($arr, true) . ";\n";
        file_put_contents($langFile, $export);

        $modified[$lang][] = $key;
    }
}

foreach ($modified as $lang => $keys) {
    echo "Updated {$lang}: " . count($keys) . " keys\n";
}
if (empty($modified)) echo "No changes needed.\n";

echo "Done.\n";
