<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\{
    DashboardController,
    HomeController,
    EmployeeController,
    AttendanceController,
    LeaveController,
    PayrollController,
    DeductionController,
    LoanController,
    TrainingController,
    AssetController,
    UserController,
    NotificationController,
    SettingController,
    Auth\LoginController,
    DepartmentController,
    PositionController,
    SuperAdminController
};

use App\Http\Controllers\Admin\PermissionController;

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/

Auth::routes(['register' => true]);
Route::post('logout', [LoginController::class, 'logout'])->name('logout');

/*
|--------------------------------------------------------------------------
| Public Routes (Accessible without authentication)
|--------------------------------------------------------------------------
*/

// صفحة "اتصل بنا" — أُضيفت هنا
Route::get('/contact', [SettingController::class, 'contact'])->name('contact');

// Route لتغيير اللغة (عام - متاح للجميع، حتى المستخدمين الضيوف)
Route::get('/language', [App\Http\Controllers\LanguageController::class, 'switch'])->name('set-language');
Route::get('/language/{locale}', [App\Http\Controllers\LanguageController::class, 'switch']);

/*
|--------------------------------------------------------------------------
| Protected Routes (Require Authentication & Role)
|--------------------------------------------------------------------------
*/

Route::middleware(['auth'])->group(function () {

    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard.index');
    Route::get('/dashboard', fn() => redirect()->route('dashboard.index'))->name('dashboard');
    Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/dashboard/search', function (Request $request) {
    // يمكنك استخدام هذه المعلمات لتصفية البيانات في الـ Controller لاحقًا
    $query = $request->input('q');
    return redirect()->route('dashboard.index', ['search' => $query]);
})->name('dashboard.search');


    // Settings
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings/currency', [SettingController::class, 'updateCurrency'])->name('settings.update.currency');

// (language routes are defined above and available publicly)


    // Employees
    // Employee salary history management (effective-dated compensation)
    Route::get('employees/{employee}/salary-histories', [App\Http\Controllers\EmployeeSalaryHistoryController::class, 'index'])->name('employees.salary_histories.index');
    Route::post('employees/{employee}/salary-histories', [App\Http\Controllers\EmployeeSalaryHistoryController::class, 'store'])->name('employees.salary_histories.store');
    Route::get('employees/{employee}/salary-histories/{history}/edit', [App\Http\Controllers\EmployeeSalaryHistoryController::class, 'edit'])->name('employees.salary_histories.edit');
    Route::put('employees/{employee}/salary-histories/{history}', [App\Http\Controllers\EmployeeSalaryHistoryController::class, 'update'])->name('employees.salary_histories.update');
    Route::delete('employees/{employee}/salary-histories/{history}', [App\Http\Controllers\EmployeeSalaryHistoryController::class, 'destroy'])->name('employees.salary_histories.destroy');

    // Employee monthly calendar / attendance actions (MUST be before resource route)
    Route::get('employees/{employee}/calendar', [\App\Http\Controllers\EmployeeController::class, 'calendar'])->name('employees.calendar');
    Route::post('employees/{employee}/calendar/action', [\App\Http\Controllers\EmployeeController::class, 'calendarAction'])->name('employees.calendar.action');

    // Employee Print Routes (MUST be before resource route)
    Route::get('employees/{employee}/print', [EmployeeController::class, 'printSingle'])->name('employees.print-single');
    Route::get('employees/{employee}/print/attendances', [EmployeeController::class, 'printAttendances'])->name('employees.printAttendances');
    Route::get('employees/{employee}/print/leaves', [EmployeeController::class, 'printLeaves'])->name('employees.printLeaves');
    Route::get('employees/{employee}/print/loans', [EmployeeController::class, 'printLoans'])->name('employees.printLoans');
    Route::get('employees/{employee}/print/deductions', [EmployeeController::class, 'printDeductions'])->name('employees.printDeductions');
    Route::get('employees/{employee}/print/leave-accrual-details', [EmployeeController::class, 'printLeaveAccrualDetails'])->name('employees.printLeaveAccrualDetails');
    Route::get('employees/{employee}/print-payroll-summary/{year}/{month}', [EmployeeController::class, 'printPayrollSummaryForMonth'])->name('employees.printPayrollSummaryForMonth');
    Route::get('employees/{employee}/print-payrolls', [EmployeeController::class, 'printPayrolls'])->name('employees.printPayrolls');
    Route::get('employees/{employee}/print-leave-accrual', [EmployeeController::class, 'printLeaveAccrual'])->name('employees.printLeaveAccrual');

    Route::resource('employees', EmployeeController::class);
    Route::get('employees/search', [EmployeeController::class, 'search'])->name('employees.search');
    Route::post('employees/{employee}/remove-cv-file', [EmployeeController::class, 'removeCvFile'])->name('employees.remove.cv.file');

    // Departments & Positions
    Route::resource('departments', DepartmentController::class);
    Route::resource('positions', PositionController::class);

    // Attendance
    // AJAX: fetch list of employees without attendance for a specific date
    // define these specific routes BEFORE the resource route so they don't get captured by attendance/{attendance}
    Route::get('attendance/no-attendance-list', [AttendanceController::class, 'noAttendanceList'])->name('attendance.no-attendance');
    Route::get('attendance/report/daily', [AttendanceController::class, 'dailyReport'])->name('attendance.daily-report');
    Route::get('attendance/report', [AttendanceController::class, 'report'])->name('attendance.report');
    Route::post('attendance/quick-check-in', [AttendanceController::class, 'quickCheckIn'])->name('attendance.quick-check-in');
    Route::post('attendance/quick-check-out', [AttendanceController::class, 'quickCheckOut'])->name('attendance.quick-check-out');
    Route::post('attendance/notify-missing', [AttendanceController::class, 'notifyMissing'])->name('attendance.notify-missing');
    Route::get('/attendance/print-employee/{employee}', [AttendanceController::class, 'printEmployee'])->name('attendance.print-employee');
    // Attendance import (CSV)
    Route::get('attendance/import', [\App\Http\Controllers\AttendanceImportController::class, 'showForm'])->name('attendance.import.form');
    Route::post('attendance/import', [\App\Http\Controllers\AttendanceImportController::class, 'import'])->name('attendance.import');
    // Mark employee as absent without permission and apply leave/deduction
    Route::post('attendance/{employee}/mark-unauthorized-leave', [\App\Http\Controllers\AttendanceController::class, 'markUnauthorizedLeave'])->name('attendance.mark-unauthorized-leave');
    // Resource route (defined last to avoid collisions with above custom routes)
    Route::resource('attendance', AttendanceController::class);

    // Leaves
    Route::get('leaves/guide', [LeaveController::class, 'guide'])->name('leaves.guide');
    Route::resource('leaves', LeaveController::class);
    Route::post('leaves/{leave}/approve', [LeaveController::class, 'approve'])->name('leaves.approve');
    Route::post('leaves/{leave}/reject', [LeaveController::class, 'reject'])->name('leaves.reject');
    Route::post('leaves/{leave}/cancel', [LeaveController::class, 'cancel'])->name('leaves.cancel');
    Route::get('leaves/balance/{employee}', [LeaveController::class, 'getLeaveBalance'])->name('leaves.balance');
    Route::get('leaves/print-employee/{employee}', [LeaveController::class, 'printEmployee'])->name('leaves.print-employee');

    // 💰 الرواتب — النظام الكامل
    // ✅ 1. المسار المخصص لـ getCalculations (مُعرف أولاً)
    Route::get('/payroll/get-calculations', [PayrollController::class, 'getCalculations'])->name('payroll.getCalculations');

    // ✅ 2. ثم Resource Route (مُعرف ثانيًا)
    Route::resource('payroll', PayrollController::class);

    // ✅ 3. باقي المسارات الخاصة
    Route::post('payroll/{payroll}/pay', [PayrollController::class, 'pay'])->name('payroll.pay');
    Route::post('payroll/generate-monthly', [PayrollController::class, 'generateMonthly'])->name('payroll.generate-monthly');
    Route::get('/payroll/print-employee/{employee}', [PayrollController::class, 'printEmployee'])->name('payroll.print-employee');
    Route::get('/payroll/create', [PayrollController::class, 'create'])->name('payroll.create');
    Route::get('/payroll/employee/{employee}', [PayrollController::class, 'showEmployeePayrolls'])->name('payroll.employee.payrolls');
    Route::get('/payroll/{payroll}/print-details', [PayrollController::class, 'printDetails'])->name('payroll.printDetails');




// في routes/web.php
     Route::get('/payroll/{payroll}/print-payroll-details', [PayrollController::class, 'printDetails'])->name('payroll.printPayrollDetails');
    // Deductions
    Route::resource('deductions', DeductionController::class);
    // Holidays (admin)
    Route::resource('holidays', App\Http\Controllers\HolidayController::class);
    Route::resource('holiday-years', App\Http\Controllers\HolidayYearController::class);
    Route::post('holiday-years/generate', [App\Http\Controllers\HolidayYearController::class, 'generate'])->name('holiday-years.generate');
    // Leave balance adjustments (admin)
    Route::resource('leave-balance-changes', App\Http\Controllers\LeaveBalanceChangeController::class);
    Route::post('deductions/{deduction}/apply', [DeductionController::class, 'apply'])->name('deductions.apply');
    Route::post('deductions/{deduction}/cancel', [DeductionController::class, 'cancel'])->name('deductions.cancel');
    Route::post('deductions/{deduction}/toggle-status', [DeductionController::class, 'toggleStatus'])->name('deductions.toggle-status');
    Route::get('deductions/get-active-employees', [DeductionController::class, 'getActiveEmployees'])->name('deductions.get-active-employees');
    Route::get('deductions/get-types', [DeductionController::class, 'getDeductionTypes'])->name('deductions.get-types');
    Route::get('/deductions/print-employee/{employee}', [DeductionController::class, 'printEmployee'])->name('deductions.print-employee');

    // Loans
    Route::resource('loans', LoanController::class);
    Route::post('loans/{loan}/approve', [LoanController::class, 'approve'])->name('loans.approve');
    Route::post('loans/{loan}/reject', [LoanController::class, 'reject'])->name('loans.reject');
    Route::post('loans/{loan}/activate', [LoanController::class, 'activate'])->name('loans.activate');
    Route::post('loans/{loan}/cancel', [LoanController::class, 'cancel'])->name('loans.cancel');
    Route::post('loans/{loan}/pay-installment', [LoanController::class, 'payInstallment'])->name('loans.pay-installment');
    Route::post('loans/request', [LoanController::class, 'request'])->name('loans.request');
    Route::get('/loans/print-employee/{employee}', [LoanController::class, 'printEmployee'])->name('loans.print-employee');

    // Training
    Route::resource('training', TrainingController::class);
    Route::post('training/enroll', [TrainingController::class, 'enroll'])->name('training.enroll');

    // Assets
    Route::resource('assets', AssetController::class);
    Route::post('assets/{asset}/assign', [AssetController::class, 'assign'])->name('assets.assign');
    Route::post('assets/{asset}/unassign', [AssetController::class, 'unassign'])->name('assets.unassign');
    Route::post('assets/{asset}/maintain', [AssetController::class, 'maintain'])->name('assets.maintain');
    Route::post('assets/{asset}/retire', [AssetController::class, 'retire'])->name('assets.retire');

    // Users
    Route::resource('users', UserController::class);
    Route::post('users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggle-status');

        // Super admin: manage user permissions and roles
        Route::middleware(['super_admin'])->prefix('admin')->name('admin.')->group(function () {
            Route::get('permissions', [PermissionController::class, 'index'])->name('permissions.index');
            Route::get('permissions/{user}/edit', [PermissionController::class, 'edit'])->name('permissions.edit');
            Route::post('permissions/{user}', [PermissionController::class, 'update'])->name('permissions.update');
            Route::get('permissions-report', [\App\Http\Controllers\Admin\PermissionReportController::class, 'index'])->name('permissions.report');
        });

    // Notifications
    Route::get('notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::get('notifications/settings', [NotificationController::class, 'settings'])->name('notifications.settings');
    Route::post('notifications/settings', [NotificationController::class, 'updateSettings'])->name('notifications.settings.update');
    Route::patch('notifications/{notification}/read', [NotificationController::class, 'markAsRead'])->name('notifications.mark-as-read');
    Route::post('notifications/read-all', [NotificationController::class, 'markAllAsRead'])->name('notifications.read-all');
    Route::delete('notifications/{notification}', [NotificationController::class, 'destroy'])->name('notifications.destroy');
    Route::delete('notifications/clear-all', [NotificationController::class, 'clearAll'])->name('notifications.clear-all');
});

// Temporary debug route (no auth) to help diagnose 404 for attendance import.
// Remove this route after debugging.
Route::get('attendance/import/debug', function () {
    return view('attendance.import');
})->name('attendance.import.debug');

/*
|--------------------------------------------------------------------------
| API Routes (For AJAX)
|--------------------------------------------------------------------------
*/

Route::middleware(['auth'])->prefix('api')->group(function () {
    Route::get('/employees/{employeeId}/leaves/used/{year}/{month}', [PayrollController::class, 'getUsedLeaveDays'])->name('api.employees.leaves.used');
    Route::get('/employees/{employeeId}/loans/installments/{year}/{month}', [PayrollController::class, 'getLoanInstallmentsForPayroll'])->name('api.employees.loans.installments');
    Route::get('/payroll/active-deductions', [PayrollController::class, 'getActiveDeductions'])->name('api.payroll.active.deductions');
});

/*
|--------------------------------------------------------------------------
| Super Admin Routes
|--------------------------------------------------------------------------
*/

Route::middleware(['auth', 'super_admin'])->prefix('super-admin')->name('super-admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [SuperAdminController::class, 'dashboard'])->name('dashboard');

    // Companies
    Route::get('companies', [SuperAdminController::class, 'companiesIndex'])->name('companies.index');
    Route::get('companies/create', [SuperAdminController::class, 'companiesCreate'])->name('companies.create');
    Route::post('companies', [SuperAdminController::class, 'companiesStore'])->name('companies.store');
    Route::get('companies/{company}/edit', [SuperAdminController::class, 'companiesEdit'])->name('companies.edit');
    Route::put('companies/{company}', [SuperAdminController::class, 'companiesUpdate'])->name('companies.update');
    Route::delete('companies/{company}', [SuperAdminController::class, 'companiesDestroy'])->name('companies.destroy');
    
    // Company Control
    Route::post('companies/{company}/suspend', [SuperAdminController::class, 'suspendCompany'])->name('companies.suspend');
    Route::post('companies/{company}/unsuspend', [SuperAdminController::class, 'unsuspendCompany'])->name('companies.unsuspend');
    Route::post('companies/{company}/payment', [SuperAdminController::class, 'updateCompanyPayment'])->name('companies.payment');
    Route::post('companies/{company}/features', [SuperAdminController::class, 'toggleCompanyFeatures'])->name('companies.features');

    // Users per Company
    Route::prefix('companies/{company}/users')->name('users.')->group(function () {
        Route::get('/', [SuperAdminController::class, 'usersIndex'])->name('index');
        Route::get('/create', [SuperAdminController::class, 'usersCreate'])->name('create');
        Route::post('/', [SuperAdminController::class, 'usersStore'])->name('store');
        Route::get('/{user}/edit', [SuperAdminController::class, 'usersEdit'])->name('edit');
        Route::put('/{user}', [SuperAdminController::class, 'usersUpdate'])->name('update');
        Route::delete('/{user}', [SuperAdminController::class, 'usersDestroy'])->name('destroy');
        Route::post('/{user}/impersonate', [SuperAdminController::class, 'impersonate'])->name('impersonate');
        
        // User Control
        Route::post('/{user}/suspend', [SuperAdminController::class, 'suspendUser'])->name('suspend');
        Route::post('/{user}/unsuspend', [SuperAdminController::class, 'unsuspendUser'])->name('unsuspend');
        Route::post('/{user}/deactivate', [SuperAdminController::class, 'deactivateUser'])->name('deactivate');
        Route::post('/{user}/activate', [SuperAdminController::class, 'activateUser'])->name('activate');
        Route::post('/{user}/reset-password', [SuperAdminController::class, 'resetUserPassword'])->name('reset-password');
    });

    // Stop Impersonation
    Route::post('/stop-impersonation', [SuperAdminController::class, 'stopImpersonation'])->name('stop-impersonation');
});

/*
|--------------------------------------------------------------------------
| Compatibility Redirects (Remove after frontend cleanup)
|--------------------------------------------------------------------------
*/

Route::redirect('/vacations', '/leaves')->name('vacations.index');
Route::redirect('/vacations/create', '/leaves/create')->name('vacations.create');
Route::get('/vacations/{leave}', [LeaveController::class, 'show'])->name('vacations.show');