<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\Employee;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group
| which is assigned the "api" middleware group.
|
*/

// Route for authenticated user info (default)
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

/*
|--------------------------------------------------------------------------
| Employee Info & Leave Balance API
|--------------------------------------------------------------------------
|
| هذه المسارات مخصصة لاستخدامها في create.blade.php لجلب بيانات الموظف
| ورصيد الإجازات تلقائياً عند اختيار الموظف ونوع الإجازة.
|
*/

Route::get('/employee-info/{id}', function ($id) {
    $employee = Employee::findOrFail($id);

    return response()->json([
        'id' => $employee->id,
        'name' => $employee->name,
        'position' => $employee->position ?? 'غير محدد',
        'department' => $employee->department ?? 'غير محدد',
        'photo' => $employee->photo ? asset('storage/' . $employee->photo) : null,
        'granted' => $employee->getAnnualGranted(),
        'used' => $employee->getAnnualUsed(),
        'remaining' => $employee->getAnnualRemaining(),
    ]);
});

/*
⚠️ ملاحظة:
- هذه المسارات كانت مخصصة لواجهة الويب create.blade.php.
- إذا أردت استخدامها بدون توثيق Sanctum، لا تضعها ضمن middleware 'auth:sanctum'.
- يمكن وضعها ضمن Route::middleware('auth')->group(...) إذا أردت حماية الوصول فقط للمستخدمين المسجلين.
*/
