@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('users.show_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('users.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('users.index') }}">{{ __('users.breadcrumb_users') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('users.show_title') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card text-center">
                <div class="card-body">
                    <img src="{{ $user->photo ? asset('storage/' . $user->photo) : 'https://ui-avatars.com/api/?name=' . urlencode($user->name) . '&background=007bff&color=fff' }}" 
                        alt="{{ __('users.avatar') }}" 
                         class="rounded-circle img-thumbnail mb-3" 
                         width="120">
                    <h5>{{ $user->name }}</h5>
                    <p class="text-muted">{{ $user->email }}</p>
                    
                    <span class="badge bg-{{ $user->status == 'active' ? 'success' : 'secondary' }} text-white">
                        {{ $user->status == 'active' ? __('users.status_active') : __('users.status_inactive') }}
                    </span>
                </div>
            </div>

            <!-- عرض معلومات الموظف المرتبط -->
            @if($user->employee)
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title">{{ __('users.employee_info') }}</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>{{ __('users.label_name') }}:</th>
                            <td>{{ $user->employee->name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.employee_number') }}:</th>
                            <td>{{ $user->employee->employee_id }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.employee_position') }}:</th>
                            <td>{{ $user->employee->position?->name ?? 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.employee_department') }}:</th>
                            <td>{{ $user->employee->department?->name ?? 'غير محدد' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            @else
            <div class="card mt-4">
                <div class="card-body text-center">
                    <p class="text-muted">{{ __('users.employee_not_linked') }}</p>
                </div>
            </div>
            @endif
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">{{ __('users.details_title') }}</h4>
                    <table class="table table-borderless">
                        <tr>
                            <th>{{ __('users.label_name') }}:</th>
                            <td>{{ $user->name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.label_email') }}:</th>
                            <td>{{ $user->email }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.label_status') }}:</th>
                            <td>
                                <span class="badge bg-{{ $user->status == 'active' ? 'success' : 'secondary' }} text-white">
                                    {{ $user->status == 'active' ? __('users.status_active') : __('users.status_inactive') }}
                                </span>
                            </td>
                        </tr>
                        <!-- عرض الأدوار -->
                        <tr>
                            <th>{{ __('users.roles') }}:</th>
                            <td>
                                @if($user->roles && $user->roles->isNotEmpty())
                                    @foreach($user->roles as $role)
                                        <span class="badge bg-primary text-white me-1">{{ $role->display_name ?? $role->name }}</span>
                                    @endforeach
                                @else
                                    <span class="text-muted">{{ __('users.no_roles') }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>{{ __('users.label_created_at') }}:</th>
                            <td>{{ $user->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('users.label_updated_at') }}:</th>
                            <td>{{ $user->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>

                    <div class="d-flex gap-2">
                        <a href="{{ route('users.edit', $user) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> {{ __('users.edit') }}
                        </a>
                        <a href="{{ route('users.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> {{ __('users.back') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection