@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('users.page_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        {{-- تم تصحيح الرابط هنا --}}
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('users.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('users.breadcrumb_users') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('users.total_users') }}</p>
                            <h4 class="mb-0">{{ $totalUsers ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-users fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('users.active_users') }}</p>
                            <h4 class="mb-0">{{ $activeUsers ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-check fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('users.inactive_users') }}</p>
                            <h4 class="mb-0">{{ $inactiveUsers ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-times fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('users.admin_users') }}</p>
                            <h4 class="mb-0">{{ $adminUsers ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-user-shield fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">{{ __('users.list_title') }}</h4>
                        <div class="btn-group">
                            @can('create user')
                            <a href="{{ route('users.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> {{ __('users.new_user') }}
                            </a>
                            @endcan

                            {{-- Super-admin quick links: Permissions index & report --}}
                            @if(auth()->check() && auth()->user()->isSuperUser())
                                <a href="{{ route('admin.permissions.index') }}" class="btn btn-outline-secondary ms-1">
                                    <i class="fas fa-key"></i> {{ __('users.manage_permissions') ?? 'صلاحيات' }}
                                </a>

                                <a href="{{ route('admin.permissions.report') }}" class="btn btn-outline-info ms-1">
                                    <i class="fas fa-file-alt"></i> {{ __('users.permissions_report') ?? 'تقرير الصلاحيات' }}
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="{{ __('users.search_placeholder') }}">
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">{{ __('users.status_all') }}</option>
                                <option value="active">{{ __('users.status_active') }}</option>
                                <option value="inactive">{{ __('users.status_inactive') }}</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="roleFilter" class="form-control">
                                <option value="">{{ __('users.roles_all') }}</option>
                                @if(isset($roles) && $roles->isNotEmpty())
                                    @foreach($roles as $role)
                                        <option value="{{ $role->name }}">{{ $role->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="departmentFilter" class="form-control">
                                <option value="">{{ __('users.departments_all') }}</option>
                                <option value="HR">HR</option>
                                <option value="IT">IT</option>
                                <option value="Finance">Finance</option>
                                <option value="Marketing">Marketing</option>
                                <option value="Operations">Operations</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="date" id="createdFrom" class="form-control" placeholder="{{ __('users.from_date') }}">
                                <input type="date" id="createdTo" class="form-control" placeholder="{{ __('users.to_date') }}">
                            </div>
                        </div>
                    </div>

                    <!-- Users Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('users.th_user') }}</th>
                                    <th>{{ __('users.th_email') }}</th>
                                    <th>{{ __('users.th_phone') }}</th>
                                    <th>{{ __('users.th_role') }}</th>
                                    <th>{{ __('users.th_department') }}</th>
                                    <th>{{ __('users.th_registered') }}</th>
                                    <th>{{ __('users.th_last_activity') }}</th>
                                    <th>{{ __('users.th_status') }}</th>
                                    <th>{{ __('users.th_actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users ?? [] as $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if(isset($user->photo))
                                                    <img src="{{ asset('storage/' . $user->photo) }}" alt="صورة المستخدم" class="rounded-circle me-2" width="40" height="40">
                                                @else
                                                    <div class="avatar-sm me-2">
                                                        <span class="avatar-title bg-primary text-white rounded-circle">
                                                            {{ substr($user->name ?? '', 0, 1) }}
                                                        </span>
                                                    </div>
                                                @endif
                                                <div>
                                                    <h5 class="font-size-14 mb-0">{{ $user->name ?? 'غير محدد' }}</h5>
                                                    @if(isset($user->employee))
                                                        <p class="text-muted mb-0">{{ $user->employee->position?->name ?? 'غير محدد' }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @if(isset($user->email))
                                                <a href="mailto:{{ $user->email }}">{{ $user->email }}</a>
                                                @if($user->email_verified_at)
                                                    <span class="badge badge-soft-success ms-1" title="مُؤكد">
                                                        <i class="fas fa-check"></i>
                                                    </span>
                                                @else
                                                    <span class="badge badge-soft-warning ms-1" title="غير مُؤكد">
                                                        <i class="fas fa-exclamation"></i>
                                                    </span>
                                                @endif
                                            @else
                                                <span class="text-muted">{{ __('users.not_available') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($user->phone) && $user->phone)
                                                <a href="tel:{{ $user->phone }}">{{ $user->phone }}</a>
                                            @else
                                                <span class="text-muted">{{ __('users.not_available') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $rolesData = $user->roles ?? [];
                                                $rolesList = [];

                                                if(is_string($rolesData)) {
                                                    $decoded = json_decode($rolesData, true);
                                                    if(is_array($decoded)) {
                                                        foreach($decoded as $r) {
                                                            if(is_array($r)) {
                                                                $rolesList[] = $r['display_name'] ?? $r['name'] ?? null;
                                                            } elseif(is_string($r)) {
                                                                $rolesList[] = $r;
                                                            }
                                                        }
                                                    } else {
                                                        $rolesList[] = $rolesData;
                                                    }
                                                } elseif($rolesData instanceof \Illuminate\Support\Collection) {
                                                    $rolesList = $rolesData->map(fn($r) => $r->display_name ?? $r->name ?? null)->filter()->toArray();
                                                } elseif(is_array($rolesData)) {
                                                    foreach($rolesData as $r) {
                                                        if(is_array($r)) {
                                                            $rolesList[] = $r['display_name'] ?? $r['name'] ?? null;
                                                        } elseif(is_object($r)) {
                                                            $rolesList[] = $r->display_name ?? $r->name ?? null;
                                                        } else {
                                                            $rolesList[] = $r;
                                                        }
                                                    }
                                                } elseif(is_object($rolesData)) {
                                                    // Single role object
                                                    $rolesList[] = $rolesData->display_name ?? $rolesData->name ?? null;
                                                }
                                                $rolesList = array_filter($rolesList);
                                            @endphp

                                            @if(!empty($rolesList))
                                                @foreach($rolesList as $rname)
                                                    <span class="badge badge-soft-primary me-1" style="color: black; background-color: #e2e8f0;">{{ $rname }}</span>
                                                @endforeach
                                            @else
                                                <span class="badge badge-soft-secondary" style="color: black; background-color: #e2e8f0;">{{ __('users.no_roles') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $dept = $user->employee->department ?? $user->department ?? null;
                                                $deptName = null;
                                                if(is_object($dept)) {
                                                    $deptName = $dept->name ?? null;
                                                } elseif(is_array($dept)) {
                                                    $deptName = $dept['name'] ?? null;
                                                } elseif(is_string($dept)) {
                                                    $d = json_decode($dept, true);
                                                    $deptName = is_array($d) ? ($d['name'] ?? $dept) : $dept;
                                                }
                                            @endphp

                                            @if($deptName)
                                                <span class="badge badge-soft-info" style="color: black; background-color: #e2e8f0;">{{ $deptName }}</span>
                                            @else
                                                <span class="text-muted">{{ __('users.not_available') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($user->created_at))
                                                {{ $user->created_at->format('Y-m-d') }}
                                            @else
                                                <span class="text-muted">{{ __('users.not_available') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($user->last_activity))
                                                {{ $user->last_activity->diffForHumans() }}
                                            @else
                                                <span class="text-muted">{{ __('users.never') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($user->status))
                                                @if($user->status == 'active')
                                                    <span class="badge badge-success">{{ __('users.status_active') }}</span>
                                                @elseif($user->status == 'inactive')
                                                    <span class="badge badge-warning">{{ __('users.status_inactive') }}</span>
                                                @else
                                                    <span class="badge badge-secondary">غير معروف</span>
                                                @endif
                                            @else
                                                <span class="badge badge-secondary">غير معروف</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">

                                                @can('view user')
                                                <a href="{{ route('users.show', $user) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @endcan

                                                @can('edit user')
                                                <a href="{{ route('users.edit', $user) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan

                                                {{-- Super-admin: manage per-user permissions --}}
                                                @if(auth()->check() && auth()->user()->isSuperUser())
                                                    <a href="{{ route('admin.permissions.edit', $user) }}" class="btn btn-secondary btn-sm" title="صلاحيات المستخدم">
                                                        <i class="fas fa-user-shield"></i>
                                                    </a>
                                                @endif

                                                {{-- If user is linked to an Employee, show payrolls quick link --}}
                                                @if(isset($user->employee) && $user->employee)
                                                    <a href="{{ route('payroll.employee.payrolls', $user->employee) }}" class="btn btn-dark btn-sm" title="رواتب الموظف">
                                                        <i class="fas fa-file-invoice-dollar"></i>
                                                    </a>
                                                @endif

                                                @can('delete user')
                                                @if(isset($user->id) && $user->id != auth()->id())
                                                <form action="{{ route('users.destroy', $user) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="حذف"
                                                            onclick="return confirm('{{ __('users.confirm_delete') }}');">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endif
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="10" class="text-center">
                                            <i class="fas fa-users fa-3x mb-3"></i>
                                            <h5>{{ __('users.no_users') }}</h5>
                                            <p class="text-muted">{{ __('users.start_create_user') }}</p>
                                            @can('create user')
                                            <a href="{{ route('users.create') }}" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> {{ __('users.new_user') }}
                                            </a>
                                            @endcan
                                        </td>
                                    </tr>
                                    @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($users) && $users->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $users->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats and Charts -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">توزيع المستخدمين حسب الدور</h4>
                    <canvas id="userRolesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نمو المستخدمين</h4>
                    <canvas id="userGrowthChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent User Activities -->
    {{-- 
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">الأنشطة الأخيرة للمستخدمين</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>النشاط</th>
                                    <th>المستخدم</th>
                                    <th>الوصف</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><span class="badge badge-primary">تسجيل دخول</span></td>
                                    <td>أحمد محمد</td>
                                    <td>تسجيل دخول جديد من جهاز كمبيوتر</td>
                                    <td>2025-08-22 16:30</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-success">إنشاء مستخدم</span></td>
                                    <td>مدير النظام</td>
                                    <td>إنشاء حساب جديد للمستخدم سارة علي</td>
                                    <td>2025-08-22 15:45</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-warning">تعديل مستخدم</span></td>
                                    <td>مدير النظام</td>
                                    <td>تعديل معلومات المستخدم خالد حسن</td>
                                    <td>2025-08-22 14:20</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-danger">تعليق حساب</span></td>
                                    <td>مدير النظام</td>
                                    <td>تعليق حساب المستخدم محمد عبدالله</td>
                                    <td>2025-08-22 13:15</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    --}}
</div>

<!-- Chart Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js  "></script>
<script>
document.addEventListener('DOMContentLoaded', function( ) {
    // User Roles Chart
    var ctx1 = document.getElementById('userRolesChart').getContext('2d');
    var userRolesChart = new Chart(ctx1, {
        type: 'pie',
         {
            labels: ['مدير النظام', 'مدير الموارد البشرية', 'مدير المالية', 'مدير التدريب', 'موظف'],
            datasets: [{
                 [2, 5, 3, 2, 45],
                backgroundColor: [
                    '#4361ee',
                    '#3a0ca3',
                    '#4cc9f0',
                    '#f72585',
                    '#7209b7'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // User Growth Chart
    var ctx2 = document.getElementById('userGrowthChart').getContext('2d');
    var userGrowthChart = new Chart(ctx2, {
        type: 'line',
         {
            labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس'],
            datasets: [{
                label: 'المستخدمون الجدد',
                 [8, 12, 6, 9, 15, 11, 7, 13],
                borderColor: '#4361ee',
                backgroundColor: 'rgba(67, 97, 238, 0.1)',
                fill: true,
                tension: 0.4
            }, {
                label: 'المستخدمون النشطون',
                 [45, 48, 50, 52, 55, 57, 58, 61],
                borderColor: '#20bf6b',
                backgroundColor: 'rgba(32, 191, 107, 0.1)',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const statusFilter = document.getElementById('statusFilter');
    const roleFilter = document.getElementById('roleFilter');
    const departmentFilter = document.getElementById('departmentFilter');
    const createdFrom = document.getElementById('createdFrom');
    const createdTo = document.getElementById('createdTo');

    function filterTable() {
        // Implementation for filtering table rows
        console.log('Filtering users table...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (statusFilter) statusFilter.addEventListener('change', filterTable);
    if (roleFilter) roleFilter.addEventListener('change', filterTable);
    if (departmentFilter) departmentFilter.addEventListener('change', filterTable);
    if (createdFrom) createdFrom.addEventListener('change', filterTable);
    if (createdTo) createdTo.addEventListener('change', filterTable);
});
</script>
@endsection