@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تفاصيل البرنامج التدريبي</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item active">تفاصيل البرنامج</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">{{ $program->title }}</h4>
                            <p class="text-muted">{{ $program->category_name }}</p>
                        </div>
                        <div>
                            @if($program->status == 'upcoming')
                                <span class="badge badge-warning fs-6">قادم</span>
                            @elseif($program->status == 'active')
                                <span class="badge badge-success fs-6">جاري</span>
                            @elseif($program->status == 'completed')
                                <span class="badge badge-info fs-6">مكتمل</span>
                            @elseif($program->status == 'cancelled')
                                <span class="badge badge-danger fs-6">ملغى</span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">معلومات البرنامج</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>الفئة:</th>
                                    <td>
                                        @switch($program->category)
                                            @case('technical')
                                                <span class="badge badge-soft-primary">تقني</span>
                                                @break
                                            @case('management')
                                                <span class="badge badge-soft-success">إداري</span>
                                                @break
                                            @case('soft_skills')
                                                <span class="badge badge-soft-warning">مهارات لينة</span>
                                                @break
                                            @case('safety')
                                                <span class="badge badge-soft-danger">سلامة</span>
                                                @break
                                            @case('compliance')
                                                <span class="badge badge-soft-info">امتثال</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-secondary">{{ $program->category }}</span>
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>المدة:</th>
                                    <td>{{ $program->duration }} {{ $program->duration_unit == 'hours' ? 'ساعة' : 'يوم' }}</td>
                                </tr>
                                <tr>
                                    <th>السعة:</th>
                                    <td>{{ $program->capacity }} متدرب</td>
                                </tr>
                                <tr>
                                    <th>الموقع:</th>
                                    <td>{{ $program->location ?? 'غير محدد' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">التواريخ</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>تاريخ البدء:</th>
                                    <td>{{ $program->start_date->format('Y-m-d') }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الانتهاء:</th>
                                    <td>{{ $program->end_date->format('Y-m-d') }}</td>
                                </tr>
                                <tr>
                                    <th>عدد الأيام:</th>
                                    <td>{{ $program->start_date->diffInDays($program->end_date) + 1 }} يوم</td>
                                </tr>
                                <tr>
                                    <th>الوقت المتبقي:</th>
                                    <td>
                                        @if($program->status == 'active')
                                            <span class="text-success">{{ $program->end_date->diffForHumans() }}</span>
                                        @elseif($program->status == 'upcoming')
                                            <span class="text-warning">{{ $program->start_date->diffForHumans() }}</span>
                                        @else
                                            <span class="text-muted">انتهى</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-3">الوصف</h5>
                        <div class="alert alert-light border">
                            {{ $program->description ?? 'لا يوجد وصف للبرنامج' }}
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        @can('edit training')
                        <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editProgramModal">
                            <i class="fas fa-edit"></i> تعديل
                        </button>
                        @endcan

                        @can('delete training')
                        <form action="{{ route('training.destroy', $program) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('{{ addslashes(__('app.confirm_delete_training')) }}')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                        @endcan

                        <a href="{{ route('training.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                    </div>
                </div>
            </div>

            <!-- Enrollments List -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title">المتدربون المسجلون</h5>
                        @can('enroll training')
                        @if(in_array($program->status, ['upcoming', 'active']) && $program->enrollments->count() < $program->capacity)
                        <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#enrollModal">
                            <i class="fas fa-user-plus"></i> تسجيل متدرب
                        </button>
                        @endif
                        @endcan
                    </div>

                    @if($program->enrollments->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="thead-light">
                                <tr>
                                    <th>الموظف</th>
                                    <th>تاريخ التسجيل</th>
                                    <th>الحالة</th>
                                    <th>التقدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($program->enrollments as $enrollment)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($enrollment->employee->photo)
                                                <img src="{{ asset('storage/' . $enrollment->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        {{ substr($enrollment->employee->name, 0, 1) }}
                                                    </span>
                                                </div>
                                            @endif
                                            <div>
                                                <h6 class="mb-0">{{ $enrollment->employee->name }}</h6>
                                                <small class="text-muted">{{ $enrollment->employee->position?->name ?? 'غير محدد' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $enrollment->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        @if($enrollment->status == 'enrolled')
                                            <span class="badge badge-warning">مسجل</span>
                                        @elseif($enrollment->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التدريب</span>
                                        @elseif($enrollment->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($enrollment->status == 'cancelled')
                                            <span class="badge badge-danger">ملغى</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 10px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $enrollment->progress_percentage ?? 0 }}%" 
                                                 aria-valuenow="{{ $enrollment->progress_percentage ?? 0 }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small>{{ $enrollment->progress_percentage ?? 0 }}%</small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view training enrollment')
                                            <a href="{{ route('training.enrollments.show', $enrollment) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('update training enrollment')
                                            @if(in_array($enrollment->status, ['enrolled', 'in_progress']))
                                            <button class="btn btn-success btn-sm" title="تحديث التقدم" 
                                                    data-bs-toggle="modal" data-bs-target="#updateProgressModal"
                                                    data-enrollment-id="{{ $enrollment->id }}">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            @endif
                                            @endcan

                                            @can('delete training enrollment')
                                            <form action="{{ route('training.enrollments.destroy', $enrollment) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="إزالة" 
                                                        onclick="return confirm('{{ addslashes(__('app.confirm_remove_enrollment')) }}')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-users fa-2x text-muted mb-2"></i>
                        <p class="text-muted">لا يوجد متدربون مسجلون في هذا البرنامج</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="avatar-lg mx-auto mb-3">
                        <span class="avatar-title bg-primary text-white rounded-circle">
                            <i class="fas fa-graduation-cap"></i>
                        </span>
                    </div>
                    <h4>{{ $program->title }}</h4>
                    <p class="text-muted">{{ $program->category_name }}</p>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ $program->enrollments->count() }}</h5>
                            <p class="text-muted mb-0">المتدربون</p>
                        </div>
                        <div class="col-6">
                            <h5>{{ $program->capacity }}</h5>
                            <p class="text-muted mb-0">السعة</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Trainer Info -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">معلومات المدرب</h5>
                    @if($program->trainer)
                    <div class="d-flex align-items-center mb-3">
                        @if($program->trainer->photo)
                            <img src="{{ asset('storage/' . $program->trainer->photo) }}" alt="صورة المدرب" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-success text-white rounded-circle">
                                    {{ substr($program->trainer->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $program->trainer->name }}</h6>
                            <p class="mb-0 text-muted">{{ $program->trainer->specialization ?? 'غير محدد' }}</p>
                            <p class="mb-0 text-muted">{{ $program->trainer->email ?? 'غير محدد' }}</p>
                        </div>
                    </div>
                    @else
                    <div class="text-center py-3">
                        <i class="fas fa-user-tie fa-2x text-muted mb-2"></i>
                        <p class="text-muted">لم يتم تعيين مدرب لهذا البرنامج</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Program Progress -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">تقدم البرنامج</h5>
                    <div class="text-center mb-3">
                        <h2 class="mb-1">{{ $program->completion_percentage ?? 0 }}%</h2>
                        <p class="text-muted">مكتمل</p>
                    </div>
                    <div class="progress mb-3">
                        <div class="progress-bar bg-success" role="progressbar" 
                             style="width: {{ $program->completion_percentage ?? 0 }}%" 
                             aria-valuenow="{{ $program->completion_percentage ?? 0 }}" 
                             aria-valuemin="0" aria-valuemax="100">
                        </div>
                    </div>
                    <div class="row text-center">
                        <div class="col-6">
                            <small class="text-muted">المكتملة</small>
                            <h6 class="mt-1">{{ $program->enrollments->where('status', 'completed')->count() }}</h6>
                        </div>
                        <div class="col-6">
                            <small class="text-muted">قيد التدريب</small>
                            <h6 class="mt-1">{{ $program->enrollments->whereIn('status', ['enrolled', 'in_progress'])->count() }}</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Enroll Modal -->
<div class="modal fade" id="enrollModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تسجيل متدرب في البرنامج</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('training.enroll') }}" method="POST">
                @csrf
                <input type="hidden" name="program_id" value="{{ $program->id }}">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="employee_id" class="form-label">اختر الموظف</label>
                        <select class="form-control select2" id="employee_id" name="employee_id" required>
                            <option value="">اختر موظفاً</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }} - {{ $employee->employee_id }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تسجيل</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Program Modal -->
<div class="modal fade" id="editProgramModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل البرنامج التدريبي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('training.update', $program) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_title" class="form-label">اسم البرنامج</label>
                                <input type="text" class="form-control" id="edit_title" name="title" value="{{ old('title', $program->title) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_category" class="form-label">الفئة</label>
                                <select class="form-control" id="edit_category" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="technical" {{ old('category', $program->category) == 'technical' ? 'selected' : '' }}>تقني</option>
                                    <option value="management" {{ old('category', $program->category) == 'management' ? 'selected' : '' }}>إداري</option>
                                    <option value="soft_skills" {{ old('category', $program->category) == 'soft_skills' ? 'selected' : '' }}>مهارات لينة</option>
                                    <option value="safety" {{ old('category', $program->category) == 'safety' ? 'selected' : '' }}>سلامة</option>
                                    <option value="compliance" {{ old('category', $program->category) == 'compliance' ? 'selected' : '' }}>امتثال</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="edit_description" class="form-label">الوصف</label>
                        <textarea class="form-control" id="edit_description" name="description" rows="3">{{ old('description', $program->description) }}</textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_trainer_id" class="form-label">المدرب</label>
                                <select class="form-control" id="edit_trainer_id" name="trainer_id">
                                    <option value="">اختر مدرباً</option>
                                    @foreach($trainers as $trainer)
                                        <option value="{{ $trainer->id }}" {{ old('trainer_id', $program->trainer_id) == $trainer->id ? 'selected' : '' }}>{{ $trainer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_location" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="edit_location" name="location" value="{{ old('location', $program->location) }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_duration" class="form-label">المدة</label>
                                <input type="number" class="form-control" id="edit_duration" name="duration" value="{{ old('duration', $program->duration) }}" min="1">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_duration_unit" class="form-label">وحدة المدة</label>
                                <select class="form-control" id="edit_duration_unit" name="duration_unit">
                                    <option value="hours" {{ old('duration_unit', $program->duration_unit) == 'hours' ? 'selected' : '' }}>ساعات</option>
                                    <option value="days" {{ old('duration_unit', $program->duration_unit) == 'days' ? 'selected' : '' }}>أيام</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="edit_capacity" class="form-label">السعة</label>
                                <input type="number" class="form-control" id="edit_capacity" name="capacity" value="{{ old('capacity', $program->capacity) }}" min="1">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_start_date" class="form-label">تاريخ البدء</label>
                                <input type="date" class="form-control" id="edit_start_date" name="start_date" value="{{ old('start_date', $program->start_date->format('Y-m-d')) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_end_date" class="form-label">تاريخ الانتهاء</label>
                                <input type="date" class="form-control" id="edit_end_date" name="end_date" value="{{ old('end_date', $program->end_date->format('Y-m-d')) }}" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-warning">تحديث البرنامج</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection