@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">إدارة التدريب</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        {{-- تم تصحيح الرابط هنا --}}
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">التدريب</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">إجمالي البرامج</p>
                            <h4 class="mb-0">{{ $totalPrograms ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-graduation-cap fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">البرامج الجارية</p>
                            <h4 class="mb-0">{{ $activePrograms ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-play-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">المتدربون</p>
                            <h4 class="mb-0">{{ $totalTrainees ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-users fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">المكتملة</p>
                            <h4 class="mb-0">{{ $completedPrograms ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">برامج التدريب</h4>
                        <div class="btn-group">
                            @can('create training')
                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createProgramModal">
                                <i class="fas fa-plus"></i> برنامج جديد
                            </button>
                            @endcan
                            @can('import training')
                            <button class="btn btn-success">
                                <i class="fas fa-file-import"></i> استيراد برامج
                            </button>
                            @endcan
                        </div>
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="البحث عن برنامج...">
                        </div>
                        <div class="col-md-2">
                            <select id="categoryFilter" class="form-control">
                                <option value="">جميع الفئات</option>
                                <option value="technical">تقني</option>
                                <option value="management">إداري</option>
                                <option value="soft_skills">مهارات لينة</option>
                                <option value="safety">سلامة</option>
                                <option value="compliance">امتثال</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">جميع الحالات</option>
                                <option value="upcoming">قادم</option>
                                <option value="active">جاري</option>
                                <option value="completed">مكتمل</option>
                                <option value="cancelled">ملغى</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="trainerFilter" class="form-control">
                                <option value="">جميع المدربين</option>
                                @foreach($trainers as $trainer)
                                    <option value="{{ $trainer->id }}">{{ $trainer->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="date" id="startDateFilter" class="form-control" placeholder="من تاريخ">
                                <input type="date" id="endDateFilter" class="form-control" placeholder="إلى تاريخ">
                            </div>
                        </div>
                    </div>

                    <!-- Training Programs Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>اسم البرنامج</th>
                                    <th>الفئة</th>
                                    <th>المدرب</th>
                                    <th>المدة</th>
                                    <th>التاريخ</th>
                                    <th>المتدربون</th>
                                    <th>الحالة</th>
                                    <th>التقدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($programs as $program)
                                <tr>
                                    <td>{{ $program->id }}</td>
                                    <td>
                                        <h5 class="font-size-14 mb-1">{{ $program->title }}</h5>
                                        <p class="text-muted mb-0">{{ Str::limit($program->description, 50) }}</p>
                                    </td>
                                    <td>
                                        @switch($program->category)
                                            @case('technical')
                                                <span class="badge badge-soft-primary">تقني</span>
                                                @break
                                            @case('management')
                                                <span class="badge badge-soft-success">إداري</span>
                                                @break
                                            @case('soft_skills')
                                                <span class="badge badge-soft-warning">مهارات لينة</span>
                                                @break
                                            @case('safety')
                                                <span class="badge badge-soft-danger">سلامة</span>
                                                @break
                                            @case('compliance')
                                                <span class="badge badge-soft-info">امتثال</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-secondary">{{ $program->category }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($program->trainer->photo ?? false)
                                                <img src="{{ asset('storage/' . $program->trainer->photo) }}" alt="صورة المدرب" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        {{ substr($program->trainer->name ?? 'غير محدد', 0, 1) }}
                                                    </span>
                                                </div>
                                            @endif
                                            <span>{{ $program->trainer->name ?? 'غير محدد' }}</span>
                                        </div>
                                    </td>
                                    <td>{{ $program->duration }} {{ $program->duration_unit == 'hours' ? 'ساعة' : 'يوم' }}</td>
                                    <td>
                                        <small>
                                            من: {{ $program->start_date->format('Y-m-d') }}  

                                            إلى: {{ $program->end_date->format('Y-m-d') }}
                                        </small>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="badge bg-primary me-1">{{ $program->enrollments->count() }}</span>
                                            @can('view training enrollment')
                                            {{-- تم تصحيح الرابط هنا --}}
                                            <a href="{{ route('training.enrollments', $program) }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-list"></i>
                                            </a>
                                            @endcan
                                        </div>
                                    </td>
                                    <td>
                                        @if($program->status == 'upcoming')
                                            <span class="badge badge-warning">قادم</span>
                                        @elseif($program->status == 'active')
                                            <span class="badge badge-success">جاري</span>
                                        @elseif($program->status == 'completed')
                                            <span class="badge badge-info">مكتمل</span>
                                        @elseif($program->status == 'cancelled')
                                            <span class="badge badge-danger">ملغى</span>
                                        @else
                                            <span class="badge badge-secondary">غير معروف</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $program->completion_percentage ?? 0 }}%" 
                                                 aria-valuenow="{{ $program->completion_percentage ?? 0 }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                                {{ $program->completion_percentage ?? 0 }}%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view training')
                                            {{-- تم تصحيح الرابط هنا --}}
                                            <a href="{{ route('training.show', $program) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('edit training')
                                            <button class="btn btn-warning btn-sm" title="تعديل" 
                                                    data-bs-toggle="modal" data-bs-target="#editProgramModal"
                                                    data-id="{{ $program->id }}"
                                                    data-title="{{ $program->title }}"
                                                    data-description="{{ $program->description }}"
                                                    data-category="{{ $program->category }}">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            @endcan

                                            @can('delete training')
                                            {{-- تم تصحيح الرابط هنا --}}
                                            <form action="{{ route('training.destroy', $program) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="حذف" 
                                                        onclick="return confirm('{{ addslashes(__('app.confirm_delete_training')) }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan

                                            @can('enroll training')
                                            @if(in_array($program->status, ['upcoming', 'active']))
                                            <button class="btn btn-success btn-sm" title="التسجيل" 
                                                    data-bs-toggle="modal" data-bs-target="#enrollModal"
                                                    data-program-id="{{ $program->id }}"
                                                    data-program-title="{{ $program->title }}">
                                                <i class="fas fa-user-plus"></i>
                                            </button>
                                            @endif
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">
                                        <i class="fas fa-graduation-cap fa-3x mb-3"></i>
                                        <h5>لا توجد برامج تدريب مسجلة</h5>
                                        <p class="text-muted">ابدأ بإنشاء برنامج تدريبي جديد</p>
                                        @can('create training')
                                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createProgramModal">
                                            <i class="fas fa-plus"></i> برنامج جديد
                                        </button>
                                        @endcan
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($programs) && $programs->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $programs->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats and Charts -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">توزيع البرامج حسب الفئة</h4>
                    <canvas id="trainingCategoriesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">إحصائيات التدريب الشهرية</h4>
                    <canvas id="monthlyTrainingChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Training Calendar -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">جدول التدريب</h4>
                    <div id="trainingCalendar"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Training Activities -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">الأنشطة الأخيرة للتدريب</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>النشاط</th>
                                    <th>المستخدم</th>
                                    <th>البرنامج</th>
                                    <th>الحالة</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><span class="badge badge-primary">إنشاء برنامج</span></td>
                                    <td>مدير التدريب</td>
                                    <td>إدارة الوقت بفعالية</td>
                                    <td><span class="badge badge-success">تم الإنشاء</span></td>
                                    <td>2025-08-22</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-success">تسجيل متدرب</span></td>
                                    <td>أحمد محمد</td>
                                    <td>القيادة الفعالة</td>
                                    <td><span class="badge badge-warning">قيد التدريب</span></td>
                                    <td>2025-08-21</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-info">إكمال برنامج</span></td>
                                    <td>سارة علي</td>
                                    <td>مهارات التواصل</td>
                                    <td><span class="badge badge-success">مكتمل</span></td>
                                    <td>2025-08-20</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Program Modal -->
<div class="modal fade" id="createProgramModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إنشاء برنامج تدريبي جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            {{-- تم تصحيح الرابط هنا --}}
            <form action="{{ route('training.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programTitle" class="form-label">اسم البرنامج</label>
                                <input type="text" class="form-control" id="programTitle" name="title" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programCategory" class="form-label">الفئة</label>
                                <select class="form-control" id="programCategory" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="technical">تقني</option>
                                    <option value="management">إداري</option>
                                    <option value="soft_skills">مهارات لينة</option>
                                    <option value="safety">سلامة</option>
                                    <option value="compliance">امتثال</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="programDescription" class="form-label">الوصف</label>
                        <textarea class="form-control" id="programDescription" name="description" rows="3"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programTrainer" class="form-label">المدرب</label>
                                <select class="form-control" id="programTrainer" name="trainer_id">
                                    <option value="">اختر مدرباً</option>
                                    @foreach($trainers as $trainer)
                                        <option value="{{ $trainer->id }}">{{ $trainer->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programLocation" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="programLocation" name="location">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="programDuration" class="form-label">المدة</label>
                                <input type="number" class="form-control" id="programDuration" name="duration" min="1">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="programDurationUnit" class="form-label">وحدة المدة</label>
                                <select class="form-control" id="programDurationUnit" name="duration_unit">
                                    <option value="hours">ساعات</option>
                                    <option value="days">أيام</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="programCapacity" class="form-label">السعة</label>
                                <input type="number" class="form-control" id="programCapacity" name="capacity" min="1">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programStartDate" class="form-label">تاريخ البدء</label>
                                <input type="date" class="form-control" id="programStartDate" name="start_date" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="programEndDate" class="form-label">تاريخ الانتهاء</label>
                                <input type="date" class="form-control" id="programEndDate" name="end_date" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">المتدربون المحتملون</label>
                        <select class="form-control" name="trainees[]" multiple>
                            <option value="">اختر المتدربين</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">إنشاء البرنامج</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Enroll Modal -->
<div class="modal fade" id="enrollModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">التسجيل في برنامج تدريبي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            {{-- تم تصحيح الرابط هنا --}}
            <form id="enrollForm" action="{{ route('training.enroll') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="enrollProgramId" name="program_id">
                    <div class="mb-3">
                        <label class="form-label">البرنامج</label>
                        <input type="text" class="form-control" id="enrollProgramTitle" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="enrollEmployee" class="form-label">اختر الموظف</label>
                        <select class="form-control" id="enrollEmployee" name="employee_id" required>
                            <option value="">اختر موظفاً</option>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="enrollNotes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="enrollNotes" name="notes" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تسجيل</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Chart Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function( ) {
    // Training Categories Chart
    var ctx1 = document.getElementById('trainingCategoriesChart').getContext('2d');
    var trainingCategoriesChart = new Chart(ctx1, {
        type: 'doughnut',
        data: {
            labels: ['تقني', 'إداري', 'مهارات لينة', 'سلامة', 'امتثال'],
            datasets: [{
                data: [30, 25, 20, 15, 10],
                backgroundColor: [
                    '#4361ee',
                    '#3a0ca3',
                    '#4cc9f0',
                    '#f72585',
                    '#7209b7'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Monthly Training Chart
    var ctx2 = document.getElementById('monthlyTrainingChart').getContext('2d');
    var monthlyTrainingChart = new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس'],
            datasets: [{
                label: 'البرامج الجديدة',
                data: [5, 8, 6, 9, 12, 7, 10, 11],
                backgroundColor: 'rgba(67, 97, 238, 0.7)',
                borderColor: 'rgba(67, 97, 238, 1)',
                borderWidth: 1
            }, {
                label: 'البرامج المكتملة',
                data: [3, 5, 4, 6, 8, 5, 7, 9],
                backgroundColor: 'rgba(32, 191, 107, 0.7)',
                borderColor: 'rgba(32, 191, 107, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Enroll Modal
    var enrollModal = document.getElementById('enrollModal');
    if(enrollModal) {
        enrollModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var programId = button.getAttribute('data-program-id');
            var programTitle = button.getAttribute('data-program-title');
            
            var modal = this;
            modal.querySelector('#enrollProgramId').value = programId;
            modal.querySelector('#enrollProgramTitle').value = programTitle;
        });
    }

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const categoryFilter = document.getElementById('categoryFilter');
    const statusFilter = document.getElementById('statusFilter');
    const trainerFilter = document.getElementById('trainerFilter');
    const startDateFilter = document.getElementById('startDateFilter');
    const endDateFilter = document.getElementById('endDateFilter');

    function filterTable() {
        // Implementation for filtering table rows
        console.log('Filtering training programs...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (categoryFilter) categoryFilter.addEventListener('change', filterTable);
    if (statusFilter) statusFilter.addEventListener('change', filterTable);
    if (trainerFilter) trainerFilter.addEventListener('change', filterTable);
    if (startDateFilter) startDateFilter.addEventListener('change', filterTable);
    if (endDateFilter) endDateFilter.addEventListener('change', filterTable);
});
</script>
@endsection
