@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تفاصيل التسجيل في التدريب</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.enrollments.index') }}">التسجيلات</a></li>
                        <li class="breadcrumb-item active">تفاصيل التسجيل</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">تسجيل #{{ $enrollment->id }}</h4>
                            <p class="text-muted">للموظف {{ $enrollment->employee->name }}</p>
                        </div>
                        <div>
                            @if($enrollment->status == 'enrolled')
                                <span class="badge badge-warning fs-6">مسجل</span>
                            @elseif($enrollment->status == 'in_progress')
                                <span class="badge badge-primary fs-6">قيد التدريب</span>
                            @elseif($enrollment->status == 'completed')
                                <span class="badge badge-success fs-6">مكتمل</span>
                            @elseif($enrollment->status == 'cancelled')
                                <span class="badge badge-danger fs-6">ملغى</span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">معلومات الموظف</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>الاسم:</th>
                                    <td>{{ $enrollment->employee->name }}</td>
                                </tr>
                                <tr>
                                    <th>رقم الموظف:</th>
                                    <td>{{ $enrollment->employee->employee_id }}</td>
                                </tr>
                                <tr>
                                    <th>القسم:</th>
                                    <td>{{ $enrollment->employee->department?->name ?? 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>المنصب:</th>
                                    <td>{{ $enrollment->employee->position?->name ?? 'غير محدد' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">معلومات التسجيل</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>تاريخ التسجيل:</th>
                                    <td>{{ $enrollment->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ التحديث:</th>
                                    <td>{{ $enrollment->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>التقدم:</th>
                                    <td>
                                        <div class="progress" style="height: 10px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $enrollment->progress_percentage ?? 0 }}%" 
                                                 aria-valuenow="{{ $enrollment->progress_percentage ?? 0 }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small>{{ $enrollment->progress_percentage ?? 0 }}%</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>النتيجة:</th>
                                    <td>
                                        @if($enrollment->score)
                                            <span class="badge bg-{{ $enrollment->score >= 80 ? 'success' : ($enrollment->score >= 60 ? 'warning' : 'danger') }}">
                                                {{ $enrollment->score }}%
                                            </span>
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($enrollment->notes)
                    <div class="mb-4">
                        <h5 class="mb-3">الملاحظات</h5>
                        <div class="alert alert-light border">
                            {{ $enrollment->notes }}
                        </div>
                    </div>
                    @endif

                    <div class="d-flex gap-2">
                        @can('update training enrollment')
                        @if(in_array($enrollment->status, ['enrolled', 'in_progress']))
                        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#updateProgressModal">
                            <i class="fas fa-sync-alt"></i> تحديث التقدم
                        </button>
                        @endif
                        @endcan

                        @can('delete training enrollment')
                        <form action="{{ route('training.enrollments.destroy', $enrollment) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('{{ addslashes(__('app.confirm_remove_enrollment')) }}')">
                                <i class="fas fa-times"></i> إزالة التسجيل
                            </button>
                        </form>
                        @endcan

                        <a href="{{ route('training.enrollments.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                    </div>
                </div>
            </div>

            <!-- Progress History -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-4">سجل التقدم</h5>
                    @if($enrollment->progressHistory->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="thead-light">
                                <tr>
                                    <th>التاريخ</th>
                                    <th>التقدم</th>
                                    <th>الحالة</th>
                                    <th>الملاحظات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($enrollment->progressHistory as $history)
                                <tr>
                                    <td>{{ $history->created_at->format('Y-m-d H:i') }}</td>
                                    <td>{{ $history->progress_percentage ?? 0 }}%</td>
                                    <td>
                                        @if($history->status == 'enrolled')
                                            <span class="badge badge-warning">مسجل</span>
                                        @elseif($history->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التدريب</span>
                                        @elseif($history->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($history->status == 'cancelled')
                                            <span class="badge badge-danger">ملغى</span>
                                        @endif
                                    </td>
                                    <td>{{ $history->notes ?? 'لا توجد ملاحظات' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-history fa-2x text-muted mb-2"></i>
                        <p class="text-muted">لا يوجد سجل تقدم</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    @if($enrollment->employee->photo)
                        <img src="{{ asset('storage/' . $enrollment->employee->photo) }}" alt="صورة الموظف" class="img-fluid rounded-circle mb-3" width="120">
                    @else
                        <div class="avatar-lg mx-auto mb-3">
                            <span class="avatar-title bg-primary text-white rounded-circle">
                                {{ substr($enrollment->employee->name, 0, 1) }}
                            </span>
                        </div>
                    @endif
                    <h4>{{ $enrollment->employee->name }}</h4>
                    <p class="text-muted">{{ $enrollment->employee->position?->name ?? 'غير محدد' }}</p>
                    <p class="text-muted">{{ $enrollment->employee->department?->name ?? 'غير محدد' }}</p>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ $enrollment->employee->enrollments->count() }}</h5>
                            <p class="text-muted mb-0">التسجيلات</p>
                        </div>
                        <div class="col-6">
                            <h5>{{ $enrollment->employee->enrollments->where('status', 'completed')->count() }}</h5>
                            <p class="text-muted mb-0">المكتملة</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Program Info -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">معلومات البرنامج</h5>
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar-md me-3">
                            <span class="avatar-title bg-success text-white rounded-circle">
                                <i class="fas fa-graduation-cap"></i>
                            </span>
                        </div>
                        <div>
                            <h6 class="mb-1">{{ $enrollment->program->title }}</h6>
                            <p class="mb-0 text-muted">{{ $enrollment->program->category_name }}</p>
                        </div>
                    </div>
                    <table class="table table-borderless">
                        <tr>
                            <th>المدرب:</th>
                            <td>{{ $enrollment->program->trainer->name ?? 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>المدة:</th>
                            <td>{{ $enrollment->program->duration }} {{ $enrollment->program->duration_unit == 'hours' ? 'ساعة' : 'يوم' }}</td>
                        </tr>
                        <tr>
                            <th>التواريخ:</th>
                            <td>
                                {{ $enrollment->program->start_date->format('Y-m-d') }}  

                                {{ $enrollment->program->end_date->format('Y-m-d') }}
                            </td>
                        </tr>
                        <tr>
                            <th>الحالة:</th>
                            <td>
                                @if($enrollment->program->status == 'upcoming')
                                    <span class="badge badge-warning">قادم</span>
                                @elseif($enrollment->program->status == 'active')
                                    <span class="badge badge-success">جاري</span>
                                @elseif($enrollment->program->status == 'completed')
                                    <span class="badge badge-info">مكتمل</span>
                                @elseif($enrollment->program->status == 'cancelled')
                                    <span class="badge badge-danger">ملغى</span>
                                @endif
                            </td>
                        </tr>
                    </table>
                    <div class="mt-3">
                        <a href="{{ route('training.show', $enrollment->program) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye"></i> عرض البرنامج
                        </a>
                    </div>
                </div>
            </div>

            <!-- Certificate -->
            @if($enrollment->status == 'completed' && $enrollment->certificate_url)
            <div class="card mt-4">
                <div class="card-body text-center">
                    <div class="avatar-lg mx-auto mb-3">
                        <span class="avatar-title bg-success text-white rounded-circle">
                            <i class="fas fa-certificate"></i>
                        </span>
                    </div>
                    <h5>شهادة إتمام التدريب</h5>
                    <p class="text-muted">تم إكمال البرنامج بنجاح</p>
                    <a href="{{ $enrollment->certificate_url }}" class="btn btn-success" target="_blank">
                        <i class="fas fa-download"></i> تحميل الشهادة
                    </a>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- Update Progress Modal -->
<div class="modal fade" id="updateProgressModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تحديث تقدم التدريب</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('training.enrollments.update', $enrollment) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="progress_percentage" class="form-label">نسبة التقدم</label>
                        <input type="number" class="form-control" id="progress_percentage" name="progress_percentage" 
                               value="{{ old('progress_percentage', $enrollment->progress_percentage) }}" min="0" max="100" required>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-control" id="status" name="status" required>
                            <option value="enrolled" {{ old('status', $enrollment->status) == 'enrolled' ? 'selected' : '' }}>مسجل</option>
                            <option value="in_progress" {{ old('status', $enrollment->status) == 'in_progress' ? 'selected' : '' }}>قيد التدريب</option>
                            <option value="completed" {{ old('status', $enrollment->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                            <option value="cancelled" {{ old('status', $enrollment->status) == 'cancelled' ? 'selected' : '' }}>ملغى</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="score" class="form-label">النتيجة (%)</label>
                        <input type="number" class="form-control" id="score" name="score" 
                               value="{{ old('score', $enrollment->score) }}" min="0" max="100">
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2">{{ old('notes', $enrollment->notes) }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تحديث</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection