@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تسجيلات التدريب</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item active">التسجيلات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">جميع التسجيلات</h4>
                        <div class="btn-group">
                            @can('export training enrollment')
                            <button class="btn btn-success">
                                <i class="fas fa-file-export"></i> تصدير
                            </button>
                            @endcan
                        </div>
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="البحث عن موظف أو برنامج...">
                        </div>
                        <div class="col-md-2">
                            <select id="programFilter" class="form-control">
                                <option value="">جميع البرامج</option>
                                @foreach($programs as $program)
                                    <option value="{{ $program->id }}">{{ $program->title }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">جميع الحالات</option>
                                <option value="enrolled">مسجل</option>
                                <option value="in_progress">قيد التدريب</option>
                                <option value="completed">مكتمل</option>
                                <option value="cancelled">ملغى</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="departmentFilter" class="form-control">
                                <option value="">جميع الأقسام</option>
                                <option value="HR">الموارد البشرية</option>
                                <option value="IT">تقنية المعلومات</option>
                                <option value="Finance">المالية</option>
                                <option value="Marketing">التسويق</option>
                                <option value="Operations">العمليات</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group">
                                <input type="date" id="startDateFilter" class="form-control" placeholder="من تاريخ">
                                <input type="date" id="endDateFilter" class="form-control" placeholder="إلى تاريخ">
                            </div>
                        </div>
                    </div>

                    <!-- Enrollments Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>الموظف</th>
                                    <th>البرنامج</th>
                                    <th>المدرب</th>
                                    <th>تاريخ التسجيل</th>
                                    <th>الحالة</th>
                                    <th>التقدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($enrollments as $enrollment)
                                <tr>
                                    <td>{{ $enrollment->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($enrollment->employee->photo)
                                                <img src="{{ asset('storage/' . $enrollment->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        {{ substr($enrollment->employee->name, 0, 1) }}
                                                    </span>
                                                </div>
                                            @endif
                                            <div>
                                                <h6 class="mb-0">{{ $enrollment->employee->name }}</h6>
                                                <small class="text-muted">{{ $enrollment->employee->employee_id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $enrollment->program->title }}</h6>
                                        <small class="text-muted">{{ $enrollment->program->category_name }}</small>
                                    </td>
                                    <td>{{ $enrollment->program->trainer->name ?? 'غير محدد' }}</td>
                                    <td>{{ $enrollment->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        @if($enrollment->status == 'enrolled')
                                            <span class="badge badge-warning">مسجل</span>
                                        @elseif($enrollment->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التدريب</span>
                                        @elseif($enrollment->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($enrollment->status == 'cancelled')
                                            <span class="badge badge-danger">ملغى</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 10px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $enrollment->progress_percentage ?? 0 }}%" 
                                                 aria-valuenow="{{ $enrollment->progress_percentage ?? 0 }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small>{{ $enrollment->progress_percentage ?? 0 }}%</small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view training enrollment')
                                            <a href="{{ route('training.enrollments.show', $enrollment) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('update training enrollment')
                                            @if(in_array($enrollment->status, ['enrolled', 'in_progress']))
                                            <button class="btn btn-success btn-sm" title="تحديث التقدم" 
                                                    data-bs-toggle="modal" data-bs-target="#updateProgressModal"
                                                    data-enrollment-id="{{ $enrollment->id }}">
                                                <i class="fas fa-sync-alt"></i>
                                            </button>
                                            @endif
                                            @endcan

                                            @can('delete training enrollment')
                                            <form action="{{ route('training.enrollments.destroy', $enrollment) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="إزالة" 
                                                        onclick="return confirm('{{ addslashes(__('app.confirm_remove_enrollment')) }}')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">
                                        <i class="fas fa-list fa-3x mb-3"></i>
                                        <h5>لا توجد تسجيلات تدريب</h5>
                                        <p class="text-muted">ابدأ بتسجيل موظفين في البرامج التدريبية</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($enrollments->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $enrollments->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Enrollment Summary -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">ملخص التسجيلات</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>البرنامج</th>
                                    <th>السعة</th>
                                    <th>المسجلون</th>
                                    <th>قيد التدريب</th>
                                    <th>المكتملون</th>
                                    <th>ال利用率</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($programs as $program)
                                <tr>
                                    <td>{{ $program->title }}</td>
                                    <td>{{ $program->capacity }}</td>
                                    <td>{{ $program->enrollments->count() }}</td>
                                    <td>{{ $program->enrollments->whereIn('status', ['enrolled', 'in_progress'])->count() }}</td>
                                    <td>{{ $program->enrollments->where('status', 'completed')->count() }}</td>
                                    <td>
                                        @php
                                            $utilization = $program->capacity > 0 ? ($program->enrollments->count() / $program->capacity) * 100 : 0;
                                        @endphp
                                        <div class="progress" style="height: 10px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: {{ $utilization }}%" 
                                                 aria-valuenow="{{ $utilization }}" 
                                                 aria-valuemin="0" aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small>{{ number_format($utilization, 1) }}%</small>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد برامج تدريبية</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Update Progress Modal -->
<div class="modal fade" id="updateProgressModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تحديث تقدم التدريب</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="updateProgressForm" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <input type="hidden" id="enrollmentId" name="enrollment_id">
                    <div class="mb-3">
                        <label for="progress_percentage" class="form-label">نسبة التقدم</label>
                        <input type="number" class="form-control" id="progress_percentage" name="progress_percentage" min="0" max="100" required>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-control" id="status" name="status" required>
                            <option value="enrolled">مسجل</option>
                            <option value="in_progress">قيد التدريب</option>
                            <option value="completed">مكتمل</option>
                            <option value="cancelled">ملغى</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تحديث</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update Progress Modal
    var updateProgressModal = document.getElementById('updateProgressModal');
    if(updateProgressModal) {
        updateProgressModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var enrollmentId = button.getAttribute('data-enrollment-id');
            
            var modal = this;
            modal.querySelector('#enrollmentId').value = enrollmentId;
            modal.querySelector('#updateProgressForm').action = '/training/enrollments/' + enrollmentId;
        });
    }

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const programFilter = document.getElementById('programFilter');
    const statusFilter = document.getElementById('statusFilter');
    const departmentFilter = document.getElementById('departmentFilter');
    const startDateFilter = document.getElementById('startDateFilter');
    const endDateFilter = document.getElementById('endDateFilter');

    function filterTable() {
        console.log('Filtering enrollments...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (programFilter) programFilter.addEventListener('change', filterTable);
    if (statusFilter) statusFilter.addEventListener('change', filterTable);
    if (departmentFilter) departmentFilter.addEventListener('change', filterTable);
    if (startDateFilter) startDateFilter.addEventListener('change', filterTable);
    if (endDateFilter) endDateFilter.addEventListener('change', filterTable);
});
</script>
@endsection