@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تعديل التسجيل في التدريب</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.enrollments.index') }}">التسجيلات</a></li>
                        <li class="breadcrumb-item active">تعديل التسجيل</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تعديل التسجيل</h4>

                    <form action="{{ route('training.enrollments.update', $enrollment) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">البرنامج</label>
                                <input type="text" class="form-control" value="{{ $enrollment->program->title }}" readonly>
                                <input type="hidden" name="program_id" value="{{ $enrollment->program_id }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الموظف</label>
                                <input type="text" class="form-control" value="{{ $enrollment->employee->name }}" readonly>
                                <input type="hidden" name="employee_id" value="{{ $enrollment->employee_id }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="progress_percentage" class="form-label">نسبة التقدم <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="progress_percentage" name="progress_percentage" value="{{ old('progress_percentage', $enrollment->progress_percentage) }}" min="0" max="100" required>
                                @error('progress_percentage')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="enrolled" {{ old('status', $enrollment->status) == 'enrolled' ? 'selected' : '' }}>مسجل</option>
                                    <option value="in_progress" {{ old('status', $enrollment->status) == 'in_progress' ? 'selected' : '' }}>قيد التدريب</option>
                                    <option value="completed" {{ old('status', $enrollment->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                    <option value="cancelled" {{ old('status', $enrollment->status) == 'cancelled' ? 'selected' : '' }}>ملغى</option>
                                </select>
                                @error('status')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="score" class="form-label">النتيجة</label>
                                <input type="number" class="form-control" id="score" name="score" value="{{ old('score', $enrollment->score) }}" min="0" max="100">
                                @error('score')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control" id="notes" name="notes" rows="2">{{ old('notes', $enrollment->notes) }}</textarea>
                            @error('notes')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-sync-alt"></i> تحديث التسجيل
                            </button>
                            <a href="{{ route('training.enrollments.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Enrollment Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات التسجيل</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>تاريخ التسجيل:</th>
                            <td>{{ $enrollment->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>آخر تحديث:</th>
                            <td>{{ $enrollment->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection