@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تعديل البرنامج التدريبي</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item active">تعديل البرنامج</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تعديل البرنامج</h4>

                    <form action="{{ route('training.update', $program) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="title" class="form-label">اسم البرنامج <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $program->title) }}" required>
                                @error('title')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="category" class="form-label">الفئة <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="technical" {{ old('category', $program->category) == 'technical' ? 'selected' : '' }}>تقني</option>
                                    <option value="management" {{ old('category', $program->category) == 'management' ? 'selected' : '' }}>إداري</option>
                                    <option value="soft_skills" {{ old('category', $program->category) == 'soft_skills' ? 'selected' : '' }}>مهارات لينة</option>
                                    <option value="safety" {{ old('category', $program->category) == 'safety' ? 'selected' : '' }}>سلامة</option>
                                    <option value="compliance" {{ old('category', $program->category) == 'compliance' ? 'selected' : '' }}>امتثال</option>
                                </select>
                                @error('category')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $program->description) }}</textarea>
                            @error('description')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="trainer_id" class="form-label">المدرب</label>
                                <select class="form-control" id="trainer_id" name="trainer_id">
                                    <option value="">اختر مدرباً</option>
                                    @foreach($trainers as $trainer)
                                        <option value="{{ $trainer->id }}" {{ old('trainer_id', $program->trainer_id) == $trainer->id ? 'selected' : '' }}>
                                            {{ $trainer->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('trainer_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="location" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="location" name="location" value="{{ old('location', $program->location) }}">
                                @error('location')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="capacity" class="form-label">السعة <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="capacity" name="capacity" value="{{ old('capacity', $program->capacity) }}" min="1" max="1000" required>
                                @error('capacity')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="duration" class="form-label">المدة <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="duration" name="duration" value="{{ old('duration', $program->duration) }}" min="1" max="365" required>
                                @error('duration')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="duration_unit" class="form-label">وحدة المدة <span class="text-danger">*</span></label>
                                <select class="form-control" id="duration_unit" name="duration_unit" required>
                                    <option value="hours" {{ old('duration_unit', $program->duration_unit) == 'hours' ? 'selected' : '' }}>ساعات</option>
                                    <option value="days" {{ old('duration_unit', $program->duration_unit) == 'days' ? 'selected' : '' }}>أيام</option>
                                </select>
                                @error('duration_unit')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $program->start_date->format('Y-m-d')) }}" required>
                                @error('start_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="end_date" class="form-label">تاريخ الانتهاء <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date', $program->end_date->format('Y-m-d')) }}" required>
                                @error('end_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> تحديث البرنامج
                            </button>
                            <a href="{{ route('training.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Program Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات البرنامج</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>الحالة:</th>
                            <td>
                                @if($program->status == 'upcoming')
                                    <span class="badge badge-warning">قادم</span>
                                @elseif($program->status == 'active')
                                    <span class="badge badge-success">جاري</span>
                                @elseif($program->status == 'completed')
                                    <span class="badge badge-info">مكتمل</span>
                                @elseif($program->status == 'cancelled')
                                    <span class="badge badge-danger">ملغى</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>تاريخ الإنشاء:</th>
                            <td>{{ $program->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>آخر تحديث:</th>
                            <td>{{ $program->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection