@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">إنشاء برنامج تدريبي جديد</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('training.index') }}">التدريب</a></li>
                        <li class="breadcrumb-item active">برنامج جديد</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج البرنامج التدريبي</h4>

                    <form action="{{ route('training.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="title" class="form-label">اسم البرنامج <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                @error('title')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="category" class="form-label">الفئة <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" name="category" required>
                                    <option value="">اختر الفئة</option>
                                    <option value="technical" {{ old('category') == 'technical' ? 'selected' : '' }}>تقني</option>
                                    <option value="management" {{ old('category') == 'management' ? 'selected' : '' }}>إداري</option>
                                    <option value="soft_skills" {{ old('category') == 'soft_skills' ? 'selected' : '' }}>مهارات لينة</option>
                                    <option value="safety" {{ old('category') == 'safety' ? 'selected' : '' }}>سلامة</option>
                                    <option value="compliance" {{ old('category') == 'compliance' ? 'selected' : '' }}>امتثال</option>
                                </select>
                                @error('category')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="trainer_id" class="form-label">المدرب</label>
                                <select class="form-control" id="trainer_id" name="trainer_id">
                                    <option value="">اختر مدرباً</option>
                                    @foreach($trainers as $trainer)
                                        <option value="{{ $trainer->id }}" {{ old('trainer_id') == $trainer->id ? 'selected' : '' }}>
                                            {{ $trainer->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('trainer_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="location" class="form-label">الموقع</label>
                                <input type="text" class="form-control" id="location" name="location" value="{{ old('location') }}">
                                @error('location')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="capacity" class="form-label">السعة <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="capacity" name="capacity" value="{{ old('capacity', 10) }}" min="1" max="1000" required>
                                @error('capacity')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="duration" class="form-label">المدة <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="duration" name="duration" value="{{ old('duration', 1) }}" min="1" max="365" required>
                                @error('duration')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="duration_unit" class="form-label">وحدة المدة <span class="text-danger">*</span></label>
                                <select class="form-control" id="duration_unit" name="duration_unit" required>
                                    <option value="hours" {{ old('duration_unit') == 'hours' ? 'selected' : '' }}>ساعات</option>
                                    <option value="days" {{ old('duration_unit') == 'days' ? 'selected' : '' }}>أيام</option>
                                </select>
                                @error('duration_unit')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date') }}" required>
                                @error('start_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="end_date" class="form-label">تاريخ الانتهاء <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date') }}" required>
                                @error('end_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="trainees" class="form-label">المتدربون المحتملون</label>
                            <select class="form-control select2" name="trainees[]" multiple>
                                <option value="">اختر المتدربين</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}" {{ in_array($employee->id, old('trainees', [])) ? 'selected' : '' }}>
                                        {{ $employee->name }} - {{ $employee->employee_id }}
                                    </option>
                                @endforeach
                            </select>
                            @error('trainees')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save"></i> إنشاء البرنامج
                            </button>
                            <a href="{{ route('training.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection