@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <div>
                <h1 class="h3">مستخدمو الشركة: {{ $company->name }}</h1>
                <p class="text-muted">إجمالي المستخدمين: {{ $users->count() }}</p>
            </div>
            <a href="{{ route('super-admin.users.create', $company) }}" class="btn btn-success">
                <i class="fas fa-plus"></i> إضافة مستخدم جديد
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>الدور</th>
                                    <th>الحالة</th>
                                    <th>آخر دخول</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>
                                            <strong>{{ $user->name }}</strong>
                                            @if($user->isLocked())
                                                <br><small class="text-danger">مقفول</small>
                                            @endif
                                        </td>
                                        <td>{{ $user->email }}</td>
                                        <td>
                                            @if($user->role === 'super_admin')
                                                <span class="badge bg-danger">سوبر أدمن</span>
                                            @elseif($user->role === 'admin')
                                                <span class="badge bg-danger">مسؤول</span>
                                            @elseif($user->role === 'manager')
                                                <span class="badge bg-warning">مدير</span>
                                            @else
                                                <span class="badge bg-info">موظف</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $user->getStatusColor() }}">
                                                {{ $user->getStatusText() }}
                                            </span>
                                        </td>
                                        <td>
                                            @if($user->last_login_at)
                                                {{ $user->last_login_at->format('Y-m-d H:i') }}
                                                @if($user->last_login_ip)
                                                    <br><small class="text-muted">{{ $user->last_login_ip }}</small>
                                                @endif
                                            @else
                                                <span class="text-muted">لم يسجل دخول</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('super-admin.users.edit', [$company, $user]) }}" class="btn btn-outline-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                
                                                @if($user->isSuspended())
                                                    <form action="{{ route('super-admin.users.unsuspend', [$company, $user]) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        <button type="submit" class="btn btn-outline-success" title="إعادة تفعيل">
                                                            <i class="fas fa-play"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <button type="button" class="btn btn-outline-warning" data-bs-toggle="modal" data-bs-target="#suspendModal{{ $user->id }}" title="إيقاف">
                                                        <i class="fas fa-pause"></i>
                                                    </button>
                                                @endif
                                                
                                                @if(!$user->is_active)
                                                    <form action="{{ route('super-admin.users.activate', [$company, $user]) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        <button type="submit" class="btn btn-outline-success" title="تفعيل">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#deactivateModal{{ $user->id }}" title="إلغاء تفعيل">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                @endif
                                                
                                                <button type="button" class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#passwordModal{{ $user->id }}" title="إعادة كلمة المرور">
                                                    <i class="fas fa-key"></i>
                                                </button>
                                                
                                                <form action="{{ route('super-admin.users.impersonate', [$company, $user]) }}" method="POST" style="display: inline;">
                                                    @csrf
                                                    <button type="submit" class="btn btn-outline-primary" title="محاكاة دخول">
                                                        <i class="fas fa-user-secret"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    
                                    <!-- Suspend Modal -->
                                    <div class="modal fade" id="suspendModal{{ $user->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('super-admin.users.suspend', [$company, $user]) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">إيقاف المستخدم</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>هل أنت متأكد من إيقاف المستخدم <strong>{{ $user->name }}</strong>؟</p>
                                                        <div class="mb-3">
                                                            <label class="form-label">السبب</label>
                                                            <textarea name="reason" class="form-control" required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        <button type="submit" class="btn btn-warning">إيقاف المستخدم</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Deactivate Modal -->
                                    <div class="modal fade" id="deactivateModal{{ $user->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('super-admin.users.deactivate', [$company, $user]) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">إلغاء تفعيل المستخدم</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>هل أنت متأكد من إلغاء تفعيل المستخدم <strong>{{ $user->name }}</strong>؟</p>
                                                        <p class="text-warning">لن يتمكن المستخدم من تسجيل الدخول!</p>
                                                        <div class="mb-3">
                                                            <label class="form-label">السبب</label>
                                                            <textarea name="reason" class="form-control" required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        <button type="submit" class="btn btn-secondary">إلغاء التفعيل</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Password Reset Modal -->
                                    <div class="modal fade" id="passwordModal{{ $user->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('super-admin.users.reset-password', [$company, $user]) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">إعادة تعيين كلمة المرور</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>إعادة تعيين كلمة المرور للمستخدم <strong>{{ $user->name }}</strong></p>
                                                        <div class="mb-3">
                                                            <label class="form-label">كلمة المرور الجديدة</label>
                                                            <input type="password" name="new_password" class="form-control" required minlength="8">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">تأكيد كلمة المرور</label>
                                                            <input type="password" name="new_password_confirmation" class="form-control" required minlength="8">
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                        <button type="submit" class="btn btn-info">إعادة التعيين</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا يوجد مستخدمون لهذه الشركة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @if($users->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $users->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="mt-3">
        <a href="{{ route('super-admin.companies.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> رجوع إلى الشركات
        </a>
    </div>
</div>
@endsection
