@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 d-inline-block mr-2">لوحة تحكم السوبر أدمن</h1>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="card-title">عدد الشركات</h5>
                    <p class="card-text display-4">{{ $companiesCount }}</p>
                    <a href="{{ route('super-admin.companies.index') }}" class="btn btn-light btn-sm">
                        <i class="fas fa-building"></i> إدارة الشركات
                    </a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">عدد المستخدمين</h5>
                    <p class="card-text display-4">{{ $usersCount }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="card-title">الشركات النشطة</h5>
                    <p class="card-text display-4">{{ $companies->where('status', 'active')->count() }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5 class="card-title">الشركات الموقوفة</h5>
                    <p class="card-text display-4">{{ $companies->where('status', 'suspended')->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Companies List -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">الشركات وحالتها</h5>
                    <a href="{{ route('super-admin.companies.create') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-plus"></i> إضافة شركة جديدة
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>اسم الشركة</th>
                                    <th>الحالة</th>
                                    <th>حالة الدفع</th>
                                    <th>المستخدمون</th>
                                    <th>تاريخ الدفع التالي</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($companies as $company)
                                <tr>
                                    <td>{{ $company->id }}</td>
                                    <td>
                                        <strong>{{ $company->name }}</strong><br>
                                        <small class="text-muted">{{ $company->email }}</small>
                                    </td>
                                    <td>
                                        @if($company->isActive())
                                            <span class="badge bg-success">نشطة</span>
                                        @elseif($company->isSuspended())
                                            <span class="badge bg-danger">موقوفة</span>
                                        @else
                                            <span class="badge bg-warning">غير نشطة</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $company->getPaymentStatusColor() }}">
                                            {{ $company->payment_status }}
                                        </span>
                                        @if($company->isPaymentOverdue())
                                            <br><small class="text-danger">متأخر</small>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('super-admin.users.index', $company) }}" class="btn btn-sm btn-outline-primary">
                                            {{ $company->users()->count() }} مستخدم
                                        </a>
                                    </td>
                                    <td>
                                        @if($company->next_payment_date)
                                            {{ $company->next_payment_date->format('Y-m-d') }}
                                            @if($company->getDaysUntilPaymentDue() <= 7)
                                                <br><small class="text-warning">قريب</small>
                                            @endif
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('super-admin.companies.edit', $company) }}" class="btn btn-outline-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($company->isSuspended())
                                                <form action="{{ route('super-admin.companies.unsuspend', $company) }}" method="POST" style="display: inline;">
                                                    @csrf
                                                    <button type="submit" class="btn btn-outline-success" title="إعادة تفعيل">
                                                        <i class="fas fa-play"></i>
                                                    </button>
                                                </form>
                                            @else
                                                <button type="button" class="btn btn-outline-warning" data-bs-toggle="modal" data-bs-target="#suspendModal{{ $company->id }}" title="إيقاف">
                                                    <i class="fas fa-pause"></i>
                                                </button>
                                            @endif
                                            <button type="button" class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#paymentModal{{ $company->id }}" title="تحديث الدفع">
                                                <i class="fas fa-dollar-sign"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                
                                <!-- Suspend Modal -->
                                <div class="modal fade" id="suspendModal{{ $company->id }}" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form action="{{ route('super-admin.companies.suspend', $company) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title">إيقاف الشركة</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>هل أنت متأكد من إيقاف شركة <strong>{{ $company->name }}</strong>؟</p>
                                                    <p class="text-warning">سيتم إيقاف جميع مستخدمي الشركة أيضاً!</p>
                                                    <div class="mb-3">
                                                        <label class="form-label">السبب</label>
                                                        <textarea name="reason" class="form-control" required></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-warning">إيقاف الشركة</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Payment Modal -->
                                <div class="modal fade" id="paymentModal{{ $company->id }}" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form action="{{ route('super-admin.companies.payment', $company) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title">تحديث حالة الدفع</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mb-3">
                                                        <label class="form-label">حالة الدفع</label>
                                                        <select name="payment_status" class="form-control" required>
                                                            <option value="paid" {{ $company->payment_status == 'paid' ? 'selected' : '' }}>مدفوع</option>
                                                            <option value="pending" {{ $company->payment_status == 'pending' ? 'selected' : '' }}>في الانتظار</option>
                                                            <option value="overdue" {{ $company->payment_status == 'overdue' ? 'selected' : '' }}>متأخر</option>
                                                            <option value="cancelled" {{ $company->payment_status == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                                        </select>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">المبلغ المدفوع</label>
                                                        <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" required>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">ملاحظات</label>
                                                        <textarea name="payment_notes" class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-primary">تحديث</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
