@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h1 class="h3">إدارة الشركات</h1>
            <a href="{{ route('super-admin.companies.create') }}" class="btn btn-success">
                <i class="fas fa-plus"></i> إضافة شركة جديدة
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>اسم الشركة</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>الهاتف</th>
                                    <th>المدينة</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($companies as $company)
                                    <tr>
                                        <td>{{ $company->id }}</td>
                                        <td>{{ $company->name }}</td>
                                        <td>{{ $company->email }}</td>
                                        <td>{{ $company->phone ?? '-' }}</td>
                                        <td>{{ $company->city ?? '-' }}</td>
                                        <td>
                                            @if($company->status === 'active')
                                                <span class="badge bg-success">نشط</span>
                                            @elseif($company->status === 'inactive')
                                                <span class="badge bg-warning">غير نشط</span>
                                            @else
                                                <span class="badge bg-danger">معلق</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('super-admin.users.index', $company) }}" class="btn btn-info btn-sm" title="المستخدمون">
                                                <i class="fas fa-users"></i>
                                            </a>
                                            <a href="{{ route('super-admin.companies.edit', $company) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('super-admin.companies.destroy', $company) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="حذف" onclick="return confirm('هل أنت متأكد؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">لا توجد شركات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $companies->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
