{{-- resources/views/settings/currency.blade.php --}}

@extends('layouts.app')

@section('title', __('settings.currency.title'))

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('settings.currency.page_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('settings.currency.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('settings.currency.page_title') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">{{ __('settings.currency.choose_currency') }}</h5>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <form action="{{ route('settings.update.currency') }}" method="POST">
                        @csrf
                        @method('POST') {{-- أو PUT إذا كنت تفضل --}}

                        <div class="mb-3">
                            <label for="currency" class="form-label">{{ __('settings.currency.select_label') }}</label>
                            <select name="currency" id="currency" class="form-control select2" required>
                                <option value="">{{ __('settings.currency.select_placeholder') }}</option>
                                @foreach($availableCurrencies as $code => $label)
                                    <option value="{{ $code }}" {{ ($currentCurrency === $code) ? 'selected' : '' }}>
                                        {{ __('settings.currencies.' . $code) ?: $label }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save me-1"></i> {{ __('settings.currency.save') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection