{{-- resources/views/payroll/show.blade.php --}}
@extends('layouts.app')

@section('content')
@php
    // تعريف المتغيرات العامة لاستخدامها في جميع الأقسام
    $components = $payroll->payrollSalaryComponents ?? collect();
    $additionsTotal = 0;
    $deductionsTotal = 0;
    foreach($components as $comp) {
        if ($comp->value > 0) {
            $additionsTotal += $comp->value;
        } else {
            $deductionsTotal += abs($comp->value);
        }
    }
@endphp
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تفاصيل الراتب الشامل</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('payroll.index') }}">الرواتب</a></li>
                        <li class="breadcrumb-item active">الراتب #{{ $payroll->id }}</li>
                    </ol>
                </div>
            </div>

            <!-- تفاصيل شاملة للإضافات والخصومات -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">📊 تفاصيل الراتب الشامل</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- الإضافات -->
                        <div class="col-md-6">
                            <h6 class="text-success fw-bold mb-3">✅ الإضافات (الراتب الإجمالي)</h6>
                            <table class="table table-sm table-bordered">
                                <tbody>
                                    <tr>
                                        <td><strong>الراتب الأساسي</strong></td>
                                        <td class="text-end fw-bold">{{ number_format($payroll->basic_salary, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>الحوافز</strong></td>
                                        <td class="text-end fw-bold">{{ number_format($payroll->incentives, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                    @php
                                        $components = $payroll->payrollSalaryComponents ?? collect();
                                        $additionsTotal = 0;
                                        $deductionsTotal = 0;
                                    @endphp
                                    @foreach($components as $comp)
                                        @if($comp->value > 0)
                                            @php
                                                $label = $comp->name;
                                                if ($label === 'Overtime') {
                                                    $label = 'أوفر تايم';
                                                } elseif ($label === 'Paid Off-day Compensation') {
                                                    $label = 'تعويض أيام الحضور المدفوعة';
                                                } elseif (\Illuminate\Support\Str::contains($label ?? '', 'Underworked')) {
                                                    $label = 'خصم نقصان ساعات';
                                                }
                                            @endphp
                                            <tr>
                                                <td>{{ $label }}</td>
                                                <td class="text-end text-success">+ {{ number_format($comp->value, 2) }} {{ $currency_name }}</td>
                                            </tr>
                                            @php $additionsTotal += $comp->value; @endphp
                                        @endif
                                    @endforeach
                                    <tr class="table-success">
                                        <td><strong>إجمالي الإضافات</strong></td>
                                        <td class="text-end fw-bold text-success">{{ number_format($payroll->basic_salary + $payroll->incentives + $additionsTotal, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- الخصومات -->
                        <div class="col-md-6">
                            <h6 class="text-danger fw-bold mb-3">❌ الخصومات</h6>
                            <table class="table table-sm table-bordered">
                                <tbody>
                                    <tr>
                                        <td><strong>الخصومات النشطة</strong></td>
                                        <td class="text-end text-danger">- {{ number_format($payroll->active_deductions, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>أقساط القروض</strong></td>
                                        <td class="text-end text-danger">- {{ number_format($payroll->loan_installments, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>خصم الإجازات</strong></td>
                                        <td class="text-end text-danger">- {{ number_format($payroll->leave_deduction, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                    @foreach($components as $comp)
                                        @if($comp->value < 0)
                                            @php
                                                $label = $comp->name;
                                                if ($label === 'Overtime') {
                                                    $label = 'أوفر تايم';
                                                } elseif ($label === 'Paid Off-day Compensation') {
                                                    $label = 'تعويض أيام الحضور المدفوعة';
                                                } elseif (\Illuminate\Support\Str::contains($label ?? '', 'Underworked')) {
                                                    $label = 'خصم نقصان ساعات';
                                                }
                                            @endphp
                                            <tr>
                                                <td>{{ $label }}</td>
                                                <td class="text-end text-danger">{{ number_format($comp->value, 2) }} {{ $currency_name }}</td>
                                            </tr>
                                            @php $deductionsTotal += abs($comp->value); @endphp
                                        @endif
                                    @endforeach
                                    <tr class="table-danger">
                                        <td><strong>إجمالي الخصومات</strong></td>
                                        <td class="text-end fw-bold text-danger">- {{ number_format($payroll->active_deductions + $payroll->loan_installments + $payroll->leave_deduction + $deductionsTotal, 2) }} {{ $currency_name }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- تفاصيل الأيام التي بها نقص في ساعات العمل أو أوفر تايم والخصم المقابل -->
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="card-title mb-0">📅 أيام نقص ساعات العمل والأوفر تايم والخصم</h5>
                </div>
                <div class="card-body">
                    @php
                        $attendanceSummaryDays = $attendanceDetails
                            ? $attendanceDetails->filter(function ($d) {
                                return ($d['underworked_hours'] ?? 0) > 0 || ($d['overtime_hours'] ?? 0) > 0;
                            })
                            : collect();
                    @endphp
                    @if($attendanceSummaryDays->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>التاريخ</th>
                                    <th class="text-end">ساعات النقص</th>
                                    <th class="text-end">قيمة الخصم ({{ $currency_name }})</th>
                                    <th class="text-end">ساعات الأوفر تايم</th>
                                    <th class="text-end">قيمة الأوفر تايم ({{ $currency_name }})</th>
                                    <th class="text-end">أيام العطلات المدفوعة</th>
                                    <th class="text-end">أجر اليوم ({{ $currency_name }})</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($attendanceSummaryDays as $detail)
                                <tr>
                                    <td><strong>{{ \Carbon\Carbon::parse($detail['date'])->format('Y-m-d') }}</strong></td>
                                    <td class="text-end fw-bold">
                                        @php $uw = $detail['underworked_hours'] ?? 0; @endphp
                                        {{ $uw > 0 ? number_format($uw, 2) . ' ساعة' : '-' }}
                                    </td>
                                    <td class="text-end fw-bold text-danger">
                                        @php $uwv = $detail['underworked_value'] ?? 0; @endphp
                                        {{ $uwv > 0 ? number_format($uwv, 2) . ' ' . $currency_name : '-' }}
                                    </td>
                                    <td class="text-end fw-bold text-success">
                                        @php $ot = $detail['overtime_hours'] ?? 0; @endphp
                                        {{ $ot > 0 ? number_format($ot, 2) . ' ساعة' : '-' }}
                                    </td>
                                    <td class="text-end fw-bold text-success">
                                        @php $otv = $detail['overtime_value'] ?? 0; @endphp
                                        {{ $otv > 0 ? number_format($otv, 2) . ' ' . $currency_name : '-' }}
                                    </td>
                                    <td class="text-end">-</td>
                                    <td class="text-end">-</td>
                                </tr>
                                @endforeach
                                
                                {{-- عرض أيام العطلات المدفوعة --}}
                                @if(isset($paidOffAttendances) && $paidOffAttendances->count() > 0)
                                    @foreach($paidOffAttendances as $attendance)
                                    <tr>
                                        <td><strong>{{ \Carbon\Carbon::parse($attendance->date)->format('Y-m-d') }}</strong></td>
                                        <td class="text-end">-</td>
                                        <td class="text-end">-</td>
                                        <td class="text-end">-</td>
                                        <td class="text-end">-</td>
                                        <td class="text-end text-success fw-bold">
                                            <i class="fas fa-check-circle"></i> يوم عطلة مدفوع
                                        </td>
                                        <td class="text-end text-success fw-bold">
                                            @php
                                                // حساب أجر اليوم المدفوع
                                                $dailyRatePaidOff = 0;
                                                if (!empty($payroll->employee->default_paid_off_amount) && $payroll->employee->default_paid_off_amount > 0) {
                                                    $dailyRatePaidOff = $payroll->employee->default_paid_off_amount;
                                                } elseif (!empty($dailyRate) && $dailyRate > 0) {
                                                    $dailyRatePaidOff = $dailyRate;
                                                }
                                            @endphp
                                            {{ number_format($dailyRatePaidOff, 2) }} {{ $currency_name }}
                                        </td>
                                    </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                    @else
                        <p class="text-muted text-center">لا توجد أيام بها نقص في ساعات العمل أو أوفر تايم خلال هذا الشهر.</p>
                    @endif
                </div>
            </div>

            <!-- تفاصيل الاستقطاعات -->
            <div class="card mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="card-title mb-0">💰 تفاصيل الاستقطاعات</h5>
                </div>
                <div class="card-body">
                    @if($actualDeductions && $actualDeductions->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th>نوع الاستقطاع</th>
                                    <th>الوصف</th>
                                    <th>التاريخ</th>
                                    <th>التكرار</th>
                                    <th class="text-end">المبلغ ({{ $currency_name }})</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($actualDeductions as $deduction)
                                <tr>
                                    <td><strong>{{ $deduction->type_arabic ?? $deduction->type }}</strong></td>
                                    <td>{{ $deduction->description ?? '-' }}</td>
                                    <td>{{ \Carbon\Carbon::parse($deduction->deduction_date)->format('Y-m-d') }}</td>
                                    <td>
                                        @if($deduction->frequency === 'monthly' || $deduction->is_monthly)
                                            <span class="badge bg-primary">شهري</span>
                                        @elseif($deduction->frequency === 'yearly')
                                            <span class="badge bg-info">سنوي</span>
                                        @else
                                            <span class="badge bg-secondary">مرة واحدة</span>
                                        @endif
                                    </td>
                                    <td class="text-end fw-bold text-danger">{{ number_format($deduction->amount, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <th colspan="4">إجمالي الاستقطاعات</th>
                                    <th class="text-end fw-bold text-danger">{{ number_format($actualDeductions->sum('amount'), 2) }} {{ $currency_name }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    @else
                        <p class="text-muted text-center">لا توجد استقطاعات نشطة لهذا الشهر.</p>
                    @endif
                </div>
            </div>

            <!-- تفاصيل أقساط القروض -->
            @if($loanInstallments && $loanInstallments->count() > 0)
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="card-title mb-0">🏦 تفاصيل أقساط القروض</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th>نوع القرض</th>
                                    <th>رقم القرض</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th class="text-end">قيمة القسط ({{ $currency_name }})</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($loanInstallments as $installment)
                                <tr>
                                    <td><strong>{{ $installment->loan->loan_type_arabic ?? $installment->loan->loan_type }}</strong></td>
                                    <td>{{ $installment->loan->id }}</td>
                                    <td>{{ \Carbon\Carbon::parse($installment->due_date)->format('Y-m-d') }}</td>
                                    <td class="text-end fw-bold text-warning">{{ number_format($installment->amount, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-active">
                                    <th colspan="3">إجمالي أقساط القروض</th>
                                    <th class="text-end fw-bold text-warning">{{ number_format($loanInstallments->sum('amount'), 2) }} {{ $currency_name }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            @endif

            <!-- تفاصيل مكونات الراتب المحفوظة (مع عرض meta إذا وُجد) -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">📝 تفاصيل مكونات الراتب</h5>
                </div>
                <div class="card-body">
                    @php $components = $payroll->payrollSalaryComponents ?? collect(); @endphp
                    @if($components->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr><th>الوصف</th><th class="text-end">المبلغ ({{ $currency_name }})</th><th>التفاصيل</th></tr>
                            </thead>
                            <tbody>
                                @foreach($components as $comp)
                                <tr>
                                    <td>
                                        @php
                                            $label = $comp->name;
                                            if ($label === 'Overtime') {
                                                $label = 'أوفر تايم';
                                            } elseif ($label === 'Paid Off-day Compensation') {
                                                $label = 'تعويض أيام الحضور المدفوعة';
                                            } elseif (\Illuminate\Support\Str::contains($label ?? '', 'Underworked')) {
                                                $label = 'خصم نقصان ساعات';
                                            }
                                        @endphp
                                        <strong>{{ $label }}</strong>
                                    </td>
                                    <td class="text-end fw-bold {{ $comp->value > 0 ? 'text-success' : 'text-danger' }}">{{ number_format($comp->value, 2) }}</td>
                                    <td>
                                        @if(!empty($comp->meta) && is_array($comp->meta))
                                            @php $m = $comp->meta; @endphp
                                            @if(isset($m['type']) && $m['type'] === 'underworked')
                                                ساعات النقص: {{ ($m['hours'] ?? 0) }} ساعة × {{ number_format($m['hourly_rate'] ?? 0, 4) }}
                                            @elseif(isset($m['type']) && $m['type'] === 'overtime')
                                                ساعات الأوفر تايم: {{ ($m['hours'] ?? 0) }} ساعة × {{ number_format($m['hourly_rate'] ?? 0, 4) }}
                                            @elseif(isset($m['type']) && $m['type'] === 'paid_off_days')
                                                @php
                                                    // محاولة ذكية لإظهار عدد الأيام الفعلي للحضور المدفوع
                                                    $paidDays = null;
                                                    $paidDaysMeta = $m['days'] ?? null;

                                                    // 1) إذا كانت days في الميتا موجودة وموجبة استخدمها كما هي
                                                    if ($paidDaysMeta !== null && (!is_numeric($paidDaysMeta) || (float)$paidDaysMeta > 0.0)) {
                                                        $paidDays = $paidDaysMeta;
                                                    }
                                                    // 2) وإلا استخدم القيمة القادمة من الكنترولر إذا كانت أكبر من صفر
                                                    elseif (!empty($paidOffDays) && $paidOffDays > 0) {
                                                        $paidDays = $paidOffDays;
                                                    }
                                                    // 3) وإذا لم تتوفر أي من القيم السابقة، استنتج الأيام من مبلغ التعويض
                                                    else {
                                                        $amountSource = 0;
                                                        if (!empty($paidOffAmount) && $paidOffAmount > 0) {
                                                            $amountSource = $paidOffAmount;
                                                        } elseif (!empty($payroll->paid_off_amount) && $payroll->paid_off_amount > 0) {
                                                            $amountSource = $payroll->paid_off_amount;
                                                        } elseif (!empty($comp->value) && $comp->value > 0) {
                                                            // fallback أخير: استخدم قيمة المكوّن نفسها
                                                            $amountSource = $comp->value;
                                                        }

                                                        if ($amountSource > 0 && !empty($dailyRate) && $dailyRate > 0) {
                                                            $paidDays = round($amountSource / $dailyRate, 2);
                                                        } else {
                                                            $paidDays = 0;
                                                        }
                                                    }
                                                @endphp
                                                أيام الحضور المدفوعة: {{ $paidDays }} يوم
                                            @else
                                                {{ json_encode($m) }}
                                            @endif
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                        <p class="text-muted">لا توجد مكونات مرتب مضافة لهذا الراتب.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Info Card -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-column flex-md-row align-items-center gap-4">
                        <div class="avatar-lg">
                            <img src="{{ $payroll->employee->photo ? asset('storage/' . $payroll->employee->photo) : asset('images/default-avatar.png') }}" alt="صورة الموظف" class="img-fluid rounded-circle">
                        </div>
                        <div class="flex-grow-1 text-center text-md-start">
                            <h4 class="card-title mb-1">{{ $payroll->employee->name }}</h4>
                            <p class="text-muted mb-2">{{ $payroll->employee->position->name ?? 'غير محدد' }}</p>
                            <p class="text-muted">{{ $payroll->employee->department->name ?? 'غير محدد' }}</p>
                            <div class="d-flex flex-wrap gap-2 justify-content-center justify-content-md-start">
                                <span class="badge bg-primary">الرقم: {{ $payroll->employee->employee_id }}</span>
                                <span class="badge bg-info">{{ $payroll->employee->email }}</span>
                                <span class="badge bg-success">{{ $payroll->employee->phone ?? 'غير محدد' }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                </div>
            </div>

            <!-- ⚠️ (مُعدّل) تحذير حول مصدر رصيد الإجازات -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="alert alert-warning text-center">
                        ⚠️ <strong>تحذير:</strong> الرصيد الحالي للإجازات قد يتأثر بالخصومات أو الإضافات السابقة.
                    </div>
                </div>
            </div>

            <!-- Leave Balance Summary -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">📅 ملخص الإجازات</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th>الرصيد قبل الخصم:</th>
                            <td>{{ $payroll->leave_balance_before_deduction }} يوم</td>
                        </tr>
                        <tr>
                            <th>الأيام المستخدمة:</th>
                            <td>{{ $cumulativeLeaveInfo['current_month_used'] ?? 0 }} يوم</td>
                        </tr>
                        <tr>
                            <th>الأيام الممنوحة:</th>
                            <td>{{ $payroll->leave_granted_this_month }} يوم</td>
                        </tr>
                        <tr>
                            <th>الأيام الزائدة:</th>
                            <td class="{{ ($cumulativeLeaveInfo['current_month_excess'] ?? 0) > 0 ? 'text-danger fw-bold' : '' }}">
                                {{ $cumulativeLeaveInfo['current_month_excess'] ?? 0 }} يوم
                            </td>
                        </tr>
                        <tr>
                            <th>قيمة خصم الإجازات:</th>
                            <td class="text-danger fw-bold">
                                {{ number_format($payroll->leave_deduction, 2) }} {{ $currency_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>الرصيد بعد الخصم:</th>
                            <td class="fw-bold">{{ $payroll->leave_balance_after }} يوم</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- جدول الإجازات المستخدمة -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">🗓️ الإجازات المستخدمة</h5>
                </div>
                <div class="card-body">
                    @if($usedLeaves && $usedLeaves->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>نوع الإجازة</th>
                                    <th class="text-end">تاريخ البداية</th>
                                    <th class="text-end">تاريخ النهاية</th>
                                    <th class="text-end">عدد الأيام</th>
                                    <th class="text-end">الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($usedLeaves as $leave)
                                <tr>
                                    <td><strong>{{ $leave->leaveTypeModel->name ?? 'غير محدد' }}</strong></td>
                                    <td class="text-end">{{ \Carbon\Carbon::parse($leave->start_date)->format('Y-m-d') }}</td>
                                    <td class="text-end">{{ \Carbon\Carbon::parse($leave->end_date)->format('Y-m-d') }}</td>
                                    <td class="text-end fw-bold">{{ $leave->number_of_days ?? 0 }} يوم</td>
                                    <td class="text-end">
                                        @if($leave->status === 'approved')
                                            <span class="badge bg-success">موافق عليها</span>
                                        @elseif($leave->status === 'modified')
                                            <span class="badge bg-info">معدلة</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $leave->status }}</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                        <p class="text-muted text-center">لا توجد إجازات مستخدمة خلال هذا الشهر</p>
                    @endif
                </div>
            </div>

            <!-- Previous Payrolls -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">📊 الرواتب السابقة</h5>
                </div>
                <div class="card-body">
                    @if($previousPayrolls->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-centered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>الشهر والسنة</th>
                                    <th>إجمالي الراتب (الخام)</th>
                                    <th>حالة الدفع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($previousPayrolls as $prev)
                                @php
                                    $components = $prev->relationLoaded('payrollSalaryComponents') ? $prev->payrollSalaryComponents : $prev->payrollSalaryComponents()->get();
                                    $earningsTotal = $components->filter(fn($c) => ($c->value ?? 0) > 0)->sum('value');
                                    $grossRaw = ($prev->basic_salary ?? 0) + ($prev->incentives ?? 0) + $earningsTotal;

                                    $overtimeTotal = $components->filter(function($c) {
                                        $meta = $c->meta ?? null;
                                        return (!empty($meta) && isset($meta['type']) && $meta['type'] === 'overtime') || (($c->name ?? '') === 'Overtime');
                                    })->sum('value');

                                    $attendanceAdjustment = $components->filter(function($c) {
                                        $meta = $c->meta ?? null;
                                        return (!empty($meta) && isset($meta['type']) && $meta['type'] === 'underworked') || str_contains($c->name ?? '', 'Underworked') || str_contains($c->name ?? '', 'نقصان');
                                    })->sum('value');
                                    $attendanceAdjustmentDisplay = $attendanceAdjustment < 0 ? -1 * $attendanceAdjustment : $attendanceAdjustment;

                                    $otherNegatives = $components->filter(function($c) {
                                        $val = $c->value ?? 0;
                                        if ($val >= 0) return false;
                                        $meta = $c->meta ?? null;
                                        if (!empty($meta) && isset($meta['type']) && $meta['type'] === 'underworked') return false;
                                        $name = $c->name ?? '';
                                        if (str_contains($name, 'إجازة') || str_contains(strtolower($name), 'unpaid') ) return false;
                                        return true;
                                    })->sum('value');
                                    $totalOtherDeductions = $otherNegatives < 0 ? -1 * $otherNegatives : 0;

                                    $prevLoanInstallments = $prev->loan_installments ?? 0;
                                    $leaveDeduction = $prev->leave_deduction ?? 0;
                                    $netSalary = $prev->net_salary ?? max(0, $grossRaw - ($prev->active_deductions ?? 0) - $prevLoanInstallments - $leaveDeduction - $totalOtherDeductions - $attendanceAdjustmentDisplay);
                                @endphp
                                <tr>
                                    <td>{{ \Carbon\Carbon::create()->month($prev->month)->translatedFormat('F') }} {{ $prev->year }}</td>
                                    <td>{{ number_format($grossRaw, 2) }} {{ get_currency_code() }}</td>
                                    <td>
                                        @if($prev->paid_at)
                                            <span class="badge bg-success">مدفوع</span>
                                        @else
                                            <span class="badge bg-warning">قيد الدفع</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('payroll.show', $prev) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> عرض التفاصيل
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <p class="text-muted">لا توجد رواتب سابقة</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sidebar Details -->
        <div class="col-lg-4">
            <!-- الإجراءات -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">الإجراءات</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($payroll->status == 'pending')
                            @can('update', $payroll)
                                <a href="{{ route('payroll.edit', $payroll) }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> تعديل
                                </a>
                                <form id="payPayrollForm" action="{{ route('payroll.pay', $payroll) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-success" id="payPayrollBtn">
                                        <i class="fas fa-check"></i> دفع الراتب
                                    </button>
                                </form>
                            @endcan
                            @can('delete', $payroll)
                                <form action="{{ route('payroll.destroy', $payroll) }}" method="POST">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الراتب؟')">
                                        <i class="fas fa-trash"></i> حذف
                                    </button>
                                </form>
                            @endcan
                        @endif
                        <!-- زر الطباعة -->
                        <a href="{{ route('payroll.printPayrollDetails', $payroll) }}" class="btn btn-primary" target="_blank" onclick="printPayrollDetails()">
                            <i class="fas fa-print"></i> طباعة
                        </a>
                        <a href="{{ route('payroll.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
@php
    $payrollTranslations = [
        'popup_blocked' => 'تم حظر نافذة الطباعة. يرجى السماح بفتح النوافذ المنبثقة.',
        'print_title' => 'تفاصيل الراتب',
        'income_title' => 'الإيرادات',
        'deductions_title' => 'الخصومات',
        'net_title' => 'الراتب الصافي',
        'description_label' => 'الوصف',
        'amount_label' => 'المبلغ',
        'basic_salary_label' => 'الراتب الأساسي',
        'incentives_label' => 'الحوافز',
        'total_income_label' => 'إجمالي الإيرادات',
        'total_deductions_label' => 'إجمالي الخصومات',
        'net_salary_label' => 'الراتب الصافي',
        'leave_deduction_label' => 'خصم الإجازات',
        'days_label' => 'أيام',
        'department_label' => 'القسم',
        'position_label' => 'المنصب',
        'month_label' => 'الشهر',
    ];
@endphp
<script>
const payrollTranslations = @json($payrollTranslations);

function printPayrollDetails() {
    // جمع البيانات مباشرة داخل الوظيفة
    const employeeName = @json($payroll->employee->name);
    const department = @json($payroll->employee->department->name ?? 'غير محدد');
    const position = @json($payroll->employee->position->name ?? 'غير محدد');
    const month = @json(\Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F'));
    const year = @json($payroll->year);
    const basicSalary = parseFloat(@json($payroll->basic_salary));
    const incentives = parseFloat(@json($payroll->incentives));
    const currency = @json($currency_name);

    // جمع المكونات الإضافية
    const components = [];
    @php
        $employee = $payroll->employee;
        $componentNames = ['component_name_1', 'component_name_2', 'component_name_3', 'component_name_4', 'component_name_5', 'component_name_6', 'component_name_7'];
        $componentValues = ['component_1', 'component_2', 'component_3', 'component_4', 'component_5', 'component_6', 'component_7'];
    @endphp
    @for ($i = 0; $i < 7; $i++)
        @if($employee->{$componentValues[$i]} > 0)
            components.push({
                name: @json($employee->{$componentNames[$i]} ?? 'المكون ' . ($i+1)),
                value: parseFloat(@json($employee->{$componentValues[$i]}))
            });
        @endif
    @endfor

    // جمع الاستقطاعات النشطة
    const activeDeductions = [];
    @foreach($actualDeductions as $d)
        activeDeductions.push({
            name: (function() {
                let typeLabel = @json($deductionTypes[$d->type] ?? $d->type);
                if (typeLabel === @json($d->type)) {
                    typeLabel = typeLabel.replace(/_/g, ' ');
                }
                return typeLabel;
            })(),
            amount: parseFloat(@json($d->amount))
        });
    @endforeach

    // جمع أقساط القروض
    const loanInstallments = [];
    @foreach($loanInstallments as $inst)
        loanInstallments.push({
            name: (function() {
                let loanTypeLabel = @json($loanTypes[$inst->loan->loan_type] ?? $inst->loan->loan_type ?? 'غير محدد');
                if (loanTypeLabel === @json($inst->loan->loan_type)) {
                    loanTypeLabel = loanTypeLabel.replace(/_/g, ' ');
                }
                return loanTypeLabel;
            })(),
            amount: parseFloat(@json($inst->amount)),
            dueDate: @json($inst->due_date->format('Y-m-d'))
        });
    @endforeach

    // خصومات الإجازات
    const leaveDeductionAmount = parseFloat(@json($payroll->leave_deduction));
    const leaveExcessDays = parseInt(@json($cumulativeLeaveInfo['current_month_excess'] ?? 0));

    // حساب الراتب الصافي
    let totalSalary = basicSalary + incentives;
    components.forEach(comp => totalSalary += comp.value);

    let totalDeductions = 0;
    activeDeductions.forEach(ded => totalDeductions += ded.amount);
    loanInstallments.forEach(inst => totalDeductions += inst.amount);
    totalDeductions += leaveDeductionAmount;

    const netSalary = totalSalary - totalDeductions;

    // إنشاء نافذة الطباعة
    const printWindow = window.open('', '_blank');
    if (!printWindow) {
        alert(payrollTranslations.popup_blocked);
        return;
    }
    printWindow.document.write(`
        <!DOCTYPE html>
        <html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
        <head>
            <meta charset="UTF-8">
            <title>تفاصيل الراتب - ${employeeName}</title>
            <style>
                body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; margin: 2cm; line-height: 1.6; }
                .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }
                .header h1 { margin: 0; font-size: 24px; }
                .header p { margin: 5px 0; font-size: 14px; }
                .section { margin-bottom: 20px; }
                .section-title { font-weight: bold; margin-bottom: 10px; font-size: 18px; }
                table { width: 100%; border-collapse: collapse; margin-top: 10px; }
                th, td { padding: 8px; text-align: right; border: 1px solid #ddd; }
                th { background-color: #f2f2f2; }
                .total-row { font-weight: bold; background-color: #f9f9f9; }
                .net-salary { font-size: 20px; color: green; }
            </style>
        </head>
        <body>
            <div class="header">
                <h1>${payrollTranslations.print_title}</h1>
                <p><strong>${payrollTranslations.description_label}:</strong> ${employeeName}</p>
                <p><strong>${payrollTranslations.department_label}:</strong> ${department}</p>
                <p><strong>${payrollTranslations.position_label}:</strong> ${position}</p>
                <p><strong>${payrollTranslations.month_label}:</strong> ${month} ${year}</p>
            </div>

            <div class="section">
                <div class="section-title">${payrollTranslations.income_title}</div>
                <table>
                    <tr><th>${payrollTranslations.description_label}</th><th>${payrollTranslations.amount_label} (${currency})</th></tr>
                    <tr><td>${payrollTranslations.basic_salary_label}</td><td>${basicSalary.toFixed(2)}</td></tr>
                    ${incentives > 0 ? `<tr><td>${payrollTranslations.incentives_label}</td><td>${incentives.toFixed(2)}</td></tr>` : ''}
                    ${components.map(comp => `<tr><td>${comp.name}</td><td>${comp.value.toFixed(2)}</td></tr>`).join('')}
                    <tr class="total-row"><td>${payrollTranslations.total_income_label}</td><td>${totalSalary.toFixed(2)}</td></tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">${payrollTranslations.deductions_title}</div>
                <table>
                    <tr><th>${payrollTranslations.description_label}</th><th>${payrollTranslations.amount_label} (${currency})</th></tr>
                    ${activeDeductions.map(ded => `<tr><td>${ded.name}</td><td>${ded.amount.toFixed(2)}</td></tr>`).join('')}
                    ${loanInstallments.map(inst => `<tr><td>${inst.name} (الاستحقاق ${inst.dueDate})</td><td>${inst.amount.toFixed(2)}</td></tr>`).join('')}
                    ${leaveDeductionAmount > 0 ? `<tr><td>${payrollTranslations.leave_deduction_label} (${leaveExcessDays} ${payrollTranslations.days_label || 'أيام'})</td><td>${leaveDeductionAmount.toFixed(2)}</td></tr>` : ''}
                    <tr class="total-row"><td>${payrollTranslations.total_deductions_label}</td><td>${totalDeductions.toFixed(2)}</td></tr>
                </table>
            </div>

            <div class="section">
                <div class="section-title">${payrollTranslations.net_title}</div>
                <table>
                    <tr><th>${payrollTranslations.description_label}</th><th>${payrollTranslations.amount_label} (${currency})</th></tr>
                    <tr class="net-salary"><td>${payrollTranslations.net_salary_label}</td><td>${netSalary.toFixed(2)}</td></tr>
                </table>
            </div>
        </body>
        </html>
    `);

    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
}
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const payForm = document.getElementById('payPayrollForm');
    if (!payForm) return;

    payForm.addEventListener('submit', function(e) {
        // قبل الإرسال، أضف حقولاً مخفية لكل قسط محدد
        // أزل أي حقل مخفي تم إضافته سابقاًا
        Array.from(payForm.querySelectorAll('input[name="installment_ids[]"]')).forEach(el => el.remove());

        const checked = Array.from(document.querySelectorAll('.pay-installment-checkbox:checked')).map(cb => cb.value);
        checked.forEach(id => {
            const inp = document.createElement('input');
            inp.type = 'hidden';
            inp.name = 'installment_ids[]';
            inp.value = id;
            payForm.appendChild(inp);
        });

        // عرض تأكيد قبل دفع الراتب
        return confirm('هل أنت متأكد من دفع الراتب؟');
    });
});
</script>
@endpush

<!-- قسم الراتب الصافي -->
<div class="card mt-4">
    <div class="card-header bg-success text-white">
        <h5 class="card-title mb-0">💰 الراتب الصافي</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <table class="table table-bordered">
                    <tbody>
                        <tr class="table-light">
                            <th class="text-start">إجمالي الإضافات</th>
                            <td class="text-end fw-bold text-success">{{ number_format($payroll->basic_salary + $payroll->incentives + $additionsTotal, 2) }} {{ $currency_name }}</td>
                        </tr>
                        <tr class="table-light">
                            <th class="text-start">إجمالي الخصومات</th>
                            <td class="text-end fw-bold text-danger">- {{ number_format($payroll->active_deductions + $payroll->loan_installments + $payroll->leave_deduction + $deductionsTotal, 2) }} {{ $currency_name }}</td>
                        </tr>
                        <tr class="table-success">
                            <th class="text-start">الراتب الصافي المستحق</th>
                            @php
                                $totalAdditions = $payroll->basic_salary + $payroll->incentives + $additionsTotal;
                                $totalDeductions = $payroll->active_deductions + $payroll->loan_installments + $payroll->leave_deduction + $deductionsTotal;
                                $netSalary = $totalAdditions - $totalDeductions;
                            @endphp
                            <td class="text-end fw-bold fs-5">{{ number_format($netSalary, 2) }} {{ $currency_name }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@endsection
