{{-- resources/views/payroll/print-payroll-details.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>{{ __('payroll.print.title') }} - {{ $payroll->employee->name }} - {{ \Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F') }} {{ $payroll->year }}</title>
    <style>
        body {
            font-family: 'Tajawal', Arial, sans-serif;
            margin: 20px;
            direction: rtl;
            line-height: 1.6;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #007bff;
            margin: 0;
        }
        .employee-info {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 8px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .info-table th, .info-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .info-table th {
            background-color: #e9ecef;
            font-weight: 600;
        }
        .section {
            margin-top: 30px;
            page-break-inside: avoid;
        }
        .section-title {
            background-color: #f8f9fa;
            padding: 10px;
            border-left: 4px solid #007bff;
            margin-bottom: 15px;
            font-weight: bold;
            font-size: 1.1em;
        }
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .details-table th, .details-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .details-table th {
            background-color: #e9ecef;
            font-weight: 600;
        }
        .total-row {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .net-salary {
            font-size: 20px;
            color: green;
            font-weight: bold;
        }
        .text-danger {
            color: #dc3545;
        }
        .text-success {
            color: #28a745;
        }
        .no-print {
            display: none;
        }
        @media print {
            body {
                margin: 0;
                font-size: 10pt;
            }
            .no-print {
                display: block;
                text-align: center;
                margin: 20px 0;
            }
        }
    </style>
</head>
<body>

<div class="header">
    <h1>{{ __('payroll.print.company_name') }}</h1>
    <h2>{{ __('payroll.print.header_title') }}</h2>
</div>

<!-- معلومات الموظف -->
<div class="employee-info">
    <div class="row">
        <div class="col-md-6">
            <p><strong>الاسم:</strong> {{ $payroll->employee->name }}</p>
            <p><strong>الرقم الوظيفي:</strong> {{ $payroll->employee->employee_id }}</p>
            <p><strong>الوظيفة:</strong> {{ $payroll->employee->position?->name ?? 'غير محدد' }}</p>
            <p><strong>القسم:</strong> {{ $payroll->employee->department?->name ?? 'غير محدد' }}</p>
        </div>
        <div class="col-md-6">
            <p><strong>الشهر:</strong> {{ \Carbon\Carbon::create()->month($payroll->month)->translatedFormat('F Y') }}</p>
            <p><strong>تاريخ الدفع:</strong> {{ $payroll->paid_at ? $payroll->paid_at->format('Y-m-d H:i') : 'لم يتم الدفع بعد' }}</p>
            <p><strong>الحالة:</strong>
                @switch($payroll->status)
                    @case('pending')
                        <span class="badge bg-warning text-dark">قيد الدفع</span>
                        @break
                    @case('paid')
                        <span class="badge bg-success">مدفوع</span>
                        @break
                    @case('cancelled')
                        <span class="badge bg-danger">ملغى</span>
                        @break
                    @default
                        <span class="badge bg-secondary">{{ $payroll->status }}</span>
                @endswitch
            </p>
        </div>
    </div>
</div>

<!-- تفاصيل الراتب -->
<div class="section">
    <div class="section-title">{{ __('payroll.print.section_total_income') }}</div>
    <table class="details-table">
        <thead>
            <tr>
                <th>الوصف</th>
                <th>{{ __('payroll.labels.amount') }} ({{ get_currency_code() }})</th>
            </tr>
        </thead>
        <tbody>
            <!-- ✅ عرض الراتب الأساسي -->
            <tr>
                <td>الراتب الأساسي</td>
                <td>{{ number_format($payroll->basic_salary, 2) }}</td>
            </tr>

            <!-- ✅ عرض الحوافز -->
            <tr>
                <td>الحوافز</td>
                <td>{{ number_format($payroll->incentives, 2) }}</td>
            </tr>

            <!-- ✅ عرض مكونات الراتب الإضافية -->
            @if($payrollComponents && $payrollComponents->count() > 0)
                @foreach($payrollComponents as $comp)
                    <tr>
                        <td>{{ $comp->name }}</td>
                        <td>{{ number_format($comp->value, 2) }}</td>
                    </tr>
                    @if(!empty($comp->meta) && is_array($comp->meta))
                        <tr>
                            <td colspan="2" class="text-muted small">
                                @php $m = $comp->meta; @endphp
                                @if(isset($m['type']) && $m['type'] === 'underworked')
                                    {{ __('payroll.labels.underworked_hours_label') }}: {{ ($m['hours'] ?? 0) . ' ' . __('payroll.labels.hours') . ' × ' . number_format($m['hourly_rate'] ?? 0, 4) . ' = ' . number_format($m['calculation'] ?? ($comp->value * -1), 2) }} {{ get_currency_code() }}
                                @elseif(isset($m['type']) && $m['type'] === 'overtime')
                                    {{ __('payroll.labels.overtime_label') }}: {{ ($m['hours'] ?? 0) . ' ' . __('payroll.labels.hours') . ' × ' . number_format($m['hourly_rate'] ?? 0, 4) . ' = ' . number_format($m['calculation'] ?? $comp->value, 2) }} {{ get_currency_code() }}
                                @else
                                    @foreach($m as $k => $v)
                                        {{ $k }}: {{ is_array($v) ? json_encode($v) : $v }}@if(!$loop->last) · @endif
                                    @endforeach
                                @endif
                            </td>
                        </tr>
                    @endif
                @endforeach
            @else
                <tr>
                    <td colspan="2" class="text-center">{{ __('payroll.print.no_components') }}</td>
                </tr>
            @endif

            <tr class="total-row">
                <td><strong>إجمالي الدخل</strong></td>
                <td><strong>{{ number_format($totalSalary, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</div>
<!-- تفاصيل الإجازات -->
<div class="section">
    <div class="section-title">{{ __('payroll.print.section_leave') }}</div>
    <table class="details-table">
        <thead>
            <tr>
                <th>الوصف</th>
                <th>{{ __('payroll.labels.value') }}</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>عدد أيام الإجازة الشهرية المسموح بها</td>
                <td>{{ $payroll->employee->monthly_leave_days_allowed ?? 0 }} يوم</td>
            </tr>
            <tr>
                <td>الأيام المستخدمة هذا الشهر</td>
                <td>{{ $cumulativeLeaveInfo['current_month_used'] ?? 0 }} يوم</td>
            </tr>
            <tr>
                <td>{{ __('deductions.extra_days_deducted') }}</td>
                <td class="text-danger">{{ $cumulativeLeaveInfo['current_month_excess'] ?? 0 }} يوم</td>
            </tr>
            <tr>
                <td>{{ __('payroll.labels.daily_rate') }}</td>
                <td>{{ number_format($dailyRate ?? 0, 2) }} {{ get_currency_code() }}</td>
            </tr>
            <tr>
                <td>خصم الإجازات الزائدة</td>
                <td class="text-danger">- {{ number_format($payroll->leave_deduction, 2) }} {{ get_currency_code() }}</td>
            </tr>
            <tr>
                <td>الرصيد قبل الخصم</td>
                <td>{{ $payroll->leave_balance_before_deduction }} يوم</td>
            </tr>
            <tr>
                <td>الرصيد بعد الخصم</td>
                <td>{{ $payroll->leave_balance_after_deduction }} يوم</td>
            </tr>
            @isset($paidOffDays)
            <tr>
                <td>أيام الحضور المدفوعة</td>
                <td>{{ $paidOffDays }} يوم — {{ number_format($paidOffAmount ?? 0, 2) }} {{ get_currency_code() }}</td>
            </tr>
            @endisset
        </tbody>
    </table>
</div>

<!-- تفاصيل الاستقطاعات -->
<div class="section">
    <div class="section-title">تفاصيل الاستقطاعات</div>
    <table class="details-table">
        <thead>
            <tr>
                <th>النوع</th>
                <th>الوصف</th>
                <th>{{ __('payroll.labels.amount') }} ({{ get_currency_code() }})</th>
                <th>التاريخ</th>
            </tr>
        </thead>
        <tbody>
            @if(!empty($actualDeductions) && is_array($actualDeductions))

                @foreach($actualDeductions as $deduction)
                    <tr>
                        <td>{{ $deductionTypes[$deduction->type] ?? $deduction->type }}</td>
                        <td>{{ $deduction->description }}</td>
                        <td>{{ number_format($deduction->amount, 2) }}</td>
                        <td>{{ $deduction->deduction_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="4" class="text-center">{{ __('payroll.print.no_deductions') }}</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<!-- تفاصيل أقساط القروض -->
<div class="section">
    <div class="section-title">{{ __('payroll.print.section_loans') }}</div>
    <table class="details-table">
        <thead>
            <tr>
                <th>القرض</th>
                <th>المبلغ</th>
                <th>القسط الشهري</th>
                <th>تاريخ الاستحقاق</th>
                <th>الحالة</th>
            </tr>
        </thead>
        <tbody>
            @if($loanInstallments && $loanInstallments->count() > 0)
                @foreach($loanInstallments as $inst)
                    <tr>
                        <td>{{ $loanTypes[$inst->loan->loan_type] ?? $inst->loan->loan_type ?? 'غير محدد' }}</td>
                        <td>{{ number_format($inst->loan->amount, 2) }}</td>
                        <td>{{ number_format($inst->amount, 2) }}</td>
                        <td>{{ $inst->due_date?->format('Y-m-d') ?? 'غير محدد' }}</td>
                        <td>
                            @switch($inst->status)
                                @case('pending')
                                    <span class="badge bg-warning text-dark">قيد الانتظار</span>
                                    @break
                                @case('paid')
                                    <span class="badge bg-success">مدفوع</span>
                                    @break
                                @case('overdue')
                                    <span class="badge bg-danger">متأخر</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary">{{ $inst->status }}</span>
                            @endswitch
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="5" class="text-center">{{ __('payroll.print.no_loans') }}</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<!-- ملخص الحسابات -->
<div class="section">
    <div class="section-title">{{ __('payroll.print.section_summary') }}</div>
    <table class="details-table">
        <thead>
            <tr>
                <th>الوصف</th>
                <th>{{ __('payroll.labels.amount') }} ({{ get_currency_code() }})</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ __('payroll.create.total_salary') }}</td>
                <td>{{ number_format($totalSalary, 2) }}</td>
            </tr>
            <tr>
                <td>{{ __('payroll.print.section_deductions') }}</td>
                <td>- {{ number_format($payroll->active_deductions, 2) }}</td>
            </tr>
            <tr>
                <td>{{ __('payroll.print.section_loans') }}</td>
                <td>- {{ number_format($payroll->loan_installments, 2) }}</td>
            </tr>
            <tr>
                <td>{{ __('payroll.create.leave_deduction') }}</td>
                <td>- {{ number_format($payroll->leave_deduction, 2) }}</td>
            </tr>
            <tr class="total-row">
                <td><strong>إجمالي الخصومات</strong></td>
                <td><strong>- {{ number_format($calculatedTotalDeductions, 2) }}</strong></td>
            </tr>
            <tr class="total-row net-salary">
                <td><strong>الراتب الصافي (إجمالي الراتب - إجمالي الخصومات)</strong></td>
                <td><strong>{{ number_format($netSalary, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>
</div>

<!-- ملاحظات -->
@if($payroll->notes)
    <div class="section">
        <div class="section-title">ملاحظات</div>
        <p>{{ $payroll->notes }}</p>
    </div>
@endif

<!-- زر الطباعة وعودة إلى الملف كما في الصورة -->
<div class="no-print" style="text-align:center; margin-top:30px;">
    <!-- زر الطباعة -->
    <button onclick="window.print()" class="btn btn-outline-primary" style="font-weight: bold; padding: 8px 20px; margin-right: 15px;">
        <i class="fas fa-print me-2"></i> طباعة
    </button>

    <!-- رابط العودة إلى الملف -->
    <a href="{{ route('payroll.show', $payroll) }}" class="btn btn-link text-decoration-none" style="font-weight: bold; font-size: 1rem; color: #6c757d;">
        عودة إلى الملف
    </a>
</div>
</body>
</html>