{{-- resources/views/payroll/index.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('payroll.index.page_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('payroll.index.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('payroll.index.breadcrumb_payroll') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('payroll.index.total_payrolls') }}</p>
                            <h4 class="mb-0">{{ $totalPayrolls ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-file-invoice-dollar fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('payroll.index.paid') }}</p>
                            <h4 class="mb-0">{{ $paidPayrolls ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('payroll.index.pending') }}</p>
                            <h4 class="mb-0">{{ $pendingPayrolls ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-clock fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('payroll.index.net_paid') }}</p>
                            <h4 class="mb-0">{{ number_format($totalAmount ?? 0, 2) }} {{ get_currency_code() }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-money-bill-wave fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions & Search -->
    <div class="row mb-4">
        <div class="col-md-6 d-flex gap-2">
            <!-- ✅ زر واحد رئيسي خارج الجدول كما طلبت -->
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#generateMonthlyModal">
                <i class="fas fa-cogs"></i> {{ __('payroll.index.generate_monthly') }}
            </button>
        </div>
        <div class="col-md-6">
            <input type="text" id="employeeSearch" class="form-control" placeholder="{{ __('payroll.index.search_placeholder') }}">
        </div>
    </div>

    <!-- Employees Salary Breakdown -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('payroll.index.employee_list') }}</h5>
                    <div class="table-responsive">
                        <table class="table table-hover" id="employeesPayrollTable">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('payroll.index.employee_name') }}</th>
                                    <th>{{ __('payroll.index.position') }}</th>
                                    <th>{{ __('payroll.index.department') }}</th>
                                    <th>{{ __('payroll.index.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($employees as $index => $employee)
                                    <tr class="employee-row" data-name="{{ $employee->name }}" data-id="{{ $employee->employee_id ?? $employee->id }}">
                                        <td>{{ $employee->name }}</td>
                                        <td>{{ $employee->position?->name ?? '—' }}</td>
                                        <td>{{ $employee->department?->name ?? '—' }}</td>
                                        <td>
    <!-- زر إنشاء راتب -->
    <a href="{{ route('payroll.create', ['employee_id' => $employee->id]) }}" class="btn btn-sm btn-primary" title="{{ __('payroll.index.create_salary') }}">
        💰
    </a>

    <!-- زر عرض رواتب الموظف -->
    <a href="{{ route('payroll.employee.payrolls', $employee) }}" class="btn btn-sm btn-info ms-1" title="{{ __('payroll.index.view_salaries') }}">
        👁️
    </a>

    <!-- زر الدفع إن وُجد راتب معلق -->
    @if($employee->has_pending_payroll_for_current_month)
        <form action="{{ route('payroll.pay', $employee->pending_payroll_for_current_month) }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-sm btn-success ms-1"
                onclick="return confirm('{{ __('payroll.index.confirm_payment', ['name' => $employee->name, 'month' => now()->translatedFormat('F Y')]) }}')">
                <i class="fas fa-check"></i> {{ __('payroll.index.pay') }}
            </button>
        </form>
    @endif
</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <!-- ⚠️ تم تغيير عدد الأعمدة من 12 إلى 13 -->
                                        <td colspan="13" class="text-center py-4 text-muted">
                                            <i class="fas fa-users fa-2x mb-2"></i><br>
                                            {{ __('payroll.index.no_employees') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Paid Payrolls This Month -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">{{ __('payroll.index.paid_this_month', ['month' => now()->translatedFormat('F Y')]) }}</h5>
                </div>
                <div class="card-body">
                    @if($paidThisMonth->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('payroll.index.employee_name') }}</th>
                                        <th title="خصم من الراتب نتيجة عدم اكتمال ساعات العمل المجدولة">{{ __('payroll.labels.attendance_adjustment') }}</th>
                                        <th>{{ __('payroll.index.net_salary') }}</th>
                                        <th>{{ __('payroll.index.payment_date') }}</th>
                                        <th>{{ __('payroll.index.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($paidThisMonth as $payroll)
                                        @php
                                            $components = $payroll->relationLoaded('payrollSalaryComponents') ? $payroll->payrollSalaryComponents : $payroll->payrollSalaryComponents()->get();
                                            $attendanceAdjustment = $components->filter(function($c){
                                                $meta = $c->meta ?? null;
                                                return (!empty($meta) && isset($meta['type']) && $meta['type'] === 'underworked') || str_contains($c->name ?? '', 'Underworked') || str_contains($c->name ?? '', 'نقصان');
                                            })->sum('value');
                                            $attendanceAdjustmentDisplay = $attendanceAdjustment < 0 ? -1 * $attendanceAdjustment : $attendanceAdjustment;
                                        @endphp
                                        <tr>
                                            <td>{{ $payroll->employee->name }}</td>
                                            <td class="text-danger">{{ number_format($attendanceAdjustmentDisplay ?? 0, 2) }} {{ get_currency_code() }}</td>
                                            <td class="text-success">{{ number_format($payroll->net_salary, 2) }} {{ get_currency_code() }}</td>
                                            <td>{{ $payroll->paid_at->format('Y-m-d') }}</td>
                                            <td>
                                                <a href="{{ route('payroll.show', $payroll) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i> {{ __('payroll.index.view') }}
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-muted text-center py-3">{{ __('payroll.index.no_paid_salaries') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Generate Monthly Payroll Modal -->
<div class="modal fade" id="generateMonthlyModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('payroll.generate-monthly') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('payroll.index.generate_monthly') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="month" class="form-label">{{ __('payroll.index.month') }} <span class="text-danger">*</span></label>
                        <select class="form-control" id="month" name="month" required>
                            <option value="">{{ __('payroll.index.select_month') }}</option>
                            @for($m = 1; $m <= 12; $m++)
                                <option value="{{ $m }}" {{ now()->month == $m ? 'selected' : '' }}>
                                    {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="year" class="form-label">{{ __('payroll.index.year') }} <span class="text-danger">*</span></label>
                        <select class="form-control" id="year" name="year" required>
                            <option value="">{{ __('payroll.index.select_year') }}</option>
                            @for($y = now()->year - 1; $y <= now()->year + 25; $y++)
                                <option value="{{ $y }}" {{ now()->year == $y ? 'selected' : '' }}>{{ $y }}</option>
                            @endfor
                        </select>
                    </div>
                    <div class="alert alert-warning mt-3">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        {{ __('payroll.index.warning_generate') }}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('payroll.index.cancel') }}</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-cogs me-2"></i> {{ __('payroll.index.generate') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.getElementById('employeeSearch');
    const rows = document.querySelectorAll('.employee-row');
    searchInput.addEventListener('input', function () {
        const query = this.value.toLowerCase().trim();
        rows.forEach(row => {
            const name = row.dataset.name?.toLowerCase() || '';
            const id = (row.dataset.id || '').toLowerCase();
            row.style.display = (name.includes(query) || id.includes(query)) ? '' : 'none';
        });
    });
});
</script>
@endpush
@endsection