{{-- resources/views/payroll/employee-payrolls.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('payroll.employee_payrolls.page_title', ['name' => $employee->name]) }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('payroll.index.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('payroll.index') }}">{{ __('payroll.index.breadcrumb_payroll') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('payroll.employee_payrolls.page_title', ['name' => $employee->name]) }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Summary Card -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('payroll.create.employee_info') }}</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>{{ __('payroll.create.employee_number') }}</strong> {{ $employee->employee_id }}</p>
                            <p><strong>{{ __('payroll.create.department') }}</strong> {{ $employee->department?->name ?? __('payroll.not_available') }}</p>
                            <p><strong>{{ __('payroll.create.position') }}</strong> {{ $employee->position?->name ?? __('payroll.not_available') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>{{ __('payroll.create.basic_salary') }}</strong> {{ number_format($employee->salary, 2) }} {{ get_currency_code() }}</p>
                            <p><strong>{{ __('payroll.create.incentives') }}</strong> {{ number_format($employee->incentives, 2) }} {{ get_currency_code() }}</p>
                            @php
                                // احسب مجموع المكونات الإضافية من العلاقة وفي الحقول الثابتة (component_1..component_7)
                                $relComponents = $employee->relationLoaded('salaryComponents')
                                    ? $employee->salaryComponents->sum(fn($c) => (float) ($c->pivot->value ?? 0))
                                    : (float) ($employee->salaryComponents()->sum('employee_salary_components.value') ?? 0);
                                $fixedComponents = 0;
                                for ($i = 1; $i <= 7; $i++) {
                                    $fixedComponents += (float) ($employee->{"component_$i"} ?? 0);
                                }
                                $componentsTotalEmployee = $relComponents + $fixedComponents;
                                $employeeTotalSalary = ($employee->salary ?? 0) + ($employee->incentives ?? 0) + $componentsTotalEmployee;
                            @endphp
                            <p><strong>{{ __('payroll.create.additional_components_total', [], null) ?: 'مجموع المكونات الإضافية' }}</strong> {{ number_format($componentsTotalEmployee, 2) }} {{ get_currency_code() }}</p>
                            <p><strong>{{ __('payroll.create.total_salary_combined', [], null) ?: 'إجمالي الراتب (الأساسي + الحوافز + المكونات)' }}</strong> {{ number_format($employeeTotalSalary, 2) }} {{ get_currency_code() }}</p>
                            <p><strong>{{ __('payroll.create.leave_balance') }}</strong> {{ $employee->getAvailableBalanceAttribute() }} {{ __('payroll.employee_payrolls.days') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Payrolls Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">{{ __('payroll.employee_payrolls_page.all_payrolls', ['name' => $employee->name]) }}</h5>
                    <a href="{{ route('payroll.create', ['employee_id' => $employee->id]) }}" class="btn btn-success">
                        <i class="fas fa-plus me-1"></i> {{ __('payroll.employee_payrolls_page.create_new') }}
                    </a>
                </div>
                <div class="card-body">
                    @if($payrolls->isEmpty())
                        <div class="text-center py-5">
                            <i class="fas fa-file-invoice-dollar fa-3x text-muted mb-3"></i>
                            <p class="text-muted">{{ __('payroll.employee_payrolls_page.no_payrolls_message') }}</p>
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover table-centered">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('payroll.index.month') }}</th>
                                        <th>{{ __('payroll.index.year') }}</th>
                                        <th>{{ __('payroll.index.gross_salary') }}</th>
                                        <th>{{ __('payroll.show.payment_status') }}</th>
                                        <th>{{ __('payroll.index.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payrolls as $payroll)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->translatedFormat('F') }}</td>
                                        <td>{{ $payroll->year }}</td>
                                        <!-- حساب مجموع المكونات الإضافية (استخدام العلاقة المحمّلة إن وُجدت أو الاستعلام عنها)
                                             ثم عرض الراتب الإجمالي المحسوب بدل الحقل المخزن -->
                                        @php
                                            // جلب مكونات الراتب (محملة أو عبر استعلام)
                                            $components = $payroll->relationLoaded('payrollSalaryComponents')
                                                ? $payroll->payrollSalaryComponents
                                                : $payroll->payrollSalaryComponents()->get();

                                            // مجموع المكونات الإيجابية (عناصر دخل مثل Allowances, Overtime)
                                            $earningsTotal = $components->filter(fn($c) => ($c->value ?? 0) > 0)->sum('value');

                                            // إجمالي الراتب الخام (الأساسي + الحوافز + مكونات موجبة)
                                            $grossRaw = ($payroll->basic_salary ?? 0) + ($payroll->incentives ?? 0) + $earningsTotal;

                                            // أوفرتايم: اجمع مكونات الاوفر تايم (meta.type == 'overtime' أو الاسم 'Overtime')
                                            $overtimeTotal = $components->filter(function($c) {
                                                $meta = $c->meta ?? null;
                                                return (!empty($meta) && isset($meta['type']) && $meta['type'] === 'overtime') || (($c->name ?? '') === 'Overtime');
                                            })->sum('value');

                                            // تعديل الحضور (خصم) — مكونات نوع 'underworked' تكون قيمتها سالبة
                                            $attendanceAdjustment = $components->filter(function($c) {
                                                $meta = $c->meta ?? null;
                                                return (!empty($meta) && isset($meta['type']) && $meta['type'] === 'underworked') || str_contains($c->name ?? '', 'Underworked') || str_contains($c->name ?? '', 'نقصان');
                                            })->sum('value');
                                            $attendanceAdjustmentDisplay = $attendanceAdjustment < 0 ? -1 * $attendanceAdjustment : $attendanceAdjustment;

                                            // إجمالي الاستقطاعات الأخرى: اجمع كل المكونات السالبة ما عدا تعديل الحضور وخصم الإجازة (التي تُعرض في عمود منفصل)
                                            $otherNegatives = $components->filter(function($c) {
                                                $val = $c->value ?? 0;
                                                if ($val >= 0) return false;
                                                $meta = $c->meta ?? null;
                                                if (!empty($meta) && isset($meta['type']) && $meta['type'] === 'underworked') return false;
                                                $name = $c->name ?? '';
                                                if (str_contains($name, 'إجازة') || str_contains(strtolower($name), 'unpaid') ) return false;
                                                return true;
                                            })->sum('value');
                                            $totalOtherDeductions = $otherNegatives < 0 ? -1 * $otherNegatives : 0;

                                            $loanInstallments = $payroll->loan_installments ?? 0;
                                            $leaveDeduction = $payroll->leave_deduction ?? 0;
                                        @endphp

                                        <td>{{ number_format($grossRaw, 2) }} {{ get_currency_code() }}</td>
                                        <td>
                                            @switch($payroll->status)
                                                @case('pending')
                                                    <span class="badge bg-warning text-dark">{{ __('payroll.show.status_pending') }}</span>
                                                    @break
                                                @case('paid')
                                                    <span class="badge bg-success">{{ __('payroll.show.status_paid') }}</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">{{ __('payroll.show.status_cancelled') }}</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-secondary">{{ $payroll->status }}</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            <!-- زر العرض -->
                                            <a href="{{ route('payroll.show', $payroll) }}" class="btn btn-sm btn-info me-1" title="{{ __('payroll.employee_payrolls.view_details') }}">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                            <!-- زر التعديل -->
                                            @can('update', $payroll)
                                                @if($payroll->status === 'pending')
                                                    <a href="{{ route('payroll.edit', $payroll) }}" class="btn btn-sm btn-primary me-1" title="{{ __('payroll.edit.page_title', ['id' => $payroll->id]) }}">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                @else
                                                    <button class="btn btn-sm btn-primary me-1" title="{{ __('payroll.employee_payrolls.cannot_edit') }}" disabled>
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                @endif
                                            @endcan

                                            <!-- زر الدفع -->
                                            @can('pay', $payroll)
                                                    @if($payroll->status === 'pending')
                                                    <form action="{{ route('payroll.pay', $payroll) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-success me-1"
                                                                onclick="return confirm('{{ __('payroll.employee_payrolls_page.confirm_pay', ['name' => $employee->name, 'month' => \Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->translatedFormat('F Y')]) }}')">
                                                            <i class="fas fa-check"></i> {{ __('payroll.index.pay') }}
                                                        </button>
                                                    </form>
                                                @else
                                                    <button class="btn btn-sm btn-success me-1" title="@if($payroll->status === 'paid') {{ __('payroll.show.status_paid') }} @else {{ __('payroll.employee_payrolls.cannot_edit') }} @endif" disabled>
                                                        <i class="fas fa-check"></i> {{ __('payroll.index.pay') }}
                                                    </button>
                                                @endif
                                            @endcan

                                            <!-- زر الحذف -->
                                            @can('delete', $payroll)
                                                    @if($payroll->status === 'pending')
                                                    <form action="{{ route('payroll.destroy', $payroll) }}" method="POST" class="d-inline">
                                                        @csrf @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                                onclick="return confirm('{{ __('payroll.employee_payrolls_page.confirm_delete', ['name' => $employee->name, 'month' => \Carbon\Carbon::createFromDate($payroll->year, $payroll->month, 1)->translatedFormat('F Y')]) }}')">
                                                            <i class="fas fa-trash"></i> {{ __('payroll.index.delete') }}
                                                        </button>
                                                    </form>
                                                @else
                                                    <button class="btn btn-sm btn-danger" title="@if($payroll->status === 'paid') {{ __('payroll.employee_payrolls.cannot_delete_after_paid') }} @else {{ __('payroll.employee_payrolls.cannot_delete') }} @endif" disabled>
                                                        <i class="fas fa-trash"></i> {{ __('payroll.index.delete') }}
                                                    </button>
                                                @endif
                                            @endcan
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        {{ $payrolls->links() }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <div class="row mt-3">
        <div class="col-12">
            <a href="{{ route('payroll.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i> {{ __('payroll.employee_payrolls_page.back_to_list') }}
            </a>
        </div>
    </div>
</div>
@endsection