@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('payroll.edit.page_title', ['id' => $payroll->id]) }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('payroll.index.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('payroll.index') }}">{{ __('payroll.index.breadcrumb_payroll') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('payroll.edit.page_title', ['id' => $payroll->id]) }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('payroll.edit.page_title', ['id' => $payroll->id]) }}</h4>

                    @if($payroll->status !== 'pending')
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> {{ __('payroll.edit.cannot_edit_status', ['status' => $payroll->status]) }}
                        </div>
                        <a href="{{ route('payroll.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> {{ __('payroll.employee_payrolls_page.back_to_list') }}</a>
                    @else
                        <form action="{{ route('payroll.update', $payroll) }}" method="POST" id="payroll-edit-form">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="employee_id" value="{{ $payroll->employee_id }}">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="month" class="form-label">{{ __('payroll.create.month') }} <span class="text-danger">*</span></label>
                                    <select class="form-control" id="month" name="month" required>
                                        @for($m = 1; $m <= 12; $m++)
                                            <option value="{{ $m }}" {{ old('month', $payroll->month) == $m ? 'selected' : '' }}>
                                                {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                        @isset($paidOffDays)
                        <tr>
                            <th>أيام الحضور المدفوعة:</th>
                            <td>{{ $paidOffDays }}</td>
                            <th>قيمة أيام الحضور المدفوعة:</th>
                            <td class="fw-bold">{{ number_format($paidOffAmount ?? 0, 2) }} {{ get_currency_code() }}</td>
                        </tr>
                        @endisset
                                            </option>
                                        @endfor
                                    </select>
                                    @error('month')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="year" class="form-label">{{ __('payroll.create.year') }} <span class="text-danger">*</span></label>
                                    <select class="form-control" id="year" name="year" required>
                                        @php
                                            $currentYear = now()->year;
                                            $startYear = $currentYear - 1;
                                            $endYear = $currentYear + 25;
                                        @endphp
                                        @for($y = $startYear; $y <= $endYear; $y++)
                                            <option value="{{ $y }}" {{ old('year', $payroll->year) == $y ? 'selected' : '' }}>{{ $y }}</option>
                                        @endfor
                                    </select>
                                    @error('year')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="basic_salary" class="form-label">{{ __('payroll.create.basic_salary') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="basic_salary" name="basic_salary" value="{{ old('basic_salary', $payroll->basic_salary) }}" step="0.01" min="0" required>
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                    @error('basic_salary')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="incentives" class="form-label">{{ __('payroll.create.incentives') }}</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="incentives" name="incentives" value="{{ old('incentives', $payroll->incentives) }}" step="0.01" min="0">
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                    @error('incentives')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                                </div>
                                <div class="col-md-3 mb-3">
                                    @php
                                        $paidOffExisting = 0;
                                        if ($payroll->relationLoaded('payrollSalaryComponents')) {
                                            foreach ($payroll->payrollSalaryComponents as $psc) {
                                                $meta = $psc->meta ?? null;
                                                $isPaidOff = false;
                                                if (is_array($meta) && (($meta['type'] ?? '') === 'paid_off_days')) $isPaidOff = true;
                                                if (($psc->name ?? '') === 'Paid Off-day Compensation') $isPaidOff = true;
                                                if ($isPaidOff) { $paidOffExisting = $psc->value; break; }
                                            }
                                        }
                                    @endphp
                                    <label for="paid_off_amount" class="form-label">قيمة أيام الحضور المدفوعة</label>
                                    <div class="input-group">
                                        <input type="number" step="0.01" min="0" class="form-control" id="paid_off_amount" name="paid_off_amount" value="{{ old('paid_off_amount', $paidOffExisting) }}">
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label class="form-label">{{ __('payroll.create.active_deductions') }}</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="active_deductions" name="active_deductions" value="{{ old('active_deductions', $payroll->active_deductions) }}" step="0.01" min="0" readonly>
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label class="form-label">{{ __('payroll.create.loan_installments') }}</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="loan_installments" name="loan_installments" value="{{ old('loan_installments', $payroll->loan_installments) }}" step="0.01" min="0" readonly>
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('payroll.create.pending_installments', [], null) ?: 'أقساط القرض المعلقة لهذا الشهر' }}</label>
                                    <div class="card p-2" style="max-height:200px; overflow:auto;">
                                        @php
                                            $selectedInstallments = [];
                                            if (!empty($payroll->meta) && is_array($payroll->meta)) {
                                                $selectedInstallments = $payroll->meta['installment_ids'] ?? [];
                                            } elseif (!empty($payroll->meta) && is_string($payroll->meta)) {
                                                $tmp = json_decode($payroll->meta, true) ?: [];
                                                $selectedInstallments = $tmp['installment_ids'] ?? [];
                                            }
                                        @endphp
                                        @if(!empty($pendingInstallments) && $pendingInstallments->isNotEmpty())
                                            @foreach($pendingInstallments as $inst)
                                                <div class="form-check">
                                                    <input class="form-check-input installment-checkbox" type="checkbox" value="{{ $inst->id }}" id="edit_inst_{{ $inst->id }}" name="installment_ids[]" {{ in_array($inst->id, $selectedInstallments) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="edit_inst_{{ $inst->id }}">#{{ $inst->id }} — {{ number_format($inst->amount,2) }} {{ get_currency_code() }} — {{ \Carbon\Carbon::parse($inst->due_date)->toDateString() }} ({{ $inst->loan?->loan_type ?? '' }})</label>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="text-muted">{{ __('payroll.create.no_pending_installments', [], null) ?: 'لا توجد أقساط معلقة لهذا الشهر.' }}</div>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label class="form-label">{{ __('payroll.create.leave_deduction') }}</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="leave_deduction" name="leave_deduction" value="{{ old('leave_deduction', $payroll->leave_deduction) }}" step="0.01" min="0" readonly>
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="net_salary" class="form-label">{{ __('payroll.create.net_salary') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="net_salary" name="net_salary" value="{{ old('net_salary', $payroll->net_salary) }}" step="0.01" min="0" required readonly>
                                        <span class="input-group-text">{{ get_currency_code() }}</span>
                                    </div>
                                    @error('net_salary')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                                </div>
                            </div>

                            <!-- مكونات الراتب الإضافية -->
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <h5>{{ __('payroll.create.additional_components') }}</h5>
                                    <div id="salary-components-container">
                                        @foreach($payroll->payrollSalaryComponents as $psc)
                                            <div class="row component-row mb-2">
                                                        <div class="col-md-5">
                                                            <input type="text" class="form-control" value="{{ $psc->salaryComponent?->name ?? $psc->name ?? ('Component #' . ($psc->salary_component_id ?? '')) }}" readonly>
                                                            <input type="hidden" name="salary_component_ids[]" value="{{ $psc->salary_component_id }}">
                                                        </div>
                                                <div class="col-md-5">
                                                    <input type="number" step="0.01" name="salary_component_values[]" class="form-control component-value" value="{{ $psc->value }}" required>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="notes" class="form-label">{{ __('payroll.create.notes') }}</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="{{ __('payroll.create.notes_placeholder', [], null) ?: 'Any additional notes' }}">{{ old('notes', $payroll->notes) }}</textarea>
                                @error('notes')<div class="text-danger mt-1">{{ $message }}</div>@enderror
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-warning"><i class="fas fa-save"></i> {{ __('payroll.edit.save') }}</button>
                                <a href="{{ route('payroll.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> {{ __('payroll.employee_payrolls_page.back_to_list') }}</a>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- معلومات الإجازات -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">تفاصيل الإجازات لشهر <span id="current_month_year_display">{{ $payroll->month }}/{{ $payroll->year }}</span></h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>الأيام المسموح بها شهريًا:</th>
                            <td id="employee_leave_allowed">{{ $payroll->employee->monthly_leave_days_allowed ?? 0 }} يوم</td>
                        </tr>
                        <tr>
                            <th>الأيام المستخدمة (من السجل):</th>
                            <td id="employee_leave_used">{{ $usedLeaveDays ?? 0 }} يوم</td>
                        </tr>
                        <tr>
                            <th>الأيام الزائدة:</th>
                            <td id="employee_excess_days">{{ $excessDays ?? 0 }} يوم</td>
                        </tr>
                        <tr>
                            <th>{{ __('payroll.labels.daily_rate') }}:</th>
                            <td id="employee_daily_rate">{{ number_format($dailyRate ?? 0, 2) }} {{ get_currency_code() }}</td>
                        </tr>
                        <tr>
                            <th>خصم الإجازات:</th>
                            <td id="employee_leave_deduction" class="text-danger">- {{ number_format($leaveDeduction ?? 0, 2) }} {{ get_currency_code() }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- تفاصيل الراتب -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات الراتب</h5>
                    <table class="table table-borderless">
                        <tr><th>الحالة:</th><td><span class="badge bg-{{ $payroll->status == 'paid' ? 'success' : ($payroll->status == 'pending' ? 'warning' : 'danger') }}">{{ $payroll->status == 'paid' ? 'مدفوع' : ($payroll->status == 'pending' ? 'قيد الدفع' : 'ملغى') }}</span></td></tr>
                        <tr><th>تاريخ الإنشاء:</th><td>{{ $payroll->created_at->format('Y-m-d H:i') }}</td></tr>
                        @if($payroll->paid_at)
                            <tr><th>تاريخ الدفع:</th><td>{{ $payroll->paid_at->format('Y-m-d H:i') }}</td></tr>
                        @endif
                        <tr>
                            <th>{{ __('payroll.create.overtime_hours', [], null) ?: 'ساعات الأوفر تايم لهذا الشهر' }}:</th>
                            <td>{{ number_format($attendanceOvertimeHours ?? 0, 2) }} {{ __('payroll.labels.hours', [], null) ?: 'س' }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('payroll.create.overtime_amount', [], null) ?: 'قيمة الأوفر تايم' }}:</th>
                            <td class="fw-bold">{{ number_format($overtimeAmount ?? 0, 2) }} {{ get_currency_code() }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const basicSalaryInput = document.getElementById('basic_salary');
    const incentivesInput = document.getElementById('incentives');
    const activeDeductionsInput = document.getElementById('active_deductions');
    const loanInstallmentsInput = document.getElementById('loan_installments');
    const leaveDeductionInput = document.getElementById('leave_deduction');
    const netSalaryInput = document.getElementById('net_salary');

    function calculateNetSalary() {
        const basic = parseFloat(basicSalaryInput.value) || 0;
        const incentives = parseFloat(incentivesInput.value) || 0;
        const deductions = parseFloat(activeDeductionsInput.value) || 0;
        const loans = parseFloat(loanInstallmentsInput.value) || 0;
        const leave = parseFloat(leaveDeductionInput.value) || 0;
        const paidOff = parseFloat(document.getElementById('paid_off_amount')?.value) || 0;

        let totalComponents = 0;
        document.querySelectorAll('.component-value').forEach(el => {
            totalComponents += parseFloat(el.value) || 0;
        });

        // include paid_off_amount as an earning component
        totalComponents += paidOff;

        const net = basic + incentives + totalComponents - deductions - loans - leave;
        netSalaryInput.value = net.toFixed(2);
    }

    // ربط معالجات الأحداث
    [basicSalaryInput, incentivesInput].forEach(input => {
        if (input) input.addEventListener('input', calculateNetSalary);
    });

    document.getElementById('salary-components-container').addEventListener('input', function(e) {
        if (e.target.classList.contains('component-value')) calculateNetSalary();
    });

    // الحساب الأولي عند التحميل
    calculateNetSalary();
});
</script>
@endpush
@endsection