@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('payroll.create.page_title', ['name' => $employee->name]) }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('payroll.create.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('payroll.index') }}">{{ __('payroll.create.breadcrumb_payroll') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('payroll.create.breadcrumb_create') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Info Card -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('payroll.create.employee_info') }}</h5>
                    <p><strong>{{ __('payroll.create.employee_id') }}:</strong> {{ $employee->employee_id }}</p>
                    <p><strong>{{ __('payroll.create.department') }}:</strong> {{ $employee->department?->name ?? __('payroll.create.not_specified') }}</p>
                    <p><strong>{{ __('payroll.create.position') }}:</strong> {{ $employee->position?->name ?? __('payroll.create.not_specified') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Payroll Form -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ __('payroll.create.form_title') }}</h5>
                    {{-- show validation errors and flash messages so the user sees why save may have failed --}}
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form id="payroll-create-form" action="{{ route('payroll.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="employee_id" value="{{ $employee->id }}">

                        <!-- حقل مخفي لتفعيل استجابة debug التشخيصية -->
                        <input type="hidden" name="debug" value="1">

                        {{-- AJAX alerts container --}}
                        <div id="ajax-alerts"></div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="month" class="form-label">{{ __('payroll.create.month') }}</label>
                                    <select class="form-control" id="month" name="month" required>
                                        @for($m = 1; $m <= 12; $m++)
                                            <option value="{{ $m }}" {{ now()->month == $m ? 'selected' : '' }}>
                                                {{ \Carbon\Carbon::create()->month($m)->translatedFormat('F') }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="year" class="form-label">{{ __('payroll.create.year') }}</label>
                                    <select class="form-control" id="year" name="year" required>
                                        @for($y = now()->year - 1; $y <= now()->year + 1; $y++)
                                            <option value="{{ $y }}" {{ now()->year == $y ? 'selected' : '' }}>{{ $y }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="basic_salary" class="form-label">{{ __('payroll.create.basic_salary') }}</label>
                                    <input type="number" class="form-control" id="basic_salary" name="basic_salary" value="{{ $employee->salary }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="incentives" class="form-label">{{ __('payroll.create.incentives') }}</label>
                                    <input type="number" class="form-control" id="incentives" name="incentives" value="0">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="deductions" class="form-label">{{ __('payroll.create.deductions') }}</label>
                                    <input type="number" class="form-control" id="deductions" name="deductions" value="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="net_salary" class="form-label">{{ __('payroll.create.net_salary') }}</label>
                                    <input type="number" class="form-control" id="net_salary" name="net_salary" readonly>
                                </div>
                            </div>
                        </div>
                        {{-- Paid-off days (attendances on weekly-off/holidays) --}}
                        @isset($paidOffDays)
                        <div class="row mb-3">
                            <div class="col-12">
                                <div class="alert alert-info mb-0">
                                    <strong>أيام حضور مدفوعة:</strong> {{ $paidOffDays }}
                                    @isset($paidOffAmount)
                                        — <strong>المبلغ:</strong> {{ number_format($paidOffAmount, 2) }} {{ $currency_name ?? get_currency_code() }}
                                    @endisset
                                </div>
                            </div>
                        </div>
                        @endisset

                        {{-- حقل قابل للتعديل لإدخال قيمة أيام الحضور المدفوعة يدويًا --}}
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="paid_off_amount" class="form-label">قيمة أيام الحضور المدفوعة</label>
                                <div class="input-group">
                                    <input type="number" step="0.01" min="0" class="form-control" id="paid_off_amount" name="paid_off_amount" value="{{ old('paid_off_amount', $paidOffAmount ?? 0) }}">
                                    <span class="input-group-text">{{ $currency_name ?? get_currency_code() }}</span>
                                </div>
                                <small class="text-muted">أدخل المبلغ الإجمالي لعدد أيام الحضور المدفوعة (اختياري)</small>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-success">{{ __('payroll.create.submit') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('payroll-create-form');
    const alerts = document.getElementById('ajax-alerts');
    if (!form) return;

    form.addEventListener('submit', async function (e) {
        e.preventDefault();
        // clear previous alerts
        alerts.innerHTML = '';

        const url = form.action;
        const formData = new FormData(form);

        // show simple loading state
        const submitBtn = form.querySelector('button[type="submit"]');
        const originalText = submitBtn ? submitBtn.textContent : null;
        if (submitBtn) { submitBtn.disabled = true; submitBtn.textContent = 'جاري الحفظ...'; }

        try {
            const tokenMeta = document.querySelector('meta[name="csrf-token"]');
            const csrf = tokenMeta ? tokenMeta.getAttribute('content') : '';

            const res = await fetch(url, {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': csrf,
                    'Accept': 'application/json'
                },
                body: formData,
                credentials: 'same-origin',
            });

            // If the server redirected (normal redirect after successful save), follow it
            if (res.redirected) {
                window.location.href = res.url;
                return;
            }

            const contentType = res.headers.get('content-type') || '';
            if (res.status === 422 || contentType.indexOf('application/json') !== -1) {
                const data = await res.json();
                // Laravel returns {errors: {...}} on validation failure
                if (data.errors) {
                    const ul = document.createElement('ul');
                    ul.className = 'mb-0';
                    for (const k in data.errors) {
                        (data.errors[k] || []).forEach(msg => {
                            const li = document.createElement('li'); li.textContent = msg; ul.appendChild(li);
                        });
                    }
                    const div = document.createElement('div');
                    div.className = 'alert alert-danger';
                    div.appendChild(ul);
                    alerts.appendChild(div);
                } else if (data.success) {
                    const div = document.createElement('div');
                    div.className = 'alert alert-success';
                    div.textContent = data.message || 'تم الحفظ بنجاح';
                    alerts.appendChild(div);
                    // optionally redirect if server provided location
                    if (data.redirect) { window.location.href = data.redirect; }
                } else {
                    // unknown json response - show raw
                    const div = document.createElement('div');
                    div.className = 'alert alert-info';
                    div.textContent = JSON.stringify(data);
                    alerts.appendChild(div);
                }
            } else {
                // fallback: parse text and try to detect success or show response HTML
                const text = await res.text();
                // if text contains 'success' flash, redirect to index
                if (text.indexOf('alert-success') !== -1 || text.indexOf('تم إنشاء راتب') !== -1) {
                    // try to navigate to payroll index
                    window.location.href = '{{ route('payroll.index') }}';
                } else {
                    const div = document.createElement('div');
                    div.className = 'alert alert-info';
                    div.innerHTML = text.substring(0, 1000);
                    alerts.appendChild(div);
                }
            }

        } catch (err) {
            const div = document.createElement('div');
            div.className = 'alert alert-danger';
            div.textContent = 'خطأ في الاتصال بالخادم: ' + (err.message || err);
            alerts.appendChild(div);
        } finally {
            if (submitBtn) { submitBtn.disabled = false; submitBtn.textContent = originalText; }
        }
    });
});
</script>
@endpush