@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تفاصيل الاستقطاع</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('deductions.index') }}">الاستقطاعات</a></li>
                        <li class="breadcrumb-item active">تفاصيل الاستقطاع</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">استقطاع #{{ $deduction->id }}</h4>
                            <p class="text-muted">للموظف {{ $deduction->employee->name }}</p>
                        </div>
                        <div>
                            @if($deduction->is_active)
                                <span class="badge badge-success fs-6">نشط</span>
                            @else
                                <span class="badge badge-secondary fs-6">غير نشط</span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">معلومات الاستقطاع</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>نوع الاستقطاع:</th>
                                    <td>
                                        @switch($deduction->deduction_type)
                                            @case('tax')
                                                <span class="badge badge-soft-primary">ضريبة</span>
                                                @break
                                            @case('insurance')
                                                <span class="badge badge-soft-success">تأمين</span>
                                                @break
                                            @case('loan')
                                                <span class="badge badge-soft-warning">قرض</span>
                                                @break
                                            @case('fine')
                                                <span class="badge badge-soft-danger">غرامة</span>
                                                @break
                                            @case('other')
                                                <span class="badge badge-soft-info">أخرى</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-dark">{{ $deduction->deduction_type }}</span>
                                        @endswitch
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ:</th>
                                    <td>{{ number_format($deduction->amount, 2) }} د.ك</td>
                                </tr>
                                <tr>
                                    <th>التكرار:</th>
                                    <td>
                                        @switch($deduction->frequency)
                                            @case('monthly')
                                                <span class="badge badge-soft-primary">شهري</span>
                                                @break
                                            @case('annual')
                                                <span class="badge badge-soft-success">سنوي</span>
                                                @break
                                            @case('one_time')
                                                <span class="badge badge-soft-info">مرة واحدة</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">تفاصيل الوقت</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>تاريخ البدء:</th>
                                    <td>{{ $deduction->start_date->format('Y-m-d') }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الانتهاء:</th>
                                    <td>{{ $deduction->end_date ? $deduction->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء:</th>
                                    <td>{{ $deduction->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث:</th>
                                    <td>{{ $deduction->updated_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($deduction->description)
                    <div class="mb-4">
                        <h5 class="mb-3">الوصف</h5>
                        <div class="alert alert-light border">
                            {{ $deduction->description }}
                        </div>
                    </div>
                    @endif

                    <div class="d-flex gap-2">
                        @can('edit deduction')
                        <a href="{{ route('deductions.edit', $deduction) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan

                        @can('delete deduction')
                        <form action="{{ route('deductions.destroy', $deduction) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('{{ addslashes(__('app.confirm_delete_deduction')) }}')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                        @endcan

                        <a href="{{ route('deductions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    @if($deduction->employee->photo)
                        <img src="{{ asset('storage/' . $deduction->employee->photo) }}" alt="صورة الموظف" class="img-fluid rounded-circle mb-3" width="120">
                    @else
                        <div class="avatar-lg mx-auto mb-3">
                            <span class="avatar-title bg-primary text-white rounded-circle">
                                {{ substr($deduction->employee->name, 0, 1) }}
                            </span>
                        </div>
                    @endif
                    <h4>{{ $deduction->employee->name }}</h4>
                    <p class="text-muted">{{ $deduction->employee->position?->name ?? 'غير محدد' }}</p>
                    <p class="text-muted">{{ $deduction->employee->department?->name ?? 'غير محدد' }}</p>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ $deduction->employee->salary ?? 0 }}</h5>
                            <p class="text-muted mb-0">الراتب الشهري</p>
                        </div>
                        <div class="col-6">
                            <h5>{{ $deduction->employee->deductions->where('is_active', true)->count() }}</h5>
                            <p class="text-muted mb-0">الاستقطاعات النشطة</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Deduction Summary -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">ملخص الاستقطاع</h5>
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <tr>
                                <th>المبلغ الشهري:</th>
                                <td class="text-end">
                                    @if($deduction->frequency == 'monthly')
                                        {{ number_format($deduction->amount, 2) }} د.ك
                                    @elseif($deduction->frequency == 'annual')
                                        {{ number_format($deduction->amount / 12, 2) }} د.ك
                                    @else
                                        {{ number_format($deduction->amount, 2) }} د.ك
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>المبلغ السنوي:</th>
                                <td class="text-end">
                                    @if($deduction->frequency == 'monthly')
                                        {{ number_format($deduction->amount * 12, 2) }} د.ك
                                    @elseif($deduction->frequency == 'annual')
                                        {{ number_format($deduction->amount, 2) }} د.ك
                                    @else
                                        {{ number_format($deduction->amount, 2) }} د.ك
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>الحالة:</th>
                                <td class="text-end">
                                    @if($deduction->is_active)
                                        <span class="badge badge-success">نشط</span>
                                    @else
                                        <span class="badge badge-secondary">غير نشط</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection