<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm">
    <div class="container-fluid">
        <!-- Brand -->
        {{-- تم تصحيح الرابط هنا --}}
        <a class="navbar-brand d-flex align-items-center" href="{{ route('dashboard.index') }}">
            <i class="fas fa-building me-2"></i>
            <span>نظام الموارد البشرية</span>
        </a>
        
        <!-- Mobile Toggle -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent"
                aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <!-- Navbar Content -->
        <div class="collapse navbar-collapse" id="navbarContent">
            <!-- Main Navigation -->
            <ul class="navbar-nav me-auto">
                @auth
                    <li class="nav-item">
                        {{-- تم تصحيح الرابط هنا --}}
                        <a class="nav-link {{ request()->routeIs('dashboard.index') ? 'active' : '' }}" 
                           href="{{ route('dashboard.index') }}">
                            <i class="fas fa-home me-1"></i>
                            لوحة التحكم
                        </a>
                    </li>
                    
                    @can('view employee')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('employees.*') ? 'active' : '' }}" 
                           href="{{ route('employees.index') }}">
                            <i class="fas fa-users me-1"></i>
                            الموظفين
                        </a>
                    </li>
                    @endcan
                    
                    @can('view attendance')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('attendance.*') ? 'active' : '' }}" 
                           href="{{ route('attendance.index') }}">
                            <i class="fas fa-clock me-1"></i>
                            الحضور
                        </a>
                    </li>
                    @endcan
                    
                    @can('view leave')
                    <li class="nav-item">
                        {{-- تم تصحيح الرابط هنا --}}
                        <a class="nav-link {{ request()->routeIs('leaves.*') ? 'active' : '' }}" 
                           href="{{ route('leaves.index') }}">
                            <i class="fas fa-umbrella-beach me-1"></i>
                            الإجازات
                        </a>
                    </li>
                    @endcan
                    
                    @can('view payroll')
                    <li class="nav-item">
                        {{-- تم تصحيح الرابط هنا --}}
                        <a class="nav-link {{ request()->routeIs('salaries.*') ? 'active' : '' }}" 
                           href="{{ route('salaries.index') }}">
                            <i class="fas fa-money-bill-wave me-1"></i>
                            الرواتب
                        </a>
                    </li>
                    @endcan
                    
                    @can('view loan')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('loans.*') ? 'active' : '' }}" 
                           href="{{ route('loans.index') }}">
                            <i class="fas fa-credit-card me-1"></i>
                            القروض
                        </a>
                    </li>
                    @endcan
                    
                    @can('view deduction')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('deductions.*') ? 'active' : '' }}" 
                           href="{{ route('deductions.index') }}">
                            <i class="fas fa-minus-circle me-1"></i>
                            الاستقطاعات
                        </a>
                    </li>
                    @endcan
                    
                    @can('view training')
                    <li class="nav-item">
                        {{-- تم تعطيل الرابط مؤقتاً لعدم وجود مسار له --}}
                        <a class="nav-link disabled" 
                           href="#">
                            <i class="fas fa-graduation-cap me-1"></i>
                            التدريب
                        </a>
                    </li>
                    @endcan
                    
                    @can('view notification')
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle {{ request()->routeIs('notifications.*') ? 'active' : '' }}" 
                           href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-bell me-1"></i>
                            الإشعارات
                            {{-- ✅ عرض العلامة فقط إذا كان هناك إشعارات غير مقروءة --}}
                            @auth
                                @php
                                    $user = auth()->user();
                                    $isAdminOrHR = $user->hasRole('admin') || $user->hasRole('hr') || $user->hasRole('super-admin');
                                    $unreadNotificationsCount = $isAdminOrHR ? $user->unreadNotifications()->count() : 0;
                                @endphp
                                @if ($isAdminOrHR && $unreadNotificationsCount > 0)
                                    <span class="badge bg-danger rounded-pill">
                                        {{ $unreadNotificationsCount }}
                                    </span>
                                @endif
                            @endauth
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{ route('notifications.index') }}">
                                <i class="fas fa-list me-1"></i>
                                جميع الإشعارات
                            </a></li>
                            <li><a class="dropdown-item" href="{{ route('notifications.settings') }}">
                                <i class="fas fa-cog me-1"></i>
                                إعدادات الإشعارات
                            </a></li>
                            {{-- ✅ زر "تعليم الكل" --}}
                            @auth
                                @if ($isAdminOrHR && $unreadNotificationsCount > 0) <!-- ⭐ نفس الشرط -->
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="#" id="markAllAsReadNavbar">
                                    <i class="fas fa-check-double me-1"></i>
                                    تعليم الكل كمقروء
                                </a></li>
                                @endif
                            @endauth
                        </ul>
                    </li>
                    @endcan
                    
                    @can('view user')
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle {{ request()->routeIs('users.*') || request()->routeIs('roles.*') ? 'active' : '' }}" 
                           href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-cog me-1"></i>
                            الإدارة
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{ route('users.index') }}">
                                <i class="fas fa-users-cog me-1"></i>
                                المستخدمين
                            </a></li>
                            @can('view role')
                            <li><a class="dropdown-item" href="{{ route('roles.index') }}">
                                <i class="fas fa-user-shield me-1"></i>
                                الأدوار والصلاحيات
                            </a></li>
                            @endcan
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="#">
                                <i class="fas fa-cog me-1"></i>
                                إعدادات النظام
                            </a></li>
                        </ul>
                    </li>
                    @endcan
                @endauth
            </ul>
            
            <!-- User Menu -->
            @auth
            <ul class="navbar-nav">
                <!-- Quick Actions -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-plus-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        @can('create employee')
                        <li><a class="dropdown-item" href="{{ route('employees.create') }}">
                            <i class="fas fa-user-plus me-2 text-primary"></i>
                            إضافة موظف
                        </a></li>
                        @endcan
                        @can('create leave')
                        {{-- تم تصحيح الرابط هنا --}}
                        <li><a class="dropdown-item" href="{{ route('leaves.create') }}">
                            <i class="fas fa-umbrella-beach me-2 text-warning"></i>
                            طلب إجازة
                        </a></li>
                        @endcan
                        {{-- removed old quick 'تسجيل حضور' link because page has dedicated quick actions/buttons now --}}
                        @can('create loan')
                        <li><a class="dropdown-item" href="{{ route('loans.create') }}">
                            <i class="fas fa-credit-card me-2 text-success"></i>
                            طلب قرض
                        </a></li>
                        @endcan
                        @can('create payroll')
                        {{-- تم تصحيح الرابط هنا --}}
                        <li><a class="dropdown-item" href="{{ route('salaries.create') }}">
                            <i class="fas fa-money-bill-wave me-2 text-success"></i>
                            إنشاء راتب
                        </a></li>
                        @endcan
                    </ul>
                </li>
                
                <!-- User Profile -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown">
                        <div class="avatar-sm me-2">
                            <span class="avatar-title bg-white text-primary rounded-circle">
                                {{ substr(auth()->user()->name, 0, 1) }}
                            </span>
                        </div>
                        <span class="d-none d-md-inline">{{ auth()->user()->name }}</span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <h6 class="dropdown-header">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm me-2">
                                        <span class="avatar-title bg-primary text-white rounded-circle">
                                            {{ substr(auth()->user()->name, 0, 1) }}
                                        </span>
                                    </div>
                                    <div>
                                        <div>{{ auth()->user()->name }}</div>
                                        <small class="text-muted">{{ auth()->user()->email }}</small>
                                    </div>
                                </div>
                            </h6>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#">
                            <i class="fas fa-user me-2"></i>
                            الملف الشخصي
                        </a></li>
                        <li><a class="dropdown-item" href="#">
                            <i class="fas fa-cog me-2"></i>
                            الإعدادات
                        </a></li>
                        @can('view notification')
                        <li><a class="dropdown-item" href="{{ route('notifications.index') }}">
                            <i class="fas fa-bell me-2"></i>
                            الإشعارات
                            {{-- ✅ عرض العلامة فقط إذا كان هناك إشعارات غير مقروءة --}}
                            @auth
                                @php
                                    $user = auth()->user();
                                    $isAdminOrHR = $user->hasRole('admin') || $user->hasRole('hr') || $user->hasRole('super-admin');
                                    $unreadNotificationsCount = $isAdminOrHR ? $user->unreadNotifications()->count() : 0;
                                @endphp
                                @if ($isAdminOrHR && $unreadNotificationsCount > 0)
                                    <span class="badge bg-danger rounded-pill float-end">
                                        {{ $unreadNotificationsCount }}
                                    </span>
                                @endif
                            @endauth
                        </a></li>
                        @endcan
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="dropdown-item">
                                    <i class="fas fa-sign-out-alt me-2"></i>
                                    تسجيل الخروج
                                </button>
                            </form>
                        </li>
                    </ul>
                </li>
            </ul>
            @else
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('login') }}">
                        <i class="fas fa-sign-in-alt me-1"></i>
                        تسجيل الدخول
                    </a>
                </li>
                @if(Route::has('register'))
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('register') }}">
                        <i class="fas fa-user-plus me-1"></i>
                        إنشاء حساب
                    </a>
                </li>
                @endif
            </ul>
            @endauth
        </div>
    </div>
</nav>

<!-- Mark All as Read Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const markAllAsRead = document.getElementById('markAllAsReadNavbar');
    if (markAllAsRead) {
        markAllAsRead.addEventListener('click', function(e) {
            e.preventDefault();
            if (confirm('{{ addslashes(__('app.confirm_mark_all_notifications_read')) }}')) {
                fetch('{{ route("notifications.read-all") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                });
            }
        });
    }
});
</script>