@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">إدارة الاستقطاعات</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">الاستقطاعات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">إجمالي الاستقطاعات</p>
                            <h4 class="mb-0">{{ $totalDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-minus-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">الشهرية</p>
                            <h4 class="mb-0">{{ $monthlyDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-calendar-alt fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">السنوية</p>
                            <h4 class="mb-0">{{ $annualDeductions ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-calendar-year fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">إجمالي المبالغ</p>
                            <h4 class="mb-0">{{ number_format($totalAmount ?? 0, 2) }} د.ك</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-money-bill-wave fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">قائمة الاستقطاعات</h4>
                        @can('create deduction')
                        <a href="{{ route('deductions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة استقطاع جديد
                        </a>
                        @endcan
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="البحث عن موظف...">
                        </div>
                        <div class="col-md-2">
                            <select id="employeeFilter" class="form-control">
                                <option value="">جميع الموظفين</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="typeFilter" class="form-control">
                                <option value="">جميع الأنواع</option>
                                <option value="tax">ضريبة</option>
                                <option value="insurance">تأمين</option>
                                <option value="loan">قرض</option>
                                <option value="fine">غرامة</option>
                                <option value="other">أخرى</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="frequencyFilter" class="form-control">
                                <option value="">جميع التكرارات</option>
                                <option value="monthly">شهري</option>
                                <option value="annual">سنوي</option>
                                <option value="one_time">مرة واحدة</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <button id="resetFilters" class="btn btn-secondary">
                                <i class="fas fa-redo"></i> إعادة تعيين
                            </button>
                        </div>
                    </div>

                    <!-- Deductions Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>اسم الموظف</th>
                                    <th>نوع الاستقطاع</th>
                                    <th>المبلغ</th>
                                    <th>التكرار</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deductions as $deduction)
                                <tr>
                                    <td>{{ $deduction->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($deduction->employee->photo)
                                                <img src="{{ asset('storage/' . $deduction->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        {{ substr($deduction->employee->name, 0, 1) }}
                                                    </span>
                                                </div>
                                            @endif
                                            <div>
                                                <h5 class="font-size-14 mb-0">{{ $deduction->employee->name }}</h5>
                                                <p class="text-muted mb-0">{{ $deduction->employee->position?->name ?? 'غير محدد' }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @switch($deduction->deduction_type)
                                            @case('tax')
                                                <span class="badge badge-soft-primary">ضريبة</span>
                                                @break
                                            @case('insurance')
                                                <span class="badge badge-soft-success">تأمين</span>
                                                @break
                                            @case('loan')
                                                <span class="badge badge-soft-warning">قرض</span>
                                                @break
                                            @case('fine')
                                                <span class="badge badge-soft-danger">غرامة</span>
                                                @break
                                            @case('other')
                                                <span class="badge badge-soft-info">أخرى</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-dark">{{ $deduction->deduction_type }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ number_format($deduction->amount, 2) }} د.ك</td>
                                    <td>
                                        @switch($deduction->frequency)
                                            @case('monthly')
                                                <span class="badge badge-soft-primary">شهري</span>
                                                @break
                                            @case('annual')
                                                <span class="badge badge-soft-success">سنوي</span>
                                                @break
                                            @case('one_time')
                                                <span class="badge badge-soft-info">مرة واحدة</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $deduction->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $deduction->end_date ? $deduction->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>
                                        @if($deduction->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-secondary">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view deduction')
                                            <a href="{{ route('deductions.show', $deduction) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('edit deduction')
                                            <a href="{{ route('deductions.edit', $deduction) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan

                                            @can('delete deduction')
                                            <form action="{{ route('deductions.destroy', $deduction) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="{{ __('app.delete') }}" onclick="return confirm('{{ addslashes(__('app.confirm_delete_deduction')) }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">
                                        <i class="fas fa-minus-circle fa-3x mb-3"></i>
                                        <h5>لا توجد استقطاعات مسجلة</h5>
                                        <p class="text-muted">ابدأ بإضافة استقطاع جديد</p>
                                        @can('create deduction')
                                        <a href="{{ route('deductions.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> إضافة استقطاع جديد
                                        </a>
                                        @endcan
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($deductions->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $deductions->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats and Charts -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">توزيع الاستقطاعات حسب النوع</h4>
                    <canvas id="deductionTypesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">إحصائيات الاستقطاعات الشهرية</h4>
                    <canvas id="monthlyDeductionsChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Deduction Types Chart
    var ctx1 = document.getElementById('deductionTypesChart').getContext('2d');
    var deductionTypesChart = new Chart(ctx1, {
        type: 'pie',
        data: {
            labels: ['ضريبة', 'تأمين', 'قرض', 'غرامة', 'أخرى'],
            datasets: [{
                data: [30, 25, 20, 15, 10],
                backgroundColor: [
                    '#4361ee',
                    '#3a0ca3',
                    '#4cc9f0',
                    '#f72585',
                    '#7209b7'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Monthly Deductions Chart
    var ctx2 = document.getElementById('monthlyDeductionsChart').getContext('2d');
    var monthlyDeductionsChart = new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس'],
            datasets: [{
                label: 'إجمالي الاستقطاعات',
                data: [1200, 1500, 1100, 1300, 1600, 1400, 1250, 1550],
                backgroundColor: 'rgba(67, 97, 238, 0.7)',
                borderColor: 'rgba(67, 97, 238, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const employeeFilter = document.getElementById('employeeFilter');
    const typeFilter = document.getElementById('typeFilter');
    const frequencyFilter = document.getElementById('frequencyFilter');
    const resetFilters = document.getElementById('resetFilters');

    function filterTable() {
        console.log('Filtering deductions table...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (employeeFilter) employeeFilter.addEventListener('change', filterTable);
    if (typeFilter) typeFilter.addEventListener('change', filterTable);
    if (frequencyFilter) frequencyFilter.addEventListener('change', filterTable);
    if (resetFilters) resetFilters.addEventListener('click', function() {
        if (searchInput) searchInput.value = '';
        if (employeeFilter) employeeFilter.value = '';
        if (typeFilter) typeFilter.value = '';
        if (frequencyFilter) frequencyFilter.value = '';
        filterTable();
    });
});
</script>
@endsection