@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تعديل الاستقطاع</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('deductions.index') }}">الاستقطاعات</a></li>
                        <li class="breadcrumb-item active">تعديل الاستقطاع</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تعديل الاستقطاع</h4>

                    <form action="{{ route('deductions.update', $deduction) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">اسم الموظف</label>
                                <input type="text" class="form-control" value="{{ $deduction->employee->name }}" readonly>
                                <input type="hidden" name="employee_id" value="{{ $deduction->employee_id }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="deduction_type" class="form-label">نوع الاستقطاع <span class="text-danger">*</span></label>
                                <select class="form-control" id="deduction_type" name="deduction_type" required>
                                    <option value="">اختر نوع الاستقطاع</option>
                                    <option value="tax" {{ old('deduction_type', $deduction->deduction_type) == 'tax' ? 'selected' : '' }}>ضريبة</option>
                                    <option value="insurance" {{ old('deduction_type', $deduction->deduction_type) == 'insurance' ? 'selected' : '' }}>تأمين</option>
                                    <option value="loan" {{ old('deduction_type', $deduction->deduction_type) == 'loan' ? 'selected' : '' }}>قرض</option>
                                    <option value="fine" {{ old('deduction_type', $deduction->deduction_type) == 'fine' ? 'selected' : '' }}>غرامة</option>
                                    <option value="other" {{ old('deduction_type', $deduction->deduction_type) == 'other' ? 'selected' : '' }}>أخرى</option>
                                </select>
                                @error('deduction_type')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="amount" class="form-label">المبلغ <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="amount" name="amount" value="{{ old('amount', $deduction->amount) }}" step="0.01" min="0.01" required>
                                    <span class="input-group-text">د.ك</span>
                                </div>
                                @error('amount')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="frequency" class="form-label">التكرار <span class="text-danger">*</span></label>
                                <select class="form-control" id="frequency" name="frequency" required>
                                    <option value="">اختر التكرار</option>
                                    <option value="monthly" {{ old('frequency', $deduction->frequency) == 'monthly' ? 'selected' : '' }}>شهري</option>
                                    <option value="annual" {{ old('frequency', $deduction->frequency) == 'annual' ? 'selected' : '' }}>سنوي</option>
                                    <option value="one_time" {{ old('frequency', $deduction->frequency) == 'one_time' ? 'selected' : '' }}>مرة واحدة</option>
                                </select>
                                @error('frequency')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $deduction->start_date->format('Y-m-d')) }}" required>
                                @error('start_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="end_date" class="form-label">تاريخ الانتهاء</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date', $deduction->end_date ? $deduction->end_date->format('Y-m-d') : '') }}">
                                @error('end_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">الوصف</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="وصف الاستقطاع">{{ old('description', $deduction->description) }}</textarea>
                            @error('description')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $deduction->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                نشط
                            </label>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> تحديث الاستقطاع
                            </button>
                            <a href="{{ route('deductions.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات الموظف</h5>
                    <div class="d-flex align-items-center mb-3">
                        @if($deduction->employee->photo)
                            <img src="{{ asset('storage/' . $deduction->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-primary text-white rounded-circle">
                                    {{ substr($deduction->employee->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $deduction->employee->name }}</h6>
                            <p class="mb-0 text-muted">{{ $deduction->employee->position?->name ?? 'غير محدد' }}</p>
                            <p class="mb-0 text-muted">{{ $deduction->employee->department?->name ?? 'غير محدد' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection