@extends('layouts.app')

@section('title', 'إعدادات الإشعارات')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">إعدادات الإشعارات</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">إعدادات الإشعارات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">تفضيلات الإشعارات</h5>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('notifications.settings.update') }}">
                        @csrf
                        @method('POST')

                        <div class="mb-4">
                            <h6>الإشعارات عبر البريد الإلكتروني</h6>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" role="switch" id="email_enabled" name="email_enabled" {{ old('email_enabled', $settings->email_enabled ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label" for="email_enabled">تمكين الإشعارات عبر البريد الإلكتروني</label>
                            </div>
                        </div>

                        <div class="mb-4">
                            <h6>الإشعارات عبر واتساب</h6>
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox" role="switch" id="whatsapp_enabled" name="whatsapp_enabled" {{ old('whatsapp_enabled', $settings->whatsapp_enabled ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label" for="whatsapp_enabled">تمكين الإشعارات عبر واتساب</label>
                            </div>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fab fa-whatsapp"></i></span>
                                <input type="text" class="form-control" id="whatsapp_number" name="whatsapp_number" placeholder="أدخل رقم واتساب" value="{{ old('whatsapp_number', $settings->whatsapp_number ?? '') }}">
                            </div>
                        </div>

                        <div class="mb-4">
                            <h6>الإشعارات عبر تيليجرام</h6>
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox" role="switch" id="telegram_enabled" name="telegram_enabled" {{ old('telegram_enabled', $settings->telegram_enabled ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label" for="telegram_enabled">تمكين الإشعارات عبر تيليجرام</label>
                            </div>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fab fa-telegram"></i></span>
                                <input type="text" class="form-control" id="telegram_chat_id" name="telegram_chat_id" placeholder="أدخل معرف المحادثة (Chat ID)" value="{{ old('telegram_chat_id', $settings->telegram_chat_id ?? '') }}">
                            </div>
                        </div>

                        <div class="mb-4">
                            <h6>أنواع الإشعارات</h6>
                            <p class="text-muted small">حدد أنواع الإشعارات التي ترغب في تلقيها.</p>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" value="loan" id="nt_loan" name="notification_types[]" {{ in_array('loan', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="nt_loan">إشعارات القروض</label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" value="leave" id="nt_leave" name="notification_types[]" {{ in_array('leave', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="nt_leave">إشعارات الإجازات</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" value="payroll" id="nt_payroll" name="notification_types[]" {{ in_array('payroll', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="nt_payroll">إشعارات الرواتب</label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" value="attendance" id="nt_attendance" name="notification_types[]" {{ in_array('attendance', old('notification_types', $settings->notification_types ?? [])) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="nt_attendance">إشعارات الحضور</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ url()->previous() }}" class="btn btn-secondary">إلغاء</a>
                            <button type="submit" class="btn btn-primary">تحديث الإعدادات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection