{{-- resources/views/notifications/payroll-paid.blade.php --}}
<x-mail::message>
{{-- عنوان الإشعار --}}
<x-mail::panel>
    <h2 style="text-align: center; color: #28a745;">تم دفع الراتب لشهر {{ $payroll->month->format('F Y') }}</h2>
</x-mail::panel>

{{-- معلومات الموظف والراتب --}}
<x-mail::table>
| الحقل | القيمة |
| :----------------------------- | :------------------------------------- |
| اسم الموظف | {{ $payroll->employee->name }} |
| الشهر | {{ $payroll->month->format('F Y') }} |
| الراتب الأساسي | {{ number_format($payroll->basic_salary, 2) }} {{ $currency_name ?? 'د.ك' }} |
| البدلات | {{ number_format($payroll->allowances, 2) }} {{ $currency_name ?? 'د.ك' }} |
| الخصومات | {{ number_format($payroll->deductions, 2) }} {{ $currency_name ?? 'د.ك' }} |
| الراتب الصافي | {{ number_format($payroll->net_salary, 2) }} {{ $currency_name ?? 'د.ك' }} |
| تاريخ الدفع | {{ $payroll->paid_at->format('Y-m-d') }} |
</x-mail::table>

{{-- رسالة إضافية --}}
<p>مرحبًا {{ $payroll->employee->name }},</p>
<p>نود إبلاغك بأنه تم دفع راتبك لشهر <strong>{{ $payroll->month->format('F Y') }}</strong> بنجاح.</p>

{{-- زر للذهاب إلى تفاصيل الراتب --}}
<x-mail::button :url="url('/payroll/' . $payroll->id)" color="success">
    عرض تفاصيل الراتب
</x-mail::button>

{{-- خاتمة --}}
<p style="text-align: center; margin-top: 20px;">
    شكرًا لاستخدامك نظام إدارة الموارد البشرية!
</p>
</x-mail::message>