{{-- resources/views/notifications/index.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('notifications.management') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('dashboard.home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('notifications.management') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-md-4">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('notifications.total') }}</p>
                            <h4 class="mb-0">{{ $totalNotifications ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-bell fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('notifications.unread') }}</p>
                            <h4 class="mb-0">{{ $unreadNotifications ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-envelope-open fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('notifications.read') }}</p>
                            <h4 class="mb-0">{{ $readNotifications ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row mt-4">
        <div class="col-lg-3">
            <!-- Notification Settings Panel -->
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('notifications.settings') }}</h4>
                    <div class="d-grid gap-2 mb-3">
                        <button class="btn btn-primary" id="markAllAsRead">
                            <i class="fas fa-check-double me-1"></i> {{ __('notifications.mark_all_read') }}
                        </button>
                        <button class="btn btn-outline-danger" id="clearAllNotifications">
                            <i class="fas fa-trash-alt me-1"></i> {{ __('notifications.clear_all') }}
                        </button>
                    </div>
                    <hr>
                    <h5 class="mb-3">{{ __('notifications.types') }}</h5>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="attendanceNotifications" checked>
                        <label class="form-check-label" for="attendanceNotifications">{{ __('notifications.attendance') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="systemNotifications" checked>
                        <label class="form-check-label" for="systemNotifications">{{ __('notifications.system') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="leaveNotifications" checked>
                        <label class="form-check-label" for="leaveNotifications">{{ __('notifications.leave') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="loanNotifications" checked>
                        <label class="form-check-label" for="loanNotifications">{{ __('notifications.loan') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="deductionNotifications" checked>
                        <label class="form-check-label" for="deductionNotifications">{{ __('notifications.deduction') }}</label>
                    </div>
                    <hr>
                    <h5 class="mb-3">{{ __('notifications.via_email') }} / {{ __('notifications.via_app') }} / {{ __('notifications.via_sms') }}</h5>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="emailNotifications" checked>
                        <label class="form-check-label" for="emailNotifications">{{ __('notifications.via_email') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="inAppNotifications" checked>
                        <label class="form-check-label" for="inAppNotifications">{{ __('notifications.via_app') }}</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" id="smsNotifications">
                        <label class="form-check-label" for="smsNotifications">{{ __('notifications.via_sms') }}</label>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-9">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">{{ __('notifications.list') }}</h4>
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                                <i class="fas fa-filter me-1"></i> {{ __('notifications.filter') }}
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#" data-filter="all">{{ __('notifications.all') }}</a>
                                <a class="dropdown-item" href="#" data-filter="unread">{{ __('notifications.unread') }}</a>
                                <a class="dropdown-item" href="#" data-filter="read">{{ __('notifications.read') }}</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" data-filter="leave">إجازات</a>
                                <a class="dropdown-item" href="#" data-filter="loan">قروض</a>
                                <a class="dropdown-item" href="#" data-filter="payroll">رواتب</a>
                                <a class="dropdown-item" href="#" data-filter="attendance">حضور</a>
                                <a class="dropdown-item" href="#" data-filter="system">نظام</a>
                            </div>
                        </div>
                    </div>

                    <!-- Search -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <input type="text" id="searchNotifications" class="form-control" placeholder="{{ __('notifications.search_placeholder') }}">
                        </div>
                        <div class="col-md-6">
                            <select id="dateFilter" class="form-control">
                                <option value="">{{ __('notifications.all') }}</option>
                                <option value="today">{{ __('notifications.today') }}</option>
                                <option value="this_week">{{ __('notifications.this_week') }}</option>
                                <option value="this_month">{{ __('notifications.this_month') }}</option>
                                <option value="last_7_days">{{ __('notifications.last_7_days') }}</option>
                                <option value="last_30_days">{{ __('notifications.last_30_days') }}</option>
                            </select>
                        </div>
                    </div>

                    <!-- Notifications Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('notifications.date') }}</th>
                                    <th>{{ __('notifications.description') }}</th>
                                    <th>{{ __('notifications.type') }}</th>
                                    <th>{{ __('notifications.user') }}</th>
                                    <th>{{ __('notifications.status_unread') }}/{{ __('notifications.status_read') }}</th>
                                    <th>{{ __('notifications.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($notifications as $notification)
                                <tr class="{{ $notification->read_at ? '' : 'table-warning' }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $notification->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        @php $d = $notification->data; @endphp
                                        <strong>
                                            @if(isset($d['title_key']))
                                                {{ __($d['title_key'], $d['title_params'] ?? []) }}
                                            @else
                                                {{ $d['title'] ?? __('notifications.activity_general') }}
                                            @endif
                                        </strong><br>
                                        @if(isset($d['message_key']))
                                            {{ Str::limit(__($d['message_key'], $d['message_params'] ?? []), 80) }}
                                        @else
                                            {{ Str::limit($d['message'] ?? __('notifications.activity_general'), 80) }}
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $typeLabels = [
                                                'leave' => __('notifications.leave'),
                                                'loan' => __('notifications.loan'),
                                                'payroll' => __('notifications.payroll'),
                                                'attendance' => __('notifications.attendance'),
                                                'system' => __('notifications.system')
                                            ];
                                        @endphp
                                        <span class="badge bg-soft-info" style="color: black; background-color: #e2e8f0;">{{ $typeLabels[$notification->data['type'] ?? 'system'] ?? 'نظام' }}</span>
                                    </td>
                                    <td>
                                        @if(isset($notification->data['sender']) && $notification->data['sender'] == 'system')
                                            <span style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-weight: bold;">
                                                نظام إدارة الموظفين والرواتب باي ماستر
                                            </span>
                                        @else
                                            {{ $notification->notifiable?->name ?? 'نظام' }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($notification->read_at)
                                            <span class="badge bg-success">{{ __('notifications.status_read') }}</span>
                                        @else
                                            <span class="badge bg-warning text-dark">{{ __('notifications.status_unread') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @if(!$notification->read_at)
                                                <button class="btn btn-sm btn-outline-primary mark-as-read" data-id="{{ $notification->id }}">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                            <a href="{{ $notification->data['url'] ?? '#' }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <button class="btn btn-sm btn-outline-danger delete-notification" data-id="{{ $notification->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">
                                        <i class="fas fa-bell-slash fa-3x mb-3"></i><br>
                                        {{ __('notifications.no_notifications') }}
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if(isset($notifications) && $notifications->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $notifications->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Notification Activities -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">أنشطة الإشعارات الأخيرة</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>النشاط</th>
                                    <th>المستخدم</th>
                                    <th>النوع</th>
                                    <th>الوصف</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentActivities ?? [] as $activity)
                                <tr>
                                    <td>
                                        @switch($activity->description)
                                            @case('created_leave_request')
                                                <span class="badge badge-primary" style="color: black; background-color: #e2e8f0;">طلب إجازة جديد</span>
                                                @break
                                            @case('approved_leave_request')
                                                <span class="badge badge-success" style="color: black; background-color: #e2e8f0;">موافقة على إجازة</span>
                                                @break
                                            @case('rejected_leave_request')
                                                <span class="badge badge-danger" style="color: black; background-color: #e2e8f0;">رفض إجازة</span>
                                                @break
                                            @case('created_loan_request')
                                                <span class="badge badge-primary" style="color: black; background-color: #e2e8f0;">طلب قرض جديد</span>
                                                @break
                                            @case('approved_loan_request')
                                                <span class="badge badge-success" style="color: black; background-color: #e2e8f0;">موافقة على قرض</span>
                                                @break
                                            @case('rejected_loan_request')
                                                <span class="badge badge-danger" style="color: black; background-color: #e2e8f0;">رفض قرض</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary" style="color: black; background-color: #e2e8f0;">نشاط عام</span>
                                        @endswitch
                                    </td>
                                    <td>{{ $activity->user?->name ?? 'نظام' }}</td>
                                    <td>
                                        @switch($activity->subject_type)
                                            @case('App\Models\Leave')
                                                <span class="badge badge-info" style="color: black; background-color: #e2e8f0;">إجازة</span>
                                                @break
                                            @case('App\Models\Loan')
                                                <span class="badge badge-info" style="color: black; background-color: #e2e8f0;">قرض</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary" style="color: black; background-color: #e2e8f0;">نظام</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        @if(isset($activity->properties['employee_name']))
                                            طلب من {{ $activity->properties['employee_name'] }}
                                        @elseif(isset($activity->properties['leave_type']))
                                            نوع الإجازة: {{ $activity->properties['leave_type'] }}
                                        @elseif(isset($activity->properties['loan_amount']))
                                            مبلغ القرض: {{ number_format($activity->properties['loan_amount'], 2) }} {{ $currency_name ?? 'د.ك' }}
                                        @else
                                            {{ $activity->description }}
                                        @endif
                                    </td>
                                    <td>{{ $activity->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted">لا توجد أنشطة حديثة.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Mark All As Read
        document.getElementById('markAllAsRead').addEventListener('click', function(e) {
            e.preventDefault();
            if (confirm('{{ addslashes(__('app.confirm_mark_all_notifications_read')) }}')) {
                fetch("{{ route('notifications.read-all') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload(); // إعادة تحميل الصفحة لعرض التحديث
                    }
                });
            }
        });

        // Clear All Notifications
        document.getElementById('clearAllNotifications').addEventListener('click', function(e) {
            e.preventDefault();
            if (confirm('{{ addslashes(__('app.confirm_clear_all_notifications')) }}')) {
                fetch("{{ route('notifications.clear-all') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload(); // إعادة تحميل الصفحة لعرض التحديث
                    }
                });
            }
        });

        // Mark Single Notification as Read
        document.querySelectorAll('.mark-as-read').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const notificationId = this.getAttribute('data-id');
                if (notificationId) {
                    fetch(`/notifications/${notificationId}/read`, {
                        method: 'PATCH',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // تحديث واجهة المستخدم مباشرة
                            const row = this.closest('tr');
                            row.classList.remove('table-warning');
                            row.querySelector('.badge.bg-warning')?.remove();
                            const badge = document.createElement('span');
                            badge.className = 'badge bg-success';
                            badge.textContent = 'مقروء';
                            row.querySelector('td:nth-child(6)').innerHTML = '';
                            row.querySelector('td:nth-child(6)').appendChild(badge);
                            this.remove(); // إزالة زر "تعليم كمقروء"
                        }
                    }).catch(error => {
                        console.error('Error updating notification status:', error);
                    });
                }
            });
        });

        // Delete Single Notification
        document.querySelectorAll('.delete-notification').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const notificationId = this.getAttribute('data-id');
                if (notificationId) {
                    if (confirm('{{ addslashes(__('app.confirm_delete_notification')) }}')) {
                        fetch(`/notifications/${notificationId}`, {
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                // إزالة الصف من جدول البيانات
                                this.closest('tr').remove();
                                // إذا لم يتبقى أي صفوف، أظهر رسالة "لا توجد إشعارات"
                                if (document.querySelector('tbody tr:not(.table-warning)') === null) {
                                    const tbody = document.querySelector('tbody');
                                    tbody.innerHTML = `
                                        <tr>
                                            <td colspan="7" class="text-center text-muted py-4">
                                                <i class="fas fa-bell-slash fa-3x mb-3"></i><br>
                                                لا توجد إشعارات حالياً.
                                            </td>
                                        </tr>
                                    `;
                                }
                            }
                        }).catch(error => {
                            console.error('Error deleting notification:', error);
                        });
                    }
                }
            });
        });

        // Filter Notifications (Example)
        document.querySelectorAll('.dropdown-menu a[data-filter]').forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();
                const filter = this.getAttribute('data-filter');
                console.log('Filtering by:', filter);
                // يمكنك هنا إرسال طلب AJAX أو استخدام JavaScript لتصفية الجدول
            });
        });

        // Search Notifications (Example)
        document.getElementById('searchNotifications').addEventListener('input', function(e) {
            const query = e.target.value.toLowerCase();
            document.querySelectorAll('tbody tr').forEach(row => {
                const text = row.innerText.toLowerCase();
                row.style.display = text.includes(query) ? 'table-row' : 'none';
            });
        });

        // Date Filter (Example)
        document.getElementById('dateFilter').addEventListener('change', function(e) {
            const filter = e.target.value;
            console.log('Date filtering by:', filter);
            // يمكنك هنا إرسال طلب AJAX أو استخدام JavaScript لتصفية الجدول حسب التاريخ
        });
    });
</script>
@endsection