@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('loans.show.title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('loans.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('loans.index') }}">{{ __('loans.breadcrumb_loans') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('loans.show.title') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">{{ __('loans.show.title') }} #{{ $loan->id }}</h4>
                            <p class="text-muted">{{ __('loans.show.requested_by', ['name' => $loan->employee->name ?? __('loans.not_specified')]) }}</p>
                        </div>
                        <div>
                            @if($loan->status == 'pending')
                                <span class="badge bg-warning text-dark fs-6">{{ __('loans.status.pending') }}</span>
                            @elseif($loan->status == 'approved')
                                <span class="badge bg-primary text-dark fs-6">{{ __('loans.status.approved') }}</span>
                            @elseif($loan->status == 'active')
                                <span class="badge bg-success text-dark fs-6">{{ __('loans.status.active') }}</span>
                            @elseif($loan->status == 'rejected')
                                <span class="badge bg-danger text-dark fs-6">{{ __('loans.status.rejected') }}</span>
                            @elseif($loan->status == 'paid')
                                <span class="badge bg-info text-dark fs-6">{{ __('loans.status.paid') }}</span>
                            @elseif($loan->status == 'cancelled')
                                <span class="badge bg-secondary text-dark fs-6">{{ __('loans.status.cancelled') }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">{{ __('loans.headings.loan_info') }}</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>{{ __('loans.form.label_type') }}</th>
                                    <td>
                                        @php
                                            $loanTypeKey = $loan->loan_type ?? 'unknown';
                                            $loanTypeClass = 'badge-soft-dark';
                                            // keep existing classes if you need specific colors
                                            $classes = [
                                                'personal' => 'badge-soft-primary',
                                                'housing' => 'badge-soft-success',
                                                'car' => 'badge-soft-warning',
                                                'emergency' => 'badge-soft-danger',
                                                'education' => 'badge-soft-info',
                                            ];
                                            if(isset($classes[$loanTypeKey])) $loanTypeClass = $classes[$loanTypeKey];
                                        @endphp
                                        <span class="badge {{ $loanTypeClass }}">{{ __('loans.type_labels.' . ($loanTypeKey ?: 'unknown')) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_amount') }}:</th>
                                    <td>{{ number_format($loan->amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_installments') }}:</th>
                                    <td>{{ $loan->installment_count ?? 0 }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_interest_rate') }}:</th>
                                    <td>{{ $loan->interest_rate ?? 0 }}%</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">{{ __('loans.headings.repayment') }}</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th>{{ __('loans.form.label_paid_amount') }}:</th>
                                    <td>{{ number_format($loan->paid_amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_remaining') }}:</th>
                                    <td class="text-{{ (($loan->remaining_amount ?? $loan->amount ?? 0) > 0) ? 'danger' : 'success' }}">
                                        {{ number_format($loan->remaining_amount ?? $loan->amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_installment_amount') }}:</th>
                                    <td>{{ number_format($loan->installment_amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.form.label_start_date') }}:</th>
                                    <td>{{ $loan->start_date ? $loan->start_date->format('Y-m-d') : __('loans.not_specified') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <div class="mb-4">
                        <h5 class="mb-3">{{ __('loans.headings.purpose') }}</h5>
                        <div class="alert alert-light border">
                            {{ $loan->reason ?? __('loans.not_specified') }}
                        </div>
                    </div>

                    @if($loan->notes)
                    <div class="mb-4">
                        <h5 class="mb-3">{{ __('loans.headings.additional_notes') }}</h5>
                        <div class="alert alert-info">
                            {{ $loan->notes }}
                        </div>
                    </div>
                    @endif

                    @if($loan->status == 'rejected' && $loan->rejection_reason)
                    <div class="mb-4">
                        <h5 class="mb-3">{{ __('loans.headings.rejection_reason') }}</h5>
                        <div class="alert alert-danger">
                            {{ $loan->rejection_reason }}
                        </div>
                    </div>
                    @endif

                    <div class="d-flex gap-2 flex-wrap">
                        @if($loan->status == 'pending')
                            @can('approve', $loan)
                            <form action="{{ route('loans.approve', $loan) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-success" onclick="return confirm('{{ __('loans.form.approve') }}?')">
                                    <i class="fas fa-check"></i> {{ __('loans.form.approve') }}
                                </button>
                            </form>
                            @endcan

                            @can('approve', $loan)
                            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                <i class="fas fa-times"></i> {{ __('loans.form.reject') }}
                            </button>
                            @endcan
                        @endif

                        @if($loan->status == 'approved')
                            @can('activate', $loan)
                            <form action="{{ route('loans.activate', $loan) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary" onclick="return confirm('{{ __('loans.form.activate') }}?')">
                                    <i class="fas fa-play"></i> {{ __('loans.form.activate') }}
                                </button>
                            </form>
                            @endcan
                        @endif

                        @if($loan->status == 'active')
                            @can('cancel', $loan)
                            <form action="{{ route('loans.cancel', $loan) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-warning" onclick="return confirm('{{ __('loans.form.cancel') }}?')">
                                    <i class="fas fa-ban"></i> {{ __('loans.form.cancel') }}
                                </button>
                            </form>
                            @endcan

                            @if(($loan->remaining_amount ?? $loan->amount ?? 0) > 0)
                                @can('pay', $loan)
                                <a href="#pay-installment" class="btn btn-success">
                                    <i class="fas fa-money-bill-wave"></i> {{ __('loans.form.pay_installment') }}
                                </a>
                                @endcan
                            @endif
                        @endif

                        @can('update', $loan)
                        @if(in_array($loan->status ?? '', ['pending', 'approved']))
                        <a href="{{ route('loans.edit', $loan) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> {{ __('loans.form.edit') }}
                        </a>
                        @endif
                        @endcan

                        <!-- print button -->
                        <button type="button" class="btn btn-primary" onclick="window.print();">
                            <i class="fas fa-print"></i> {{ __('loans.form.print') }}
                        </button>

                        <a href="{{ route('loans.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> {{ __('loans.form.back') }}
                        </a>
                    </div>
                </div>
            </div>

            <!-- Payment History -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-4">{{ __('loans.headings.payment_history') }}</h5>
                    @if($loan->installments && $loan->installments->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('loans.table.id') }}</th>
                                    <th>{{ __('loans.installment.number') }}</th>
                                    <th>{{ __('loans.installment.due_date') }}</th>
                                    <th>{{ __('loans.installment.paid_date') }}</th>
                                    <th>{{ __('loans.installment.amount') }}</th>
                                    <th>{{ __('loans.installment.payment_method') }}</th>
                                    <th>{{ __('loans.installment.status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($loan->installments as $installment)
                                <tr>
                                    <td>{{ $installment->id }}</td>
                                    <td>{{ $installment->installment_number }}</td>
                                    <td>{{ $installment->due_date ? $installment->due_date->format('Y-m-d') : __('loans.not_specified') }}</td>
                                    <td>{{ $installment->paid_date ? $installment->paid_date->format('Y-m-d') : __('loans.not_specified') }}</td>
                                    <td>{{ number_format($installment->amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                    <td>
                                        @switch($installment->payment_method ?? '')
                                            @case('cash') نقداً @break
                                            @case('bank_transfer') تحويل بنكي @break
                                            @case('check') شيك @break
                                            @case('deduction') {{ __('deductions.types.salary_deduction') }} @break
                                            @default {{ $installment->payment_method ?? __('loans.not_specified') }}
                                        @endswitch
                                    </td>
                                    <td>
                                        @if(($installment->status ?? '') == 'paid')
                                            <span class="badge bg-success">{{ __('loans.installment_status.paid') }}</span>
                                        @elseif(($installment->status ?? '') == 'pending')
                                            <span class="badge bg-warning">{{ __('loans.installment_status.pending') }}</span>
                                        @else
                                            <span class="badge bg-secondary">{{ __('loans.installment_status.overdue') }}</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center py-4">
                        <i class="fas fa-receipt fa-2x text-muted mb-2"></i>
                        <p class="text-muted">{{ __('loans.empty.payment_history') }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    @if(isset($loan->employee) && $loan->employee->photo)
                        <img src="{{ asset('storage/' . $loan->employee->photo) }}" alt="صورة الموظف" class="img-fluid rounded-circle mb-3" width="120">
                    @else
                        <div class="avatar-lg mx-auto mb-3">
                            <span class="avatar-title bg-primary text-white rounded-circle">
                                {{ isset($loan->employee) ? substr($loan->employee->name ?? '', 0, 1) : '?' }}
                            </span>
                        </div>
                    @endif
                    <h4>{{ optional($loan->employee)->name ?? __('loans.not_specified') }}</h4>
                    <p class="text-muted">{{ optional(optional($loan->employee)->position)->name ?? __('loans.not_specified') }}</p>
                    <p class="text-muted">{{ optional(optional($loan->employee)->department)->name ?? __('loans.not_specified') }}</p>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <h5>{{ optional($loan->employee)->annual_salary ?? 0 }} {{ get_currency_code() }}</h5>
                            <p class="text-muted mb-0">{{ __('loans.sidebar.annual_salary') }}</p>
                        </div>
                        <div class="col-6">
                            <h5>{{ $loan->employee ? $loan->employee->loans->where('status', 'active')->count() : 0 }}</h5>
                            <p class="text-muted mb-0">{{ __('loans.sidebar.active_loans') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Loan Progress -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">{{ __('loans.sidebar.repayment_progress') }}</h5>
                    <div class="text-center mb-3">
                        @php
                            $progress = ($loan->total_amount > 0) ? ($loan->paid_amount / $loan->total_amount) * 100 : 0;
                        @endphp
                        <h2 class="mb-1">{{ number_format($progress, 1) }}%</h2>
                        <p class="text-muted">{{ __('loans.sidebar.paid') }}</p>
                    </div>
                    <div class="progress mb-3">
                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $progress }}%"></div>
                    </div>
                    <div class="row text-center">
                        <div class="col-6">
                            <small class="text-muted">{{ __('loans.sidebar.paid') }}</small>
                            <h6 class="mt-1">{{ number_format($loan->paid_amount ?? 0, 2) }} {{ get_currency_code() }}</h6>
                        </div>
                        <div class="col-6">
                            <small class="text-muted">{{ __('loans.sidebar.remaining') }}</small>
                            <h6 class="mt-1">{{ number_format($loan->remaining_amount ?? $loan->amount ?? 0, 2) }} {{ get_currency_code() }}</h6>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Loan Summary -->
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title mb-3">{{ __('loans.page_title') }}</h5>
                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <tr>
                                <th>{{ __('loans.preview.principal') }}:</th>
                                <td class="text-end">{{ number_format($loan->amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.preview.interest') }}:</th>
                                    <td class="text-end">{{ number_format($loan->interest_amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.preview.total') }}:</th>
                                    <td class="text-end fw-bold">{{ number_format($loan->total_amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('loans.preview.monthly') }}:</th>
                                    <td class="text-end">{{ number_format($loan->installment_amount ?? 0, 2) }} {{ get_currency_code() }}</td>
                                </tr>
                            <tr>
                                <th>{{ __('loans.summary.installments_paid') }}:</th>
                                <td class="text-end">
                                    {{ $loan->installments ? $loan->installments->where('status', 'paid')->count() : 0 }} 
                                    من {{ $loan->installment_count ?? 0 }}
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
@if($loan->status == 'pending')
@can('approve', $loan)
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('loans.modal.reject_title') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('loans.reject', $loan) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="rejection_reason" class="form-label">{{ __('loans.modal.reject_reason_label') }} <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="rejection_reason" name="rejection_reason" rows="3" placeholder="{{ __('loans.modal.reject_reason_label') }}" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('loans.modal.cancel') }}</button>
                    <button type="submit" class="btn btn-danger">{{ __('loans.modal.confirm_reject') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endcan
@endif

<!-- Pay Installment Section -->
@if($loan->status == 'active' && ($loan->remaining_amount ?? $loan->amount ?? 0) > 0)
@can('pay', $loan)
<div class="row mt-4" id="pay-installment">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">{{ __('loans.form.pay_installment') }}</h5>
                <!-- ✅ تغيير: إضافة div لعرض رسالة إذا لم يكن هناك أقساط قابلة للدفع -->
                @if($loan->installments->where('status', 'pending')->isEmpty())
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        لا توجد أقساط قابلة للدفع حالياً. جميع الأقساط إما مدفوعة أو تم إلغاؤها.
                    </div>
                @else
                    <form action="{{ route('loans.pay-installment', $loan) }}" method="POST">
                        @csrf
                        <div class="row">
                            <!-- ✅ قائمة منسدلة لاختيار القسط -->
                            <div class="col-md-6 mb-3">
                                <label for="installment_id" class="form-label">{{ __('loans.form_extra.select_installment') }} <span class="text-danger">*</span></label>
                                <select class="form-control" id="installment_id" name="installment_id" required>
                                    <option value="">{{ __('loans.form_extra.select_installment') }}...</option>
                                    @foreach($loan->installments->where('status', 'pending') as $inst)
                                        <option value="{{ $inst->id }}">
                                            القسط #{{ $inst->installment_number }} - 
                                            {{ number_format($inst->amount ?? 0, 2) }} {{ get_currency_code() }} - 
                                            مستحق في {{ $inst->due_date->format('Y-m-d') }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="payment_date" class="form-label">{{ __('loans.form_extra.payment_date') }}</label>
                                <input type="date" class="form-control" id="payment_date" name="payment_date" 
                                       value="{{ date('Y-m-d') }}" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="payment_method" class="form-label">{{ __('loans.installment.payment_method') }}</label>
                                <select class="form-control" id="payment_method" name="payment_method" required>
                                    <option value="">{{ __('loans.installment.payment_method') }}</option>
                                    <option value="cash">نقداً</option>
                                    <option value="bank_transfer">تحويل بنكي</option>
                                    <option value="check">شيك</option>
                                    <option value="deduction">{{ __('deductions.types.salary_deduction') }}</option>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="notes" class="form-label">{{ __('loans.form.label_notes') }}</label>
                                <textarea class="form-control" id="notes" name="notes" rows="2"></textarea>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">{{ __('loans.form.pay_installment') }}</button>
                    </form>
                @endif
            </div>
        </div>
    </div>
</div>
@endcan
@endif
@endsection