<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>سجل قروض {{ $employee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-section { margin-bottom: 15px; }
        .info-section h3 { border-bottom: 1px solid #ccc; padding-bottom: 3px; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table td { border: 1px solid #ccc; padding: 5px; vertical-align: top; }
        .info-table th { background-color: #f2f2f2; border: 1px solid #ccc; padding: 5px; text-align: right; }
        .loan-row { font-size: 0.9em; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 0.8em; }
        .badge-success { background-color: #d4edda; color: #155724; }
        .badge-warning { background-color: #fff3cd; color: #856404; }
        .badge-danger { background-color: #f8d7da; color: #721c24; }
        .badge-info { background-color: #d1ecf1; color: #0c5460; }
        .badge-secondary { background-color: #d6d8db; color: #383d41; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }
        .text-warning { color: #ffc107; }
        /* أضف CSS إضافي للطباعة */
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>سجل قروض الموظف: {{ $employee->name }}</h2>
        <h3>رقم الموظف: {{ $employee->employee_id }}</h3>
    </div>

    <div class="info-section">
        <h3>تفاصيل القروض (من {{ $loans->last()?->created_at->format('Y-m-d') ?? 'N/A' }} إلى {{ $loans->first()?->created_at->format('Y-m-d') ?? 'N/A' }})</h3>
        <table class="info-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الرقم</th>
                    <th>النوع</th>
                    <th>العنوان</th>
                    <th>المبلغ</th>
                    <th>الفائدة (%)</th>
                    <th>إجمالي المبلغ</th>
                    <th>عدد الأقساط</th>
                    <th>القسط الشهري</th>
                    <th>من</th>
                    <th>إلى</th>
                    <th>الحالة</th>
                    <th>الغرض</th>
                </tr>
            </thead>
            <tbody>
                @forelse($loans as $loan)
                <tr class="loan-row">
                    <td>{{ $loan->id }}</td>
                    <td>{{ $loan->loan_number }}</td>
                    <td>
                        @switch($loan->loan_type)
                            @case('personal') <span class="status-badge badge-info">شخصي</span> @break
                            @case('housing') <span class="status-badge badge-success">سكن</span> @break
                            @case('car') <span class="status-badge badge-warning">سيارة</span> @break
                            @case('emergency') <span class="status-badge badge-danger">طارئ</span> @break
                            @case('education') <span class="status-badge badge-primary">تعليمي</span> @break
                            @default <span class="status-badge badge-dark">{{ $loan->loan_type }}</span>
                        @endswitch
                    </td>
                    <td>{{ $loan->title }}</td>
                    <td>{{ number_format($loan->amount, 2) }} {{ get_currency_code() }}</td>
                    <td>{{ number_format($loan->interest_rate, 2) }}%</td>
                    <td>{{ number_format($loan->total_amount, 2) }} {{ get_currency_code() }}</td>
                    <td>{{ $loan->installment_count }}</td>
                    <td>{{ number_format($loan->installment_amount, 2) }} {{ get_currency_code() }}</td>
                    <td>{{ $loan->start_date->format('Y-m-d') }}</td>
                    <td>{{ $loan->end_date->format('Y-m-d') }}</td>
                    <td>
                        @php
                            $loanStatusClasses = [
                                'pending' => 'badge-warning',
                                'approved' => 'badge-info',
                                'active' => 'badge-success',
                                'paid' => 'badge-secondary',
                                'rejected' => 'badge-danger',
                                'cancelled' => 'badge-dark',
                            ];
                            $loanStatusLabels = [
                                'pending' => 'معلق',
                                'approved' => 'موافق عليه',
                                'active' => 'نشط',
                                'paid' => 'مدفوع',
                                'rejected' => 'مرفوض',
                                'cancelled' => 'ملغى',
                            ];
                            $loanBadgeClass = $loanStatusClasses[$loan->status] ?? 'bg-dark';
                            $loanBadgeLabel = $loanStatusLabels[$loan->status] ?? $loan->status;
                        @endphp
                        <span class="status-badge {{ $loanBadgeClass }}">{{ $loanBadgeLabel }}</span>
                    </td>
                    <td>{{ Str::limit($loan->reason, 50) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="13" class="text-center py-3">لا توجد سجلات قروض خلال هذه الفترة.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <script>
        // طباعة الصفحة مباشرة عند التحميل
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>