@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('loans.page_title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('loans.breadcrumb_home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('loans.breadcrumb_loans') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row">
        <!-- إجمالي القروض -->
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.cards.total_loans') }}</p>
                            <h4 class="mb-0">{{ $totalLoans ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-credit-card fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- القروض النشطة -->
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.cards.active') }}</p>
                            <h4 class="mb-0">{{ $activeLoans ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-check-circle fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- القروض قيد المراجعة -->
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.cards.pending') }}</p>
                            <h4 class="mb-0">{{ $pendingLoans ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-clock fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- القروض المدفوعة بالكامل -->
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.cards.paid') }}</p>
                            <h4 class="mb-0">{{ $paidLoans ?? 0 }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-money-check fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- New Stats Cards for Payments -->
    <div class="row mt-3">
        <!-- إجمالي الأموال المدفوعة هذا الشهر -->
        <div class="col-md-3">
            <div class="card bg-secondary text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.stats.payments_this_month') }}</p>
                            <h4 class="mb-0">{{ number_format($totalPaymentsThisMonth ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-coins fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- إجمالي الأموال المدفوعة هذه السنة -->
        <div class="col-md-3">
            <div class="card bg-dark text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.stats.payments_this_year') }}</p>
                            <h4 class="mb-0">{{ number_format($totalPaymentsThisYear ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-wallet fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- إجمالي الأقساط المخصومة هذا الشهر -->
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.stats.deductions_this_month') }}</p>
                            <h4 class="mb-0">{{ number_format($totalDeductionsThisMonth ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-file-invoice-dollar fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- إجمالي الأقساط المخصومة هذه السنة -->
        <div class="col-md-3">
            <div class="card bg-purple text-white"> <!-- Assuming you have a purple class or define it in CSS -->
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-grow-1">
                            <p class="text-truncate font-size-14 mb-2">{{ __('loans.stats.deductions_this_year') }}</p>
                            <h4 class="mb-0">{{ number_format($totalDeductionsThisYear ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</h4>
                        </div>
                        <div class="avatar-sm">
                            <span class="avatar-title bg-transparent rounded">
                                <i class="fas fa-receipt fa-2x"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title">{{ __('loans.page_title') }}</h4>
                        @can('create', \App\Models\Loan::class)
                        <a href="{{ route('loans.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> {{ __('loans.buttons.create') }}
                        </a>
                        @endcan
                    </div>

                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="{{ __('loans.filters.search_placeholder') }}">
                        </div>
                        <div class="col-md-2">
                            <select id="employeeFilter" class="form-control">
                                <option value="">{{ __('loans.filters.all_employees') }}</option>
                                @if(isset($employees) && $employees->isNotEmpty())
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">{{ __('loans.filters.all_statuses') }}</option>
                                <option value="pending">{{ __('loans.status.pending') }}</option>
                                <option value="approved">{{ __('loans.status.approved') }}</option>
                                <option value="active">{{ __('loans.status.active') }}</option>
                                <option value="rejected">{{ __('loans.status.rejected') }}</option>
                                <option value="paid">{{ __('loans.status.paid') }}</option>
                                <option value="cancelled">{{ __('loans.status.cancelled') }}</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="typeFilter" class="form-control">
                                <option value="">{{ __('loans.filters.all_types') }}</option>
                                <option value="personal">{{ __('loans.types.personal') }}</option>
                                <option value="housing">{{ __('loans.types.housing') }}</option>
                                <option value="car">{{ __('loans.types.car') }}</option>
                                <option value="emergency">{{ __('loans.types.emergency') }}</option>
                                <option value="education">{{ __('loans.types.education') }}</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <button id="resetFilters" class="btn btn-secondary">
                                <i class="fas fa-redo"></i> {{ __('loans.buttons.reset_filters') }}
                            </button>
                        </div>
                    </div>

                    <!-- Loans Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap table-hover" id="loansTable">
                            <thead class="thead-light">
                                <tr>
                                    <th>{{ __('loans.table.id') }}</th>
                                    <th>{{ __('loans.table.employee_name') }}</th>
                                    <th>{{ __('loans.table.type') }}</th>
                                    <th>{{ __('loans.table.amount_requested') }}</th>
                                    <th>{{ __('loans.table.amount_paid') }}</th>
                                    <th>{{ __('loans.table.remaining') }}</th>
                                    <th>{{ __('loans.table.installments_count') }}</th>
                                    <th>{{ __('loans.table.installment_amount') }}</th>
                                    <th>{{ __('loans.table.request_date') }}</th>
                                    <th>{{ __('loans.table.status') }}</th>
                                    <th>{{ __('loans.table.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans ?? [] as $loan)
                                <tr>
                                    <td>{{ $loan->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if(isset($loan->employee) && $loan->employee->photo)
                                                <img src="{{ asset('storage/' . $loan->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-2" width="32" height="32">
                                            @else
                                                <div class="avatar-sm me-2">
                                                    <span class="avatar-title bg-primary text-white rounded-circle">
                                                        {{ isset($loan->employee) ? substr($loan->employee->name ?? '', 0, 1) : '?' }}
                                                    </span>
                                                </div>
                                            @endif
                                            <div>
                                                <h5 class="font-size-14 mb-0">{{ $loan->employee->name ?? __('loans.not_specified') }}</h5>
                                                <!-- ✅ تم إزالة السطر الذي يعرض الوظيفة (position) -->
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <!-- ✅ تعديل: استخدام فئة مخصصة لجعل النص أسود -->
                                            @switch($loan->loan_type ?? '')
                                            @case('personal')
                                                <span class="badge badge-soft-personal">{{ __('loans.type_labels.personal') }}</span>
                                                @break
                                            @case('housing')
                                                <span class="badge badge-soft-housing">{{ __('loans.type_labels.housing') }}</span>
                                                @break
                                            @case('car')
                                                <span class="badge badge-soft-car">{{ __('loans.type_labels.car') }}</span>
                                                @break
                                            @case('emergency')
                                                <span class="badge badge-soft-emergency">{{ __('loans.type_labels.emergency') }}</span>
                                                @break
                                            @case('education')
                                                <span class="badge badge-soft-education">{{ __('loans.type_labels.education') }}</span>
                                                @break
                                            @default
                                                <span class="badge badge-soft-dark">{{ $loan->loan_type ? __('loans.type_labels.' . $loan->loan_type) : __('loans.not_specified') }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ number_format($loan->amount ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</td>
                                    <td>{{ number_format($loan->paid_amount ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</td>
                                    <td>
                                        <span class="text-{{ (($loan->remaining_amount ?? $loan->amount ?? 0) > 0) ? 'danger' : 'success' }}">
                                            {{ number_format($loan->remaining_amount ?? $loan->amount ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}
                                        </span>
                                    </td>
                                    <td>{{ $loan->installment_count ?? 0 }}</td>
                                    <!-- ✅ تم تعديل هذا السطر -->
                                    <td>{{ number_format($loan->installment_amount ?? 0, 2) }} {{ $currency_name ?? 'د.ك' }}</td>
                                    <td>{{ $loan->created_at ? $loan->created_at->format('Y-m-d') : __('loans.not_specified') }}</td>
                                    <td>
                                        @if(($loan->status ?? '') == 'pending')
                                            <span class="badge bg-warning text-dark">{{ __('loans.status.pending') }}</span>
                                        @elseif(($loan->status ?? '') == 'approved')
                                            <span class="badge bg-primary text-dark">{{ __('loans.status.approved') }}</span>
                                        @elseif(($loan->status ?? '') == 'active')
                                            <span class="badge bg-success text-dark">{{ __('loans.status.active') }}</span>
                                        @elseif(($loan->status ?? '') == 'rejected')
                                            <span class="badge bg-danger text-dark">{{ __('loans.status.rejected') }}</span>
                                        @elseif(($loan->status ?? '') == 'paid')
                                            <span class="badge bg-info text-dark">{{ __('loans.status.paid') }}</span>
                                        @elseif(($loan->status ?? '') == 'cancelled')
                                            <span class="badge bg-secondary text-dark">{{ __('loans.status.cancelled') }}</span>
                                        @else
                                            <span class="badge bg-dark text-dark">{{ __('loans.status.unknown') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view', $loan)
                                            <a href="{{ route('loans.show', $loan) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @if(($loan->status ?? '') == 'pending')
                                                @can('approve', $loan)
                                                <form action="{{ route('loans.approve', $loan) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-sm" title="{{ __('app.approval') }}" onclick="return confirm('{{ addslashes(__('app.confirm_approve_loan')) }}')">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                                @endcan

                                                @can('approve', $loan)
                                                <button type="button" class="btn btn-danger btn-sm" title="رفض" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $loan->id }}">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                                @endcan
                                            @endif

                                            @if(($loan->status ?? '') == 'approved')
                                                @can('activate', $loan)
                                                <form action="{{ route('loans.activate', $loan) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-primary btn-sm" title="{{ __('app.active') }}" onclick="return confirm('{{ addslashes(__('app.confirm_activate_loan')) }}')">
                                                        <i class="fas fa-play"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif

                                            <!-- ✅ تم تعديل هذا القسم -->
                                            @if(in_array($loan->status ?? '', ['active', 'approved']))
                                                @can('cancel', $loan)
                                                <form action="{{ route('loans.cancel', $loan) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-warning btn-sm" title="{{ __('app.cancel') }}" onclick="return confirm('{{ addslashes(__('app.confirm_cancel_loan')) }}')">
                                                        <i class="fas fa-ban"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif

                                            @can('update', $loan)
                                            @if(in_array($loan->status ?? '', ['pending', 'approved']))
                                            <a href="{{ route('loans.edit', $loan) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endif
                                            @endcan

                                            @can('delete', $loan)
                                            @if(in_array($loan->status ?? '', ['pending', 'rejected', 'cancelled']))
                                            <form action="{{ route('loans.destroy', $loan) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="{{ __('app.delete') }}" onclick="return confirm('{{ addslashes(__('app.confirm_delete_loan')) }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                            @endcan

                                            @if(($loan->status ?? '') == 'active' && ($loan->remaining_amount ?? $loan->amount ?? 0) > 0)
                                                @can('pay', $loan)
                                                <a href="{{ route('loans.show', $loan) }}#pay-installment" class="btn btn-success btn-sm" title="دفع قسط">
                                                    <i class="fas fa-money-bill-wave"></i>
                                                </a>
                                                @endcan
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                        <td colspan="11" class="text-center">
                                        <i class="fas fa-credit-card fa-3x mb-3"></i>
                                        <h5>{{ __('loans.empty.title') }}</h5>
                                        <p class="text-muted">{{ __('loans.empty.subtitle') }}</p>
                                        @can('create', \App\Models\Loan::class)
                                        <a href="{{ route('loans.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> {{ __('loans.buttons.create') }}
                                        </a>
                                        @endcan
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($loans) && $loans->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $loans->links() }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats and Charts -->
    <div class="row mt-4">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">توزيع القروض حسب النوع</h4>
                    <canvas id="loanTypesChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">حالة القروض</h4>
                    <canvas id="loanStatusChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Loan Activities -->
    {{-- 
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">الأنشطة الأخيرة للقروض</h4>
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap">
                            <thead class="thead-light">
                                <tr>
                                    <th>النشاط</th>
                                    <th>الموظف</th>
                                    <th>نوع القرض</th>
                                    <th>المبلغ</th>
                                    <th>الحالة</th>
                                    <th>التاريخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><span class="badge badge-primary">طلب قرض جديد</span></td>
                                    <td>أحمد محمد</td>
                                    <td>شخصي</td>
                                    <td>1000.00 {{ $currency_name ?? 'د.ك' }}</td>
                                    <td><span class="badge bg-warning text-dark">قيد المراجعة</span></td> <!-- ✅ تم تغيير لون النص إلى أسود -->
                                    <td>2025-08-23</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-success">موافقة على قرض</span></td>
                                    <td>مدير المالية</td>
                                    <td>سكن</td>
                                    <td>5000.00 {{ $currency_name ?? 'د.ك' }}</td>
                                    <td><span class="badge bg-primary text-dark">موافق عليه</span></td> <!-- ✅ تم تغيير لون النص إلى أسود -->
                                    <td>2025-08-22</td>
                                </tr>
                                <tr>
                                    <td><span class="badge badge-info">دفع قسط</span></td>
                                    <td>سارة علي</td>
                                    <td>سيارة</td>
                                    <td>200.00 {{ $currency_name ?? 'د.ك' }}</td>
                                    <td><span class="badge bg-success text-dark">مدفوع</span></td> <!-- ✅ تم تغيير لون النص إلى أسود -->
                                    <td>2025-08-21</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    --}}
</div>

<!-- Reject Modals -->
@foreach($loans ?? [] as $loan)
@if(($loan->status ?? '') == 'pending')
@can('approve', $loan)
<div class="modal fade" id="rejectModal{{ $loan->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">رفض طلب القرض</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('loans.reject', $loan) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="rejection_reason_{{ $loan->id }}" class="form-label">سبب الرفض <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="rejection_reason_{{ $loan->id }}" name="rejection_reason" rows="3" placeholder="يرجى كتابة سبب الرفض" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">رفض الطلب</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endcan
@endif
@endforeach

<!-- Chart Scripts -->
<script src="https://cdn.jsdelivr.net/npm/chart.js  "></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Loan Types Chart
    var ctx1 = document.getElementById('loanTypesChart').getContext('2d');
    var loanTypesChart = new Chart(ctx1, {
        type: 'doughnut',
        data: {
            labels: ['شخصي', 'سكن', 'سيارة', 'طارئ', 'تعليم'],
            datasets: [{
                data: [30, 25, 20, 15, 10],
                backgroundColor: [
                    '#4361ee',
                    '#3a0ca3',
                    '#4cc9f0',
                    '#f72585',
                    '#7209b7'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Loan Status Chart
    var ctx2 = document.getElementById('loanStatusChart').getContext('2d');
    var loanStatusChart = new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: ['قيد المراجعة', 'موافق عليه', 'نشط', 'مرفوض', 'مدفوع'],
            datasets: [{
                label: 'عدد القروض',
                data: [5, 8, 12, 2, 7],
                backgroundColor: [
                    '#f7b84b',
                    '#4361ee',
                    '#20bf6b',
                    '#f06595',
                    '#4cc9f0'
                ]
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Search and Filter Functionality
    const searchInput = document.getElementById('searchInput');
    const employeeFilter = document.getElementById('employeeFilter');
    const statusFilter = document.getElementById('statusFilter');
    const typeFilter = document.getElementById('typeFilter');
    const resetFilters = document.getElementById('resetFilters');

    function filterTable() {
        // Implementation for filtering table rows
        console.log('Filtering loans table...');
    }

    if (searchInput) searchInput.addEventListener('keyup', filterTable);
    if (employeeFilter) employeeFilter.addEventListener('change', filterTable);
    if (statusFilter) statusFilter.addEventListener('change', filterTable);
    if (typeFilter) typeFilter.addEventListener('change', filterTable);
    if (resetFilters) resetFilters.addEventListener('click', function() {
        if (searchInput) searchInput.value = '';
        if (employeeFilter) employeeFilter.value = '';
        if (statusFilter) statusFilter.value = '';
        if (typeFilter) typeFilter.value = '';
        filterTable();
    });
});
</script>

<style>
/* Add a custom purple class if needed */
.bg-purple {
    background-color: #6f42c1 !important; /* Bootstrap's purple */
}
.text-purple {
    color: #6f42c1 !important;
}

/* ✅ تعريف أنماط مخصصة لجعل نص نوع القرض باللون الأسود */
.badge.badge-soft-personal,
.badge.badge-soft-housing,
.badge.badge-soft-car,
.badge.badge-soft-emergency,
.badge.badge-soft-education,
.badge.badge-soft-dark {
    color: #000000 !important; /* فرض لون النص الأسود */
    background-color: rgba(0, 0, 0, 0.1) !important; /* خلفية شبه شفافة */
    border: 1px solid rgba(0, 0, 0, 0.2) !important; /* حد أسود خفيف (اختياري) */
}

/* يمكنك أيضًا تعريف ألوان مخصصة لكل نوع إذا أردت */
/*
.badge.badge-soft-personal {
    background-color: #cce5ff !important; /* مثلاً زرقاء فاتحة */
    color: #000000 !important;
}
*/
</style>
@endsection