@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">تعديل طلب القرض</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('loans.index') }}">القروض</a></li>
                        <li class="breadcrumb-item active">تعديل الطلب</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">نموذج تعديل القرض</h4>

                    <form action="{{ route('loans.update', $loan) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">اسم الموظف</label>
                                <input type="text" class="form-control" value="{{ $loan->employee->name }}" readonly>
                                <input type="hidden" name="employee_id" value="{{ $loan->employee_id }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="loan_type" class="form-label">نوع القرض <span class="text-danger">*</span></label>
                                <select class="form-control" id="loan_type" name="loan_type" required {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>
                                    <option value="">اختر نوع القرض</option>
                                    <option value="personal" {{ old('loan_type', $loan->loan_type) == 'personal' ? 'selected' : '' }}>شخصي</option>
                                    <option value="housing" {{ old('loan_type', $loan->loan_type) == 'housing' ? 'selected' : '' }}>سكن</option>
                                    <option value="car" {{ old('loan_type', $loan->loan_type) == 'car' ? 'selected' : '' }}>سيارة</option>
                                    <option value="emergency" {{ old('loan_type', $loan->loan_type) == 'emergency' ? 'selected' : '' }}>طارئ</option>
                                    <option value="education" {{ old('loan_type', $loan->loan_type) == 'education' ? 'selected' : '' }}>تعليم</option>
                                </select>
                                @error('loan_type')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="amount" class="form-label">المبلغ المطلوب <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="amount" name="amount" value="{{ old('amount', $loan->amount) }}" step="0.01" min="1" required {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>
                                    <span class="input-group-text">{{ $currency_name ?? 'د.ك' }}</span> <!-- ✅ تم التعديل -->
                                </div>
                                @error('amount')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="installment_count" class="form-label">عدد الأقساط <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="installment_count" name="installment_count" value="{{ old('installment_count', $loan->installment_count) }}" min="1" max="120" required {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>
                                @error('installment_count')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="interest_rate" class="form-label">نسبة الفائدة (%)</label>
                                <input type="number" class="form-control" id="interest_rate" name="interest_rate" value="{{ old('interest_rate', $loan->interest_rate) }}" step="0.01" min="0" max="100" {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>
                                @error('interest_rate')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="start_date" class="form-label">تاريخ بدء السداد <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $loan->start_date->format('Y-m-d')) }}" required {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>
                                @error('start_date')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="reason" class="form-label">الغرض من القرض <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="reason" name="reason" rows="3" placeholder="يرجى كتابة الغرض من القرض بالتفصيل" required {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>{{ old('reason', $loan->reason) }}</textarea>
                            @error('reason')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="notes" class="form-label">ملاحظات إضافية</label>
                            <textarea class="form-control" id="notes" name="notes" rows="2" placeholder="أي ملاحظات إضافية" {{ in_array($loan->status, ['approved', 'active', 'paid']) ? 'disabled' : '' }}>{{ old('notes', $loan->notes) }}</textarea>
                            @error('notes')
                                <div class="text-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        @if(in_array($loan->status, ['pending', 'approved']))
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> تحديث الطلب
                            </button>
                            <a href="{{ route('loans.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> رجوع
                            </a>
                        </div>
                        @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> لا يمكن تعديل الطلب لأن حالته "{{ $loan->status == 'active' ? 'نشط' : ($loan->status == 'paid' ? 'مدفوع بالكامل' : ($loan->status == 'rejected' ? 'مرفوض' : 'ملغى')) }}"
                        </div>
                        <a href="{{ route('loans.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> رجوع
                        </a>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Employee Info Card -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات الموظف</h5>
                    <div class="d-flex align-items-center mb-3">
                        @if($loan->employee->photo)
                            <img src="{{ asset('storage/' . $loan->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-primary text-white rounded-circle">
                                    {{ substr($loan->employee->name, 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $loan->employee->name }}</h6>
                            <p class="mb-0 text-muted">{{ $loan->employee->position?->name ?? 'غير محدد' }}</p>
                                <p class="mb-0 text-muted">{{ $loan->employee->department?->name ?? __('loans.not_specified') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">تفاصيل الطلب</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>حالة الطلب:</th>
                            <td>
                                @if($loan->status == 'pending')
                                    <span class="badge badge-warning">قيد المراجعة</span>
                                @elseif($loan->status == 'approved')
                                    <span class="badge badge-primary">موافق عليه</span>
                                @elseif($loan->status == 'active')
                                    <span class="badge badge-success">نشط</span>
                                @elseif($loan->status == 'rejected')
                                    <span class="badge badge-danger">مرفوض</span>
                                @elseif($loan->status == 'paid')
                                    <span class="badge badge-info">مدفوع بالكامل</span>
                                @elseif($loan->status == 'cancelled')
                                    <span class="badge badge-secondary">ملغى</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>تاريخ الطلب:</th>
                            <td>{{ $loan->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        @if($loan->status != 'pending')
                        <tr>
                            <th>تاريخ {{ $loan->status == 'approved' ? 'الموافقة' : ($loan->status == 'active' ? 'التفعيل' : ($loan->status == 'rejected' ? 'الرفض' : ($loan->status == 'paid' ? 'السداد الكامل' : 'الإلغاء'))) }}:</th>
                            <td>{{ $loan->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Loan Details -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">تفاصيل القرض</h5>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h4 class="mb-1">{{ number_format($loan->amount, 2) }} {{ $currency_name ?? 'د.ك' }}</h4> <!-- ✅ تم التعديل -->
                                <p class="mb-0 text-muted">المبلغ الأساسي</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h4 class="mb-1">{{ number_format($loan->interest_amount, 2) ?? '0.00' }} {{ $currency_name ?? 'د.ك' }}</h4> <!-- ✅ تم التعديل -->
                                <p class="mb-0 text-muted">الفائدة</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h4 class="mb-1">{{ number_format($loan->total_amount, 2) }} {{ $currency_name ?? 'د.ك' }}</h4> <!-- ✅ تم التعديل -->
                                <p class="mb-0 text-muted">المبلغ الإجمالي</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center p-3 bg-light rounded">
                                <h4 class="mb-1">{{ number_format($loan->monthly_installment, 2) }} {{ $currency_name ?? 'د.ك' }}</h4> <!-- ✅ تم التعديل -->
                                <p class="mb-0 text-muted">القسط الشهري</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection