@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('leaves.show.title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('leaves.breadcrumb.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('leaves.index') }}">{{ __('leaves.breadcrumb.leaves') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('leaves.show.breadcrumb') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- 🟩 القسم الرئيسي -->
        <div class="col-md-8">
            <!-- 🟢 تفاصيل الطلب -->
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <div>
                            <h4 class="card-title">{{ __('leaves.show.request', ['id' => $leave->id]) }}</h4>
                            <p class="text-muted mb-0">
                                {{ __('leaves.show.submitted_by') }} {{ $leave->employee?->name ?? __('leaves.unknown_employee') }}
                            </p>
                        </div>
                        @php
                            $statusClasses = [
                                'pending' => 'bg-warning',
                                'approved' => 'bg-success',
                                'rejected' => 'bg-danger',
                                'cancelled' => 'bg-secondary',
                                'modified' => 'bg-info',
                            ];
                            $statusLabels = [
                                'pending' => __('leaves.status.pending'),
                                'approved' => __('leaves.status.approved'),
                                'rejected' => __('leaves.status.rejected'),
                                'cancelled' => __('leaves.status.cancelled'),
                                'modified' => __('leaves.status.modified'),
                            ];
                        @endphp
                        <span class="badge {{ $statusClasses[$leave->status] ?? 'bg-dark' }} text-white fs-6">
                            {{ $statusLabels[$leave->status] ?? $leave->status }}
                        </span>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">{{ __('leaves.show.leave_info') }}</h5>
                            <table class="table table-borderless mb-0">
                                <tr>
                                    <th>{{ __('leaves.fields.type') }}</th>
                                    <td>
                                        @php
                                            $code = $leave->leave_type;
                                            $label = $leave->leaveTypeModel->name ?? __('leaves.types.' . $code, [], null) ?? $code;
                                            $classes = [
                                                'annual' => 'bg-primary',
                                                'sick' => 'bg-warning text-dark',
                                                'emergency' => 'bg-danger',
                                                'maternity' => 'bg-pink',
                                                'paternity' => 'bg-info',
                                                'unpaid' => 'bg-secondary',
                                            ];
                                            $class = $classes[$code] ?? 'bg-dark';
                                        @endphp
                                        <span class="badge {{ $class }}">{{ $label }}</span>
                                    </td>
                                </tr>
                                <tr><th>{{ __('leaves.fields.from') }}</th><td>{{ $leave->start_date?->format('Y-m-d') ?? __('leaves.not_specified') }}</td></tr>
                                <tr><th>{{ __('leaves.fields.to') }}</th><td>{{ $leave->end_date?->format('Y-m-d') ?? __('leaves.not_specified') }}</td></tr>
                                <tr><th>{{ __('leaves.fields.days') }}</th><td>{{ $leave->days_count ?? 0 }} {{ __('leaves.days_unit') }}</td></tr>
                                @if(($leave->excluded_days_count ?? 0) > 0)
                                    <tr style="background-color: #fff3cd;">
                                        <th>{{ __('leaves.fields.excluded_days') ?? 'أيام مستثناة' }}</th>
                                        <td><strong>{{ $leave->excluded_days_count ?? 0 }} {{ __('leaves.days_unit') }}</strong> (عطل أسبوعية/رسمية)</td>
                                    </tr>
                                    <tr style="background-color: #d1ecf1;">
                                        <th>{{ __('leaves.fields.deductible_days') ?? 'أيام قابلة للخصم' }}</th>
                                        <td><strong>{{ $leave->deductible_days ?? 0 }} {{ __('leaves.days_unit') }}</strong></td>
                                    </tr>
                                    @if(($leave->unpaid_deducted_days ?? 0) > 0)
                                        <tr style="background-color: #f8d7da;">
                                            <th>{{ __('leaves.fields.unpaid_deducted_days') ?? 'أيام مخصومة من الراتب (بدون راتب)' }}</th>
                                            <td><strong>{{ $leave->unpaid_deducted_days ?? 0 }} {{ __('leaves.days_unit') }}</strong></td>
                                        </tr>
                                    @endif
                                @endif
                            </table>
                        </div>

                        <div class="col-md-6">
                            <h5 class="mb-3">{{ __('leaves.show.request_details') }}</h5>
                            <table class="table table-borderless mb-0">
                                <tr><th>{{ __('leaves.fields.requested_at') }}</th><td>{{ $leave->created_at?->format('Y-m-d H:i') ?? __('leaves.not_specified') }}</td></tr>
                                @if($leave->status !== 'pending' && $leave->updated_at)
                                    <tr><th>{{ __('leaves.fields.updated_at') }}</th><td>{{ $leave->updated_at->format('Y-m-d H:i') }}</td></tr>
                                @endif
                                <tr><th>{{ __('leaves.fields.contact') }}</th><td>{{ $leave->contact_details ?? __('leaves.not_specified') }}</td></tr>
                            </table>
                        </div>
                    </div>

                    <div class="mb-4 mt-3">
                        <h5>{{ __('leaves.fields.reason') }}</h5>
                        <div class="alert alert-light border">{{ $leave->reason ?? __('leaves.no_reason') }}</div>
                    </div>

                    @if($leave->status == 'rejected' && $leave->rejection_reason)
                        <div class="mb-3">
                            <h5>{{ __('leaves.fields.rejection_reason') }}</h5>
                                <div class="alert alert-danger mb-0">{{ $leave->rejection_reason }}</div>
                        </div>
                    @endif

                    @if(($leave->excluded_days_count ?? 0) > 0 && $leave->excluded_days)
                        <div class="mb-3 mt-3">
                            <h5>{{ __('leaves.fields.excluded_days') ?? 'أيام مستثناة من الخصم' }}</h5>
                            <div class="alert alert-warning mb-0">
                                <strong>{{ __('leaves.fields.deductible_days') ?? 'أيام قابلة للخصم' }}:</strong> {{ $leave->deductible_days ?? 0 }} من {{ $leave->days_count ?? 0 }} أيام إجمالياً.<br>
                                <strong>الأيام المستثناة:</strong>
                                @php
                                    $excludedDates = $leave->excluded_days ?? [];
                                    $datesByType = [
                                        'weeklyOff' => [],
                                        'holiday' => [],
                                    ];
                                    
                                    foreach ($excludedDates as $date) {
                                        $carbonDate = \Carbon\Carbon::parse($date);
                                        // تحقق من Holiday
                                        $isHoliday = \App\Models\Holiday::whereDate('date', '=', $date)->exists();
                                        if ($isHoliday) {
                                            $datesByType['holiday'][] = $carbonDate;
                                        } else {
                                            // افترض أنها عطلة أسبوعية
                                            $datesByType['weeklyOff'][] = $carbonDate;
                                        }
                                    }
                                @endphp
                                <ul class="mt-2 mb-0">
                                    @if(count($datesByType['weeklyOff']) > 0)
                                        <li>
                                            <strong>أيام عطل أسبوعية:</strong>
                                            {{ implode(', ', array_map(fn($d) => $d->format('Y-m-d (l)'), $datesByType['weeklyOff'])) }}
                                        </li>
                                    @endif
                                    @if(count($datesByType['holiday']) > 0)
                                        <li>
                                            <strong>أيام عطل رسمية:</strong>
                                            @foreach($datesByType['holiday'] as $date)
                                                @php
                                                    $holiday = \App\Models\Holiday::whereDate('date', '=', $date->format('Y-m-d'))->first();
                                                @endphp
                                                <div>{{ $date->format('Y-m-d') }} - {{ $holiday->title ?? 'عطلة رسمية' }}</div>
                                            @endforeach
                                        </li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- ✅ 🟨 تراكم الإجازات الشهري والسنوي (الجديد) -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">تراكم الإجازات - التفاصيل الشهرية والسنوية ({{ now()->year }})</h5>
                </div>
                <div class="card-body">
                    @php
                        // حساب بيانات التراكم من بداية السنة الحالية لحد تاريخ الإجازة الحالية
                        $startOfYear = Carbon\Carbon::create(now()->year, 1, 1);
                        $leaveEndDate = $leave->end_date ? Carbon\Carbon::parse($leave->end_date) : now();
                        
                        // نحسب من بداية السنة الحالية لحد نهاية الإجازة الحالية
                        $leaveMonthlyDetails = $leave->employee->calculateLeaveDeductionDetailsNew(
                            $leaveEndDate->year, 
                            $leaveEndDate->month
                        );
                        
                        // نفلتر البيانات من بداية السنة الحالية فقط
                        $currentYearDetails = $leaveMonthlyDetails->filter(fn($d) => 
                            $d['year'] == now()->year && $d['month'] <= $leaveEndDate->month
                        );
                    @endphp

                    @if(!$leave->employee->isAccrualEnabled())
                        <div class="alert alert-info" role="alert">
                            <i class="fas fa-info-circle"></i>
                            <strong>تراكم الإجازات معطل</strong>
                            <p class="mb-0 mt-2">هذا الموظف لا يراكم الإجازات الشهرية والسنوية.</p>
                        </div>
                    @elseif($currentYearDetails && count($currentYearDetails) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-sm">
                                <thead>
                                    <tr>
                                        <th colspan="9" class="bg-light text-center"><strong>الإجازات الشهرية</strong></th>
                                        <th colspan="6" class="bg-light text-center"><strong>الإجازات السنوية</strong></th>
                                    </tr>
                                    <tr>
                                        <th>الشهر</th>
                                        <th>الممنوح (شهري)</th>
                                        <th>المستخدم (شهري)</th>
                                        <th>الرصيد قبل</th>
                                        <th>الرصيد بعد</th>
                                        <th>الزيادة (شهري)</th>
                                        <th>الخصم (شهري)</th>
                                        <th>الإجمالي</th>
                                        <th>ملاحظات</th>
                                        <th>المستخدم (سنوي)</th>
                                        <th>الرصيد قبل</th>
                                        <th>الرصيد بعد</th>
                                        <th>الزيادة (سنوي)</th>
                                        <th>الخصم (سنوي)</th>
                                        <th>الاستحقاق السنوي</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($currentYearDetails as $detail)
                                        <tr>
                                            <td><strong>{{ $detail['month_name'] ?? \Carbon\Carbon::create()->month($detail['month'])->translatedFormat('F') }}</strong></td>
                                            <td class="text-center">{{ number_format($detail['granted_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['used_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_before_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_after_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-center text-warning">{{ number_format($detail['excess_monthly'] ?? 0, 2) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['deduction_amount_monthly'] ?? 0) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['leave_deduction_amount'] ?? 0) }}</td>
                                            <td>-</td>
                                            <td class="text-center">{{ number_format($detail['used_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_before_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center">{{ number_format($detail['balance_after_annual'] ?? 0, 2) }}</td>
                                            <td class="text-center text-warning">{{ number_format($detail['excess_annual'] ?? 0, 2) }}</td>
                                            <td class="text-danger fw-bold">{{ format_currency($detail['deduction_amount_annual'] ?? 0) }}</td>
                                            <td>{{ number_format($leave->employee->annual_entitlement ?? ($leave->employee->monthly_leave_days_allowed * 12), 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- ✅ ملخص الخصومات للسنة الحالية حتى الآن -->
                        @php
                            $currentYearMonthlyDeductions = $currentYearDetails->sum('deduction_amount_monthly');
                            $currentYearAnnualDeductions = $currentYearDetails->sum('deduction_amount_annual');
                            $totalCurrentYearDeductions = $currentYearMonthlyDeductions + $currentYearAnnualDeductions;
                        @endphp
                        <div class="alert alert-danger mt-3" role="alert">
                            <h6 class="alert-heading">ملخص الخصومات من بداية السنة حتى الإجازة الحالية</h6>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-2"><strong>إجمالي خصومات الإجازات الشهرية:</strong></p>
                                    <p class="fs-5 fw-bold text-danger">{{ format_currency($currentYearMonthlyDeductions) }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-2"><strong>إجمالي خصومات الإجازات السنوية:</strong></p>
                                    <p class="fs-5 fw-bold text-danger">{{ format_currency($currentYearAnnualDeductions) }}</p>
                                </div>
                            </div>
                            <hr>
                            <p class="mb-0"><strong>إجمالي الخصومات (شهري + سنوي):</strong></p>
                            <p class="fs-4 fw-bold text-danger">{{ format_currency($totalCurrentYearDeductions) }}</p>
                        </div>
                    @else
                        <div class="alert alert-warning" role="alert">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>لا توجد بيانات</strong>
                            <p class="mb-0 mt-2">لم يتم العثور على بيانات تراكمية للإجازات في هذه الفترة.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
