<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <title>سجل إجازات {{ $employee->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-section { margin-bottom: 15px; }
        .info-section h3 { border-bottom: 1px solid #ccc; padding-bottom: 3px; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table td { border: 1px solid #ccc; padding: 5px; vertical-align: top; }
        .info-table th { background-color: #f2f2f2; border: 1px solid #ccc; padding: 5px; text-align: right; }
        .leave-row { font-size: 0.9em; }
        .status-badge { padding: 2px 5px; border-radius: 3px; font-size: 0.8em; }
        .badge-success { background-color: #d4edda; color: #155724; }
        .badge-warning { background-color: #fff3cd; color: #856404; }
        .badge-danger { background-color: #f8d7da; color: #721c24; }
        .badge-info { background-color: #d1ecf1; color: #0c5460; }
        .badge-secondary { background-color: #d6d8db; color: #383d41; }
        .text-danger { color: #dc3545; }
        .text-success { color: #28a745; }
        .text-warning { color: #ffc107; }
        /* أضف CSS إضافي للطباعة */
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>سجل إجازات الموظف: {{ $employee->name }}</h2>
        <h3>رقم الموظف: {{ $employee->employee_id }}</h3>
    </div>

    <div class="info-section">
        <h3>تفاصيل الإجازات (من {{ $leaves->last()?->start_date->format('Y-m-d') ?? 'N/A' }} إلى {{ $leaves->first()?->start_date->format('Y-m-d') ?? 'N/A' }})</h3>
        <table class="info-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>نوع الإجازة</th>
                    <th>من</th>
                    <th>إلى</th>
                    <th>الأيام</th>
                    <th>السبب</th>
                    <th>الحالة</th>
                    <th>تاريخ الطلب</th>
                </tr>
            </thead>
            <tbody>
                @forelse($leaves as $leave)
                <tr class="leave-row">
                    <td>{{ $leave->id }}</td>
                    <td>
                        @switch($leave->leave_type)
                            @case('annual') <span class="status-badge badge-primary">سنوية</span> @break
                            @case('sick') <span class="status-badge badge-warning">مرضية</span> @break
                            @case('emergency') <span class="status-badge badge-danger">طارئة</span> @break
                            @case('maternity') <span class="status-badge badge-pink">وضع</span> @break
                            @case('paternity') <span class="status-badge badge-info">أبوة</span> @break
                            @case('unpaid') <span class="status-badge badge-secondary">بدون راتب</span> @break
                            @default <span class="status-badge badge-dark">{{ $leave->leave_type }}</span>
                        @endswitch
                    </td>
                    <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                    <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                    <td>{{ $leave->days_count }}</td>
                    <td>{{ Str::limit($leave->reason, 50) }}</td>
                    <td>
                        @php
                            $statusClasses = [
                                'pending' => 'badge-warning',
                                'approved' => 'badge-success',
                                'rejected' => 'badge-danger',
                                'cancelled' => 'badge-secondary',
                            ];
                            $statusLabels = [
                                'pending' => 'معلق',
                                'approved' => 'موافق عليه',
                                'rejected' => 'مرفوض',
                                'cancelled' => 'ملغى',
                            ];
                            $badgeClass = $statusClasses[$leave->status] ?? 'badge-dark';
                            $badgeLabel = $statusLabels[$leave->status] ?? $leave->status;
                        @endphp
                        <span class="status-badge {{ $badgeClass }}">{{ $badgeLabel }}</span>
                    </td>
                    <td>{{ $leave->created_at->format('Y-m-d') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-center py-3">لا توجد سجلات إجازات خلال هذه الفترة.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <script>
        // طباعة الصفحة مباشرة عند التحميل
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>