@extends('layouts.app')

@section('content')
<div class="container-fluid">

    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('leaves.index.title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('leaves.breadcrumb.home') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('leaves.breadcrumb.leaves') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-3">
        <div class="col-md-2">
            <div class="card bg-primary text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.total_requests') }}</p>
                        <h4 class="mb-0">{{ $totalLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-umbrella-beach fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.approved') }}</p>
                        <h4 class="mb-0">{{ $approvedLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-check-circle fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.pending') }}</p>
                        <h4 class="mb-0">{{ $pendingLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-clock fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-2">
            <div class="card bg-danger text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.rejected') }}</p>
                        <h4 class="mb-0">{{ $rejectedLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-times-circle fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- 🟣 كرت الإجازات الملغاة -->
        <div class="col-md-2">
            <div class="card bg-secondary text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.cancelled') }}</p>
                        <h4 class="mb-0">{{ $cancelledLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-ban fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- 🟢 كرت الإجازات المعدلة -->
        <div class="col-md-2">
            <div class="card bg-info text-white">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <p class="text-truncate font-size-14 mb-2">{{ __('leaves.index.stats.modified') }}</p>
                        <h4 class="mb-0">{{ $modifiedLeaves ?? 0 }}</h4>
                    </div>
                    <div class="avatar-sm">
                        <span class="avatar-title bg-transparent rounded">
                            <i class="fas fa-edit fa-2x"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center gap-2">
                            <h4 class="card-title mb-0">{{ __('leaves.index.requests_title') }}</h4>
                            <a href="{{ route('leaves.guide') }}" class="btn btn-info btn-sm shadow-sm" title="اضغط هنا لرؤية شرح تفصيلي لأنواع الإجازات" data-bs-toggle="tooltip" data-bs-placement="top">
                                <i class="fas fa-book-open me-1"></i>
                                <i class="fas fa-question-circle me-1"></i>
                                <span>دليل الإجازات</span>
                            </a>
                        </div>
                        @can('create', \App\Models\Leave::class)
                        <a href="{{ route('leaves.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> {{ __('leaves.index.new_request_button') }}
                        </a>
                        @endcan
                    </div>

                    <!-- Filters -->
                    <div class="row mb-3 g-2">
                        <div class="col-md-3">
                            <input type="text" id="searchInput" class="form-control" placeholder="{{ __('leaves.filters.search_placeholder') }}">
                        </div>
                        <div class="col-md-2">
                            <select id="employeeFilter" class="form-control">
                                <option value="">{{ __('leaves.filters.all_employees') }}</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="statusFilter" class="form-control">
                                <option value="">{{ __('leaves.filters.all_statuses') }}</option>
                                <option value="pending">{{ __('leaves.status.pending') }}</option>
                                <option value="approved">{{ __('leaves.status.approved') }}</option>
                                <option value="rejected">{{ __('leaves.status.rejected') }}</option>
                                <option value="cancelled">{{ __('leaves.status.cancelled') }}</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="typeFilter" class="form-control">
                                <option value="">{{ __('leaves.filters.all_types') }}</option>
                                @if(isset($leaveTypes) && $leaveTypes->count())
                                    @foreach($leaveTypes as $lt)
                                        <option value="{{ $lt->code }}">{{ $lt->name }}</option>
                                    @endforeach
                                @else
                                    <option value="annual">{{ __('leaves.types.annual') }}</option>
                                    <option value="sick">{{ __('leaves.types.sick') }}</option>
                                    <option value="emergency">{{ __('leaves.types.emergency') }}</option>
                                    <option value="maternity">{{ __('leaves.types.maternity') }}</option>
                                    <option value="paternity">{{ __('leaves.types.paternity') }}</option>
                                    <option value="unpaid">{{ __('leaves.types.unpaid') }}</option>
                                @endif
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="monthFilter" class="form-control">
                                <option value="">{{ __('leaves.filters.all_months') }}</option>
                                @for ($i = 1; $i <= 12; $i++)
                                    <option value="{{ $i }}">{{ \Carbon\Carbon::createFromDate(null, $i, 1)->translatedFormat('F') }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select id="yearFilter" class="form-control">
                                <option value="">{{ __('leaves.filters.all_years') }}</option>
                                @php
                                    $currentYear = date('Y');
                                    $startYear = $currentYear - 5;
                                    $endYear = $currentYear + 25; // ✅ تم التحديث إلى 25 سنة لاحقة
                                @endphp
                                @for ($y = $startYear; $y <= $endYear; $y++)
                                    <option value="{{ $y }}">{{ $y }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button id="applyFilters" class="btn btn-primary w-100 me-1">
                                <i class="fas fa-filter"></i> {{ __('leaves.filters.apply') }}
                            </button>
                            <button id="resetFilters" class="btn btn-secondary w-100">
                                <i class="fas fa-redo"></i> {{ __('leaves.filters.reset') }}
                            </button>
                        </div>
                    </div>

                    <!-- Leaves Table -->
                    <div class="table-responsive">
                        <table class="table table-centered table-hover table-striped">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('leaves.table.employee_name') }}</th>
                                    <th>{{ __('leaves.table.type') }}</th>
                                    <th>{{ __('leaves.table.from') }}</th>
                                    <th>{{ __('leaves.table.to') }}</th>
                                    <th>{{ __('leaves.table.days') }}</th>
                                    <th>{{ __('leaves.table.reason') }}</th>
                                    <th>{{ __('leaves.table.requested_at') }}</th>
                                    <th>{{ __('leaves.table.status') }}</th>
                                    <th>{{ __('leaves.table.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($leaves as $leave)
                                <tr>
                                    <td>{{ $leave->id }}</td>
                                    <td>{{ $leave->employee->name ?? 'غير معروف' }}</td>
                                    <td>
                                        {{ $leave->leaveTypeModel->name ?? __('leaves.types.' . $leave->leave_type, [], null) ?? $leave->leave_type }}
                                    </td>
                                    <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                                    <td>{{ $leave->days_count }}</td>
                                    <td>{{ Str::limit($leave->reason, 30) }}</td>
                                    <td>{{ $leave->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        <span class="badge bg-dark text-white px-2 py-1">{{ __('leaves.status.' . $leave->status, [], null) ?? $leave->status }}</span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view', $leave)
                                            <a href="{{ route('leaves.show', $leave) }}" class="btn btn-info btn-sm" title="{{ __('leaves.actions.view') }}">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            {{-- ✅ زر التعديل دائماً متاح --}}
                                            @can('update', $leave)
                                            <a href="{{ route('leaves.edit', $leave) }}" class="btn btn-warning btn-sm" title="{{ __('leaves.actions.edit') }}">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan

                                            {{-- ✅ زر إلغاء الإجازة --}}
                                            @if(!in_array($leave->status, ['rejected', 'cancelled']))
                                                <form action="{{ route('leaves.cancel', $leave) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-secondary btn-sm" title="{{ __('leaves.actions.cancel') }}"
                                                        onclick="return confirm('{{ __('leaves.confirm.cancel') }}')">
                                                        <i class="fas fa-ban"></i>
                                                    </button>
                                                </form>
                                            @endif

                                            {{-- ✅ أزرار الموافقة والرفض فقط للحالة المعلقة --}}
                                            @if($leave->status == 'pending')
                                                @can('approve', $leave)
                                                <form action="{{ route('leaves.approve', $leave) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success btn-sm" title="موافقة"
                                                        onclick="return confirm('{{ __('leaves.confirm.approve') }}')">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                                @endcan

                                                @can('reject', $leave)
                                                <form action="{{ route('leaves.reject', $leave) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger btn-sm" title="رفض"
                                                        onclick="return confirm('{{ __('leaves.confirm.reject') }}')">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif

                                            @can('delete', $leave)
                                                <form action="{{ route('leaves.destroy', $leave) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="حذف"
                                                    onclick="return confirm('{{ __('leaves.confirm.delete') }}')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center text-muted">{{ __('leaves.index.empty') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if(isset($leaves) && $leaves instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator && $leaves->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $leaves->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- ⭐ القواعد العامة للإجازات - نقل إلى الأسفل -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title mb-3"><i class="fas fa-info-circle text-primary me-2"></i> {{ __('leaves.rules.title') }}</h5>
                    {!! __('leaves.rules.html') !!}
                </div>
            </div>
        </div>
    </div>

</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const employeeFilter = document.getElementById('employeeFilter');
    const statusFilter = document.getElementById('statusFilter');
    const typeFilter = document.getElementById('typeFilter');
    const monthFilter = document.getElementById('monthFilter');
    const yearFilter = document.getElementById('yearFilter');
    const applyFiltersBtn = document.getElementById('applyFilters');
    const resetFiltersBtn = document.getElementById('resetFilters');

    function applyFilters() {
        let url = new URL(window.location.href);
        url.search = '';
        if (searchInput.value) url.searchParams.append('search', searchInput.value);
        if (employeeFilter.value) url.searchParams.append('employee_id', employeeFilter.value);
        if (statusFilter.value) url.searchParams.append('status', statusFilter.value);
        if (typeFilter.value) url.searchParams.append('type', typeFilter.value);
        if (monthFilter.value) url.searchParams.append('month', monthFilter.value);
        if (yearFilter.value) url.searchParams.append('year', yearFilter.value);
        window.location.href = url.toString();
    }

    function resetFilters() {
        searchInput.value = '';
        employeeFilter.value = '';
        statusFilter.value = '';
        typeFilter.value = '';
        monthFilter.value = '';
        yearFilter.value = '';
        window.location.href = window.location.pathname + '?page=1';
    }

    applyFiltersBtn?.addEventListener('click', applyFilters);
    resetFiltersBtn?.addEventListener('click', resetFilters);

    const urlParams = new URLSearchParams(window.location.search);
    searchInput.value = urlParams.get('search') || '';
    employeeFilter.value = urlParams.get('employee_id') || '';
    statusFilter.value = urlParams.get('status') || '';
    typeFilter.value = urlParams.get('type') || '';
    monthFilter.value = urlParams.get('month') || '';
    yearFilter.value = urlParams.get('year') || '';
});
</script>
@endpush
@endsection