@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Page Title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">
                    <i class="fas fa-book-open text-primary me-2"></i>
                    دليل أنواع الإجازات الشامل
                </h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('leaves.index') }}">الإجازات</a></li>
                        <li class="breadcrumb-item active">دليل الإجازات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Header Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-gradient-primary text-white">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h3 class="mb-2">
                                <i class="fas fa-info-circle me-2"></i>
                                دليل شامل لأنواع الإجازات
                            </h3>
                            <p class="mb-0 opacity-75">
                                تعرف على جميع أنواع الإجازات المتاحة وكيفية عملها في النظام
                            </p>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="avatar-lg mx-auto">
                                <div class="avatar-title bg-white text-primary rounded-circle font-size-24">
                                    <i class="fas fa-question-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Important Notes -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-lightbulb me-2"></i>
                        ملاحظات مهمة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-calendar-alt text-primary me-2 mt-1"></i>
                                <div>
                                    <strong>الرصيد السنوي:</strong>
                                    <p class="mb-0 text-muted">يُحسب من تاريخ التعيين (الأشهر × الحصة الشهرية)</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-calendar-week text-success me-2 mt-1"></i>
                                <div>
                                    <strong>الرصيد الشهري:</strong>
                                    <p class="mb-0 text-muted">يُحسب شهريًا (الرصيد المتبقي + الحصة الشهرية الجديدة)</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-money-bill-wave text-warning me-2 mt-1"></i>
                                <div>
                                    <strong>الأجر اليومي:</strong>
                                    <p class="mb-0 text-muted">(الراتب الإجمالي + المكونات) ÷ 30</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="d-flex align-items-start">
                                <i class="fas fa-calculator text-danger me-2 mt-1"></i>
                                <div>
                                    <strong>الأيام المخصومة:</strong>
                                    <p class="mb-0 text-muted">تُحسب بعد استبعاد عطلات نهاية الأسبوع والعطلات المدفوعة</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Table -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-table me-2"></i>
                        الجدول التفصيلي - جميع السيناريوهات
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>نوع الإجازة</th>
                                    <th>الرصيد المتاح</th>
                                    <th>الأيام المطلوبة</th>
                                    <th>عند الإنشاء</th>
                                    <th>عند الموافقة</th>
                                    <th>تأثير الرصيد</th>
                                    <th>تأثير الراتب</th>
                                    <th>النتيجة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Monthly Leave -->
                                <tr class="table-info">
                                    <td rowspan="4" class="align-middle"><strong>1. إجازة شهرية</strong></td>
                                    <td><span class="badge bg-success">10 أيام</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> تُخصم 5 أيام</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-info">
                                    <td><span class="badge bg-success">10 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> تُخصم 10 أيام</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -10 (يصبح 0)</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-warning">
                                    <td><span class="badge bg-warning">5 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> تُخصم 5 فقط</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -5 (يصبح 0)</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 5 أيام</strong></td>
                                    <td><span class="badge bg-warning">5 مدفوعة + 5 بدون راتب</span></td>
                                </tr>
                                <tr class="table-danger">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> لا يُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> 0 (لا يتغير)</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 5 أيام</strong></td>
                                    <td><span class="badge bg-danger">بدون راتب بالكامل</span></td>
                                </tr>

                                <!-- Annual Leave -->
                                <tr class="table-success">
                                    <td rowspan="4" class="align-middle"><strong>2. إجازة سنوية</strong></td>
                                    <td><span class="badge bg-success">15 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> تُخصم 10 أيام</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-success">
                                    <td><span class="badge bg-success">10 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> تُخصم 10 أيام</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -10 (يصبح 0)</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-warning">
                                    <td><span class="badge bg-warning">5 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>طلبين تلقائيًا</strong></td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> تُخصم 5 أيام</td>
                                    <td><i class="fas fa-arrow-down text-danger"></i> -5 (يصبح 0)</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 5 أيام</strong></td>
                                    <td><span class="badge bg-warning">5 سنوية + 5 بدون راتب</span></td>
                                </tr>
                                <tr class="table-danger">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> طلب بدون راتب</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> لا يُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> 0 (لا يتغير)</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 10 أيام</strong></td>
                                    <td><span class="badge bg-danger">بدون راتب بالكامل</span></td>
                                </tr>

                                <!-- Emergency Leave -->
                                <tr class="table-primary">
                                    <td rowspan="2" class="align-middle"><strong>3. إجازة طارئة</strong></td>
                                    <td><span class="badge bg-info">أي رصيد</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-primary">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>

                                <!-- Sick Leave -->
                                <tr class="table-info">
                                    <td rowspan="2" class="align-middle"><strong>4. إجازة مرضية</strong></td>
                                    <td><span class="badge bg-info">أي رصيد</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-info">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>

                                <!-- Maternity Leave -->
                                <tr class="table-light">
                                    <td rowspan="2" class="align-middle"><strong>5. إجازة أمومة</strong></td>
                                    <td><span class="badge bg-info">أي رصيد</span></td>
                                    <td>30 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-light">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>90 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>

                                <!-- Paternity Leave -->
                                <tr class="table-light">
                                    <td rowspan="2" class="align-middle"><strong>6. إجازة أبوة</strong></td>
                                    <td><span class="badge bg-info">أي رصيد</span></td>
                                    <td>3 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>
                                <tr class="table-light">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-check text-success"></i> لا تأثير</td>
                                    <td><span class="badge bg-success">مدفوعة بالكامل</span></td>
                                </tr>

                                <!-- Unpaid Leave -->
                                <tr class="table-danger">
                                    <td rowspan="2" class="align-middle"><strong>7. إجازة بدون راتب</strong></td>
                                    <td><span class="badge bg-info">أي رصيد</span></td>
                                    <td>5 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 5 أيام</strong></td>
                                    <td><span class="badge bg-danger">بدون راتب بالكامل</span></td>
                                </tr>
                                <tr class="table-danger">
                                    <td><span class="badge bg-danger">0 أيام</span></td>
                                    <td>10 أيام</td>
                                    <td><i class="fas fa-check text-success"></i> طلب واحد</td>
                                    <td><i class="fas fa-check text-success"></i> لا تُخصم</td>
                                    <td><i class="fas fa-minus text-secondary"></i> لا يتغير</td>
                                    <td><i class="fas fa-exclamation-triangle text-warning"></i> <strong>يُخصم 10 أيام</strong></td>
                                    <td><span class="badge bg-danger">بدون راتب بالكامل</span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Explanations -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        شرح تفصيلي لكل نوع إجازة
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Monthly Leave -->
                    <div class="mb-4">
                        <h5 class="text-primary">
                            <i class="fas fa-calendar-week me-2"></i>
                            1. إجازة شهرية (Monthly)
                        </h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <strong>✅ السيناريو 1: الرصيد كافي</strong>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>الرصيد:</strong> 10 أيام</p>
                                        <p><strong>المطلوب:</strong> 5 أيام</p>
                                        <p><strong>النتيجة:</strong></p>
                                        <ul>
                                            <li>يُنشأ طلب واحد</li>
                                            <li>عند الموافقة: تُخصم 5 أيام من الرصيد الشهري</li>
                                            <li>الرصيد يصبح: 5 أيام</li>
                                            <li>الراتب: لا يتأثر (مدفوعة بالكامل)</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <strong>⚠️ السيناريو 2: الرصيد غير كافي</strong>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>الرصيد:</strong> 5 أيام</p>
                                        <p><strong>المطلوب:</strong> 10 أيام</p>
                                        <p><strong>النتيجة:</strong></p>
                                        <ul>
                                            <li>يُنشأ طلب واحد</li>
                                            <li>عند الموافقة: تُخصم 5 أيام من الرصيد (يصبح 0)</li>
                                            <li>الأيام الزائدة (5 أيام): تُخصم من الراتب تلقائيًا</li>
                                            <li><strong>الخصم من الراتب:</strong> 5 أيام × الأجر اليومي</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Annual Leave -->
                    <div class="mb-4">
                        <h5 class="text-success">
                            <i class="fas fa-calendar-alt me-2"></i>
                            2. إجازة سنوية (Annual)
                        </h5>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="card border-success">
                                    <div class="card-header bg-success text-white">
                                        <strong>✅ الرصيد كافي</strong>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>الرصيد:</strong> 15 أيام</p>
                                        <p><strong>المطلوب:</strong> 10 أيام</p>
                                        <p>تُخصم 10 أيام من الرصيد السنوي - مدفوعة بالكامل</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card border-warning">
                                    <div class="card-header bg-warning text-dark">
                                        <strong>⚠️ الرصيد غير كافي (مميز)</strong>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>الرصيد:</strong> 5 أيام</p>
                                        <p><strong>المطلوب:</strong> 10 أيام</p>
                                        <p><strong>يُنشأ طلبين تلقائيًا:</strong></p>
                                        <ul>
                                            <li>إجازة سنوية: 5 أيام (مدفوعة)</li>
                                            <li>إجازة بدون راتب: 5 أيام (تُخصم من الراتب)</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card border-danger">
                                    <div class="card-header bg-danger text-white">
                                        <strong>❌ لا يوجد رصيد</strong>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>الرصيد:</strong> 0 أيام</p>
                                        <p><strong>المطلوب:</strong> 10 أيام</p>
                                        <p>يُنشأ طلب واحد (إجازة بدون راتب) - تُخصم 10 أيام من الراتب</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Other Leaves -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <strong>3-6. إجازات لا تحتاج رصيد</strong>
                                </div>
                                <div class="card-body">
                                    <p>هذه الأنواع <strong>لا تحتاج رصيد أبدًا</strong> و<strong>مدفوعة بالكامل</strong>:</p>
                                    <ul>
                                        <li><strong>طارئة:</strong> للأمور الطارئة</li>
                                        <li><strong>مرضية:</strong> للمرض</li>
                                        <li><strong>أمومة:</strong> للنساء بعد الولادة</li>
                                        <li><strong>أبوة:</strong> للرجال بعد ولادة الزوجة</li>
                                    </ul>
                                    <p class="mb-0"><strong>النتيجة دائماً:</strong> إجازة مدفوعة بالكامل - لا تأثير على الرصيد أو الراتب</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="card border-danger">
                                <div class="card-header bg-danger text-white">
                                    <strong>7. إجازة بدون راتب</strong>
                                </div>
                                <div class="card-body">
                                    <p><strong>لا تحتاج رصيد أبدًا</strong></p>
                                    <p><strong>النتيجة دائماً:</strong> إجازة بدون راتب</p>
                                    <p><strong>الراتب:</strong> يُخصم عدد الأيام × الأجر اليومي</p>
                                    <hr>
                                    <p class="mb-0"><strong>مثال:</strong></p>
                                    <ul class="mb-0">
                                        <li>الراتب: 3000 جنيه</li>
                                        <li>الأجر اليومي: 100 جنيه</li>
                                        <li>إجازة 5 أيام = خصم 500 جنيه</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Summary -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">
                        <i class="fas fa-list me-2"></i>
                        ملخص سريع
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>نوع الإجازة</th>
                                    <th>يحتاج رصيد؟</th>
                                    <th>عند تجاوز الرصيد</th>
                                    <th>تأثير على الراتب</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><strong>شهرية</strong></td>
                                    <td><span class="badge bg-success">نعم (شهري)</span></td>
                                    <td><span class="badge bg-warning">يُخصم الجزء الزائد</span></td>
                                    <td><span class="badge bg-warning">نعم (للجزء الزائد)</span></td>
                                </tr>
                                <tr>
                                    <td><strong>سنوية</strong></td>
                                    <td><span class="badge bg-success">نعم (سنوي)</span></td>
                                    <td><span class="badge bg-warning">يُنشأ طلبين</span></td>
                                    <td><span class="badge bg-warning">نعم (للجزء الزائد)</span></td>
                                </tr>
                                <tr>
                                    <td><strong>طارئة / مرضية / أمومة / أبوة</strong></td>
                                    <td><span class="badge bg-danger">لا</span></td>
                                    <td><span class="badge bg-success">لا يحدث شيء</span></td>
                                    <td><span class="badge bg-success">لا</span></td>
                                </tr>
                                <tr>
                                    <td><strong>بدون راتب</strong></td>
                                    <td><span class="badge bg-danger">لا</span></td>
                                    <td><span class="badge bg-success">لا يحدث شيء</span></td>
                                    <td><span class="badge bg-danger">نعم (دائماً)</span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Special Cases -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        حالات خاصة
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="text-primary">
                                        <i class="fas fa-calendar-check me-2"></i>
                                        إجازة سنوية تتجاوز الرصيد
                                    </h6>
                                    <p class="mb-0">النظام <strong>يُنشأ طلبين تلقائيًا</strong> عند الإنشاء - لا تحتاج تدخل يدوي</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="text-warning">
                                        <i class="fas fa-calculator me-2"></i>
                                        حساب الأيام المخصومة
                                    </h6>
                                    <p class="mb-0">يتم استبعاد عطلات نهاية الأسبوع والعطلات المدفوعة - فقط أيام العمل الفعلية تُحسب</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="text-success">
                                        <i class="fas fa-money-bill-wave me-2"></i>
                                        حساب الخصم من الراتب
                                    </h6>
                                    <p class="mb-0">الأجر اليومي = (الراتب + المكونات) ÷ 30<br>الخصم = الأيام × الأجر اليومي</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Back Button -->
    <div class="row">
        <div class="col-12">
            <div class="text-center">
                <a href="{{ route('leaves.index') }}" class="btn btn-primary btn-lg">
                    <i class="fas fa-arrow-right me-2"></i>
                    العودة إلى قائمة الإجازات
                </a>
            </div>
        </div>
    </div>

</div>

@push('styles')
<style>
    .bg-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    .table th {
        white-space: nowrap;
    }
    .card {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        transition: box-shadow 0.15s ease-in-out;
    }
    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
</style>
@endpush
@endsection

