@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- العنوان والملاحة -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">{{ __('leaves.edit.title') }}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard.index') }}">{{ __('leaves.breadcrumb.home') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('leaves.index') }}">{{ __('leaves.breadcrumb.leaves') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('leaves.edit.breadcrumb') }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- نموذج تعديل الإجازة -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{ __('leaves.edit.form_title') }}</h4>

                    <form action="{{ route('leaves.update', $leave) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- عرض رسائل الأخطاء أو الرسائل العامة --}}
                        @if($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="alert alert-danger">{{ session('error') }}</div>
                        @endif

                        @if(session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif

                        <!-- بيانات الموظف ونوع الإجازة -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">{{ __('leaves.form.employee') }}</label>
                                <input type="text" class="form-control" value="{{ $leave->employee?->name ?? 'موظف غير معروف' }}" readonly>
                                <input type="hidden" name="employee_id" value="{{ $leave->employee_id }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="leave_type" class="form-label">{{ __('leaves.form.leave_type') }} <span class="text-danger">*</span></label>
                                <select class="form-control" id="leave_type" name="leave_type" required>
                                    <option value="">{{ __('leaves.form.select_type') }}</option>
                                    @if(isset($leaveTypes) && $leaveTypes->count())
                                        @foreach($leaveTypes as $lt)
                                            <option value="{{ $lt->code }}" {{ old('leave_type', $leave->leave_type) == $lt->code ? 'selected' : '' }}>{{ $lt->name }}</option>
                                        @endforeach
                                    @else
                                        <option value="annual" {{ old('leave_type', $leave->leave_type) == 'annual' ? 'selected' : '' }}>{{ __('leaves.types.annual') }}</option>
                                        <option value="sick" {{ old('leave_type', $leave->leave_type) == 'sick' ? 'selected' : '' }}>{{ __('leaves.types.sick') }}</option>
                                        <option value="emergency" {{ old('leave_type', $leave->leave_type) == 'emergency' ? 'selected' : '' }}>{{ __('leaves.types.emergency') }}</option>
                                        <option value="maternity" {{ old('leave_type', $leave->leave_type) == 'maternity' ? 'selected' : '' }}>{{ __('leaves.types.maternity') }}</option>
                                        <option value="paternity" {{ old('leave_type', $leave->leave_type) == 'paternity' ? 'selected' : '' }}>{{ __('leaves.types.paternity') }}</option>
                                        <option value="unpaid" {{ old('leave_type', $leave->leave_type) == 'unpaid' ? 'selected' : '' }}>{{ __('leaves.types.unpaid') }}</option>
                                    @endif
                                </select>
                            </div>
                        </div>

                        <!-- التواريخ وعدد الأيام -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="start_date" class="form-label">{{ __('leaves.form.start_date') }} <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="start_date" name="start_date" 
                                    value="{{ old('start_date', $leave->start_date->format('Y-m-d')) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="end_date" class="form-label">{{ __('leaves.form.end_date') }} <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="end_date" name="end_date" 
                                    value="{{ old('end_date', $leave->end_date->format('Y-m-d')) }}" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="days_count" class="form-label">{{ __('leaves.form.days_count') }} <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="days_count" name="days_count" 
                                   value="{{ old('days_count', $leave->days_count) }}" readonly>
                        </div>

                        <!-- السبب وتفاصيل الاتصال -->
                        <div class="mb-3">
                            <label for="reason" class="form-label">{{ __('leaves.form.reason') }} <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="reason" name="reason" rows="4" required>{{ old('reason', $leave->reason) }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label for="contact_details" class="form-label">{{ __('leaves.form.contact_details') }}</label>
                            <input type="text" class="form-control" id="contact_details" name="contact_details" 
                                value="{{ old('contact_details', $leave->contact_details) }}" 
                                placeholder="{{ __('leaves.form.contact_placeholder') }}">
                        </div>

                        <!-- أزرار -->
                        @if($leave->status === 'approved')
                            <div class="alert alert-info">
                                <strong>تنبيه:</strong> هذه الإجازة مُعتمدة بالفعل. تعديلها سيؤثر على رصيد الموظف ويحفظ سجل التعديل.
                                الرجاء التأكيد وإضافة سبب التعديل إذا لزم الأمر.
                            </div>

                            <div class="mb-3">
                                <label for="approval_modify_note" class="form-label">سبب تعديل الموافقة (اختياري)</label>
                                <textarea id="approval_modify_note" name="approval_modify_note" class="form-control" rows="2" placeholder="مثال: عاد الموظف بعد يومين من الإجازة"></textarea>
                            </div>
                        @endif

                        <div class="d-flex gap-2">
                            <button type="submit" id="save-btn" class="btn btn-warning">
                                <i class="fas fa-save"></i> {{ __('leaves.form.save_changes') }}
                            </button>
                            <a href="{{ route('leaves.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> {{ __('leaves.form.back') }}
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- معلومات الموظف ورصيد الإجازات -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">معلومات الموظف</h5>
                    <div class="d-flex align-items-center mb-3">
                        @if($leave->employee->photo)
                            <img src="{{ asset('storage/' . $leave->employee->photo) }}" alt="صورة الموظف" class="rounded-circle me-3" width="60" height="60">
                        @else
                            <div class="avatar-md me-3">
                                <span class="avatar-title bg-primary text-white rounded-circle">
                                    {{ substr($leave->employee->name ?? '-', 0, 1) }}
                                </span>
                            </div>
                        @endif
                        <div>
                            <h6 class="mb-1">{{ $leave->employee->name ?? '-' }}</h6>
                            <p class="mb-0 text-muted">{{ optional($leave->employee->position)->name ?? 'غير محدد' }}</p>
                            <p class="mb-0 text-muted">{{ optional($leave->employee->department)->name ?? 'غير محدد' }}</p>
                        </div>
                    </div>

                    <!-- ✅ تعديل عرض رصيد الإجازات -->
                    <div class="row text-center">
                        @php
                            // ✅ حساب الرصيد التراكمي حتى نهاية الشهر السابق (الرصيد الفعلي)
                            $employee = $leave->employee;
                            $hireDate = \Carbon\Carbon::parse($employee->hire_date);
                            $currentDate = \Carbon\Carbon::now();

                            $lastMonthEnd = \Carbon\Carbon::createFromDate($currentDate->year, $currentDate->month, 1)->subDay(); // آخر يوم في الشهر السابق

                            if ($hireDate->greaterThan($lastMonthEnd)) {
                                $monthsWorked = 0;
                            } else {
                                $monthsWorked = $hireDate->diffInMonths($lastMonthEnd);
                                if ($lastMonthEnd->day >= $hireDate->day) {
                                    $monthsWorked += 1;
                                }
                            }

                            $monthsWorked = max(0, min($monthsWorked, 12)); // ⚠️ قد يُطبق الحد الأقصى السنوي
                            $actualCumulativeBalance = round(($employee->monthly_leave_days_allowed ?? 0) * $monthsWorked, 2);

                            // حساب الأيام المستخدمة حتى نهاية الشهر السابق
                            $usedDaysThisMonth = $employee->leaves()
                                ->whereIn('status', ['approved', 'modified'])
                                ->ofCodes(['annual', 'emergency'])
                                ->whereMonth('start_date', $currentDate->month)
                                ->whereYear('start_date', $currentDate->year)
                                ->sum('days_count');

                            $usedDaysBeforeThisMonth = $employee->leaves()
                                ->whereIn('status', ['approved', 'modified'])
                                ->ofCodes(['annual', 'emergency'])
                                ->where(function ($query) use ($lastMonthEnd) {
                                    $query->whereDate('start_date', '<=', $lastMonthEnd)
                                          ->orWhereDate('end_date', '<=', $lastMonthEnd);
                                })
                                ->sum('days_count');

                            $expectedBalanceAfterThisMonthUsage = $actualCumulativeBalance - $usedDaysThisMonth;

                            // ✅ حساب الرصيد بعد استخدام هذا الطلب (الحالي)
                            $newTotalUsed = $usedDaysBeforeThisMonth + $usedDaysThisMonth + $leave->days_count;
                            $balanceAfterLeave = $actualCumulativeBalance - $newTotalUsed;
                        @endphp

                        <div class="col-4">
                            <h6>{{ $actualCumulativeBalance }}</h6>
                            <p class="text-muted mb-0">الرصيد الفعلي (التراكمي)</p>
                        </div>
                        <div class="col-4">
                            <h6>{{ $newTotalUsed }}</h6>
                            <p class="text-muted mb-0">المستخدمة (الحالية + هذا الطلب)</p>
                        </div>
                        <div class="col-4">
                            <h6 class="{{ $balanceAfterLeave < 0 ? 'text-danger' : ($balanceAfterLeave == 0 ? 'text-warning' : 'text-success') }}">{{ $balanceAfterLeave }}</h6>
                            <p class="text-muted mb-0">المتبقية (بعد هذا الطلب)</p>
                        </div>
                    </div>

                    <!-- ✅ عرض رسالة توضيحية إذا كان الرصيد سالبًا -->
                    @if($balanceAfterLeave < 0)
                        <div class="alert alert-danger mt-3">
                            <i class="fas fa-exclamation-triangle"></i> الرصيد سالب! سيتم خصم الأيام الزائدة من الراتب.
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- تفاصيل الطلب -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">تفاصيل الطلب</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>حالة الطلب:</th>
                            <td>
                                @if($leave->status == 'pending')
                                    <span class="badge bg-warning text-dark">معلق</span>
                                @elseif($leave->status == 'approved')
                                    <span class="badge bg-success">موافق عليه</span>
                                @elseif($leave->status == 'rejected')
                                    <span class="badge bg-danger">مرفوض</span>
                                @elseif($leave->status == 'cancelled')
                                    <span class="badge bg-secondary">ملغى</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>نوع الإجازة:</th>
                            <td>
                                {{ $leave->leaveTypeModel->name ?? ($leaveTypes->where('code', $leave->leave_type)->first()->name ?? $leave->leave_type) }}
                            </td>
                        </tr>
                        <tr>
                            <th>من:</th>
                            <td>{{ $leave->start_date->format('Y-m-d') }}</td>
                        </tr>
                        <tr>
                            <th>إلى:</th>
                            <td>{{ $leave->end_date->format('Y-m-d') }}</td>
                        </tr>
                        <tr>
                            <th>عدد الأيام:</th>
                            <td>{{ $leave->days_count }}</td>
                        </tr>
                        <tr>
                            <th>السبب:</th>
                            <td>{{ $leave->reason }}</td>
                        </tr>
                        <tr>
                            <th>تاريخ الطلب:</th>
                            <td>{{ $leave->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>تاريخ التحديث:</th>
                            <td>{{ $leave->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const startDateInput = document.getElementById('start_date');
    const endDateInput = document.getElementById('end_date');
    const daysCountInput = document.getElementById('days_count');
    // ✅ تحديث المتغيرات بناءً على الحساب الجديد
    const actualCumulativeBalance = {{ $actualCumulativeBalance ?? 0 }};
    const usedDaysBeforeThisMonth = {{ $usedDaysBeforeThisMonth ?? 0 }};
    const usedDaysThisMonth = {{ $usedDaysThisMonth ?? 0 }};
    const remainingElem = document.querySelector('.row.text-center .col-4:last-child h6');
    const usedThisMonthElem = document.querySelector('.row.text-center .col-4:nth-child(2) h6'); // العنصر الثاني

    function calculateDays() {
        if (startDateInput.value && endDateInput.value) {
            const start = new Date(startDateInput.value);
            const end = new Date(endDateInput.value);
            if (!isNaN(start) && !isNaN(end) && end >= start) {
                const days = Math.ceil((end - start) / (1000 * 60 * 60 * 24)) + 1;
                daysCountInput.value = days;

                // ✅ حساب الرصيد الجديد بعد استخدام هذا الطلب
                const newTotalUsed = usedDaysBeforeThisMonth + usedDaysThisMonth + days;
                const balanceAfterLeave = actualCumulativeBalance - newTotalUsed;

                // ✅ تحديث عرض "المستخدمة" و "المتبقية"
                usedThisMonthElem.textContent = newTotalUsed;
                remainingElem.textContent = balanceAfterLeave;
                remainingElem.classList.toggle('text-danger', balanceAfterLeave < 0);
                remainingElem.classList.toggle('text-warning', balanceAfterLeave === 0 && balanceAfterLeave >= 0);
                remainingElem.classList.toggle('text-success', balanceAfterLeave > 0);
            } else {
                daysCountInput.value = 0;
                // ✅ إعادة الحساب عند مسح التواريخ
                const newTotalUsed = usedDaysBeforeThisMonth + usedDaysThisMonth;
                const balanceAfterLeave = actualCumulativeBalance - newTotalUsed;
                usedThisMonthElem.textContent = newTotalUsed;
                remainingElem.textContent = balanceAfterLeave;
                remainingElem.classList.toggle('text-danger', balanceAfterLeave < 0);
                remainingElem.classList.toggle('text-warning', balanceAfterLeave === 0 && balanceAfterLeave >= 0);
                remainingElem.classList.toggle('text-success', balanceAfterLeave > 0);
            }
        }
    }

    startDateInput.addEventListener('change', calculateDays);
    endDateInput.addEventListener('change', calculateDays);
    calculateDays(); // حساب القيم الأولية عند تحميل الصفحة
});
</script>
@endpush
@endsection