@extends('layouts.app')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>تعديلات أرصدة الإجازات</h3>
        <a href="{{ route('leave-balance-changes.create') }}" class="btn btn-primary">إضافة تعديل</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-striped">
        <thead>
            <tr>
                <th>الموظف</th>
                <th>النوع</th>
                <th>تغيير الأيام</th>
                <th>ساري من</th>
                <th>ملاحظة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach($changes as $c)
                <tr>
                    <td>{{ $c->employee->name }}</td>
                    <td>{{ $c->kind }}</td>
                    <td>{{ $c->days_change }}</td>
                    <td>{{ $c->effective_from->format('Y-m-d') }}</td>
                    <td>{{ $c->note }}</td>
                    <td>
                        <a href="{{ route('leave-balance-changes.edit', $c) }}" class="btn btn-sm btn-secondary">تعديل</a>
                        <form action="{{ route('leave-balance-changes.destroy', $c) }}" method="POST" style="display:inline" onsubmit="return confirm('{{ addslashes(__('app.confirm_delete_item')) }}')">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger">حذف</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $changes->links() }}
</div>
@endsection
