@extends('layouts.app')

@section('content')
<div class="container">
    <h3>تعديل تعديل رصيد</h3>

    <form action="{{ route('leave-balance-changes.update', $change) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label class="form-label">الموظف</label>
            <select name="employee_id" class="form-select" required>
                <option value="">اختر موظفًا</option>
                @foreach($employees as $emp)
                    <option value="{{ $emp->id }}" {{ $emp->id == $change->employee_id ? 'selected' : '' }}>{{ $emp->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">النوع</label>
            <select name="kind" class="form-select" required>
                <option value="monthly" {{ $change->kind == 'monthly' ? 'selected' : '' }}>شهري</option>
                <option value="annual" {{ $change->kind == 'annual' ? 'selected' : '' }}>سنوي</option>
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">تغيير الأيام (يمكن أن يكون سالبًا)</label>
            <input type="number" name="days_change" class="form-control" value="{{ $change->days_change }}" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ساري من</label>
            <input type="date" name="effective_from" class="form-control" value="{{ $change->effective_from->format('Y-m-d') }}" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ملاحظة</label>
            <textarea name="note" class="form-control">{{ $change->note }}</textarea>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
