@extends('layouts.app')

@section('content')
<div class="container">
    <h3>إضافة تعديل رصيد</h3>

    <form action="{{ route('leave-balance-changes.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label class="form-label">الموظف</label>
            <select name="employee_id" class="form-select" required>
                <option value="">اختر موظفًا</option>
                @foreach($employees as $emp)
                    <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">النوع</label>
            <select name="kind" class="form-select" required>
                <option value="monthly">شهري</option>
                <option value="annual">سنوي</option>
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">تغيير الأيام (يمكن أن يكون سالبًا)</label>
            <input type="number" name="days_change" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ساري من</label>
            <input type="date" name="effective_from" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">ملاحظة</label>
            <textarea name="note" class="form-control"></textarea>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
