<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', __('app.app_name'))</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('images/codehorizon-bg.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('images/codehorizon-bg.png') }}">

    <!-- Bootstrap RTL CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom Styles -->
    <style>
        :root {
            --primary-color: #00c6ff;
            --secondary-color: #0072ff;
            --accent-color: #667eea;
            --dark-color: #2d3748;
            --light-color: #f8f9fa;
            --purple-color: #6c5ce7;
        }

        body {
            font-family: 'Cairo', sans-serif;
            background: linear-gradient(135deg, #6c5ce7, #a29bfe);
            min-height: 100vh;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            display: flex;
            width: 100%;
            max-width: 1200px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border-radius: 20px;
            overflow: hidden;
            background: white;
        }

        /* ✅ تعديل: جعل الشريط الجانبي أصغر وأقصر */
        .sidebar {
            width: 200px; /* تقليل العرض */
            background: linear-gradient(135deg, #00c6ff, #0072ff);
            color: white;
            padding: 20px 15px; /* تقليل الهوامش الداخلية */
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            gap: 15px;
        }

        .sidebar .logo {
            text-align: center;
        }

        .sidebar .logo h3 {
            font-weight: 700;
            font-size: 1.1rem;
            margin: 8px 0 4px;
            line-height: 1.3;
        }

        .sidebar .logo p {
            font-size: 0.8rem;
            opacity: 0.85;
            line-height: 1.4;
            margin: 0;
        }

        .sidebar .logo i {
            font-size: 2.2rem;
            margin-bottom: 10px;
            color: white;
        }

        /* ✅ زر اتصل بنا كبير ومميز */
        .contact-us-btn {
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid white;
            border-radius: 14px;
            padding: 20px 16px;
            text-align: center;
            font-weight: 700;
            font-size: 1.15rem;
            color: white !important;
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.4s;
            width: 100%;
            max-width: 180px;
        }

        .contact-us-btn:hover {
            background: rgba(255, 255, 255, 0.35);
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(0, 198, 255, 0.5);
        }

        .contact-icons {
            display: flex;
            gap: 14px;
            font-size: 1.5rem;
        }

        .main-content {
            flex: 1;
            padding: 50px 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .brand-logo {
            text-align: center;
            margin-bottom: 30px;
        }

        .brand-logo i {
            font-size: 2.8rem;
            color: var(--accent-color);
            margin-bottom: 12px;
        }

        .brand-logo h1 {
            font-size: 1.9rem;
            font-weight: 700;
            color: var(--dark-color);
            margin: 0;
        }

        .brand-logo p {
            color: #6c757d;
            font-size: 1rem;
            margin: 10px 0 0;
        }

        .form-title {
            text-align: center;
            margin-bottom: 30px;
            font-size: 1.6rem;
            font-weight: 700;
            color: var(--dark-color);
        }

        .form-group {
            margin-bottom: 22px;
        }

        .form-control {
            border: 2px solid #e1e5ee;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 1rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-check {
            margin-bottom: 20px;
        }

        .btn-login {
            background: linear-gradient(135deg, #00c6ff, #0072ff);
            border: none;
            padding: 16px;
            border-radius: 12px;
            color: white;
            font-weight: 600;
            font-size: 1.15rem;
            transition: all 0.3s;
            width: 100%;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 198, 255, 0.3);
        }

        .forgot-password {
            text-align: center;
            margin: 22px 0;
        }

        .forgot-password a {
            color: var(--accent-color);
            text-decoration: none;
            font-weight: 600;
        }

        .forgot-password a:hover {
            text-decoration: underline;
        }

        .pricing-section {
            margin-top: 45px;
            padding-top: 35px;
            border-top: 2px solid #e1e5ee;
        }

        .pricing-section h5 {
            margin-bottom: 22px;
            font-weight: 700;
            color: var(--dark-color);
        }

        .pricing-card {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 22px;
            margin-bottom: 20px;
            transition: all 0.3s;
        }

        .pricing-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        }

        .pricing-card h6 {
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--dark-color);
        }

        .pricing-card .price {
            font-size: 2.1rem;
            font-weight: 800;
            color: var(--accent-color);
            margin: 14px 0;
        }

        .payment-methods {
            margin-top: 22px;
        }

        .payment-methods h6 {
            margin-bottom: 16px;
            font-weight: 700;
            color: var(--dark-color);
        }

        .payment-icon {
            background: white;
            border-radius: 12px;
            padding: 16px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin: 0 12px 12px 0;
            transition: all 0.3s;
            width: 64px;
            height: 64px;
        }

        .payment-icon:hover {
            transform: scale(1.12);
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.12);
        }

        .payment-icon i {
            font-size: 2.1rem;
        }

        @media (max-width: 992px) {
            .login-container {
                flex-direction: column;
            }

            .sidebar {
                width: 100%;
                flex-direction: row;
                gap: 30px;
                padding: 20px;
            }

            .contact-us-btn {
                max-width: none;
            }
        }

        @media (max-width: 576px) {
            .sidebar .logo h3 {
                font-size: 1rem;
            }

            .sidebar .logo p {
                font-size: 0.75rem;
            }

            .contact-us-btn {
                padding: 16px 12px;
                font-size: 1rem;
            }

            .contact-icons {
                gap: 10px;
                font-size: 1.3rem;
            }

            .main-content {
                padding: 30px 20px;
            }

            .form-title {
                font-size: 1.4rem;
            }

            .btn-login {
                padding: 14px;
                font-size: 1.05rem;
            }
        }
    </style>

    @stack('styles')
</head>
<body>
    <div class="login-container w-100">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="logo">
                <i class="fas fa-building"></i>
                <h3>{{ __('app.app_name') }}</h3>
                <p>{{ __('custom.tagline') }}</p>
            </div>

            <!-- ✅ زر اتصل بنا كبير مع أيقونات واضحة -->
            <a href="{{ route('contact') }}" class="contact-us-btn">
                <div class="contact-icons">
                    <i class="fas fa-envelope"></i>
                    <i class="fab fa-whatsapp"></i>
                </div>
                <span>{{ __('app.contact') ?? __('custom.contact_support') }}</span>
            </a>
        </div>





        <!-- Main Content -->
        <div class="main-content">
            <div class="brand-logo">
                <i class="fas fa-building"></i>
                <h1>{{ __('app.app_name') }}</h1>
                <p>@yield('form_title', __('custom.login_prompt'))</p>
            </div>

            <!-- Language switcher (visible on login/contact pages) -->
            <div class="d-flex justify-content-end mb-3">
                <form id="language-form-login" method="GET" action="{{ url('/language') }}">
                    <select name="locale" class="form-select form-select-sm" onchange="this.form.submit()" style="width: auto; display: inline-block;">
                        <option value="ar" {{ app()->getLocale() == 'ar' ? 'selected' : '' }}>{{ __('app.language_arabic') }}</option>
                        <option value="en" {{ app()->getLocale() == 'en' ? 'selected' : '' }}>{{ __('app.language_english') }}</option>
                        <option value="fr" {{ app()->getLocale() == 'fr' ? 'selected' : '' }}>{{ __('app.language_french') }}</option>
                        <option value="es" {{ app()->getLocale() == 'es' ? 'selected' : '' }}>{{ __('app.language_spanish') }}</option>
                    </select>
                </form>
            </div>

            <div class="form-title">
                @yield('form_title', __('custom.login_prompt'))
            </div>

            @yield('content')

<!-- Contact Us Button -->
<div class="mb-4">
    <a href="https://wa.me/201031694285" target="_blank" class="btn btn-outline-success w-100 d-flex align-items-center justify-content-center gap-2 py-3">
        <i class="fab fa-whatsapp text-success" style="font-size: 1.2rem;"></i>
        <span>{{ __('custom.contact_cta') }}</span>
    </a>
</div>







            <div class="pricing-section">
                <h5>{{ __('custom.pricing.title') }}</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="pricing-card">
                            <h6>{{ __('custom.pricing.basic') }}</h6>
                            <p>{{ __('custom.pricing.basic_desc') }}</p>
                            <div class="price">{{ __('custom.pricing.basic_price') }}<span class="text-muted">/{{ __('custom.pricing.period_month', ['period' => '']) }}</span></div>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.basic_items.up_to_10') }}</li>
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.basic_items.hr_features') }}</li>
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.basic_items.basic_reports') }}</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="pricing-card">
                            <h6>{{ __('custom.pricing.enterprise') }}</h6>
                            <p>{{ __('custom.pricing.enterprise_desc') }}</p>
                            <div class="price">{{ __('custom.pricing.enterprise_price') }}<span class="text-muted">/{{ __('custom.pricing.period_month', ['period' => '']) }}</span></div>
                            <ul class="list-unstyled">
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.enterprise_items.unlimited') }}</li>
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.enterprise_items.advanced_payroll') }}</li>
                                <li><i class="fas fa-check text-success me-2"></i> {{ __('custom.pricing.enterprise_items.custom_reports') }}</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Contact Us Button -->
                <div class="mb-4 mt-4">
                    <a href="https://wa.me/201031694285" target="_blank" class="btn btn-outline-success w-100 d-flex align-items-center justify-content-center gap-2 py-3">
                        <i class="fab fa-whatsapp text-success" style="font-size: 1.2rem;"></i>
                        <span>{{ __('custom.contact_cta') }}</span>
                    </a>
                </div>

             <div class="payment-methods">
                    <h6>{{ __('custom.pricing.payment_methods') }}</h6>
                    <div class="d-flex flex-wrap">
                        <div class="payment-icon">
                            <i class="fab fa-paypal text-primary"></i>
                        </div>
                        <div class="payment-icon">
                            <i class="fab fa-cc-visa text-dark"></i>
                        </div>
                        <div class="payment-icon">
                            <i class="fab fa-cc-mastercard text-danger"></i>
                        </div>
                        <div class="payment-icon">
                            <i class="fas fa-wallet text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    @stack('scripts')
</body>
</html>