{{-- resources/views/layouts/auth.blade.php --}}
<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', ' نظام إدارة الموظفين والرواتب باي ماستر')</title>
    
    <!-- Bootstrap RTL CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --accent-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --dark-gradient: linear-gradient(135deg, #4b6cb7 0%, #182848 100%);
            --light-gradient: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
        }
        
        body {
            background: var(--primary-gradient);
            background-attachment: fixed;
            font-family: 'Tajawal', 'Segoe UI', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            display: flex;
            max-width: 1000px;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
        }
        
        .login-left {
            flex: 1;
            background: var(--dark-gradient);
            color: white;
            padding: 60px 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .login-left::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(30deg);
        }
        
        .login-right {
            flex: 1;
            padding: 60px 40px;
        }
        
        .brand-logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .brand-logo i {
            font-size: 3rem;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .brand-logo h1 {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            color: #333;
            margin-bottom: 10px;
        }
        
        .brand-logo p {
            color: #666;
            font-size: 1.1rem;
        }
        
        .welcome-text h2 {
            font-size: 2rem;
            color: white;
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        .welcome-text p {
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.8;
            margin-bottom: 30px;
        }
        
        .features-list {
            list-style: none;
            padding: 0;
        }
        
        .features-list li {
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        
        .features-list li i {
            background: var(--accent-gradient);
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-left: 10px;
            font-size: 0.8rem;
        }
        
        .login-form .form-group {
            margin-bottom: 25px;
            position: relative;
        }
        
        .login-form .form-group i {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #667eea;
        }
        
        .login-form .form-control {
            padding: 15px 45px 15px 15px;
            border: 2px solid #e1e5ee;
            border-radius: 12px;
            transition: all 0.3s;
            font-size: 1rem;
        }
        
        .login-form .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }
        
        .login-form .btn-login {
            background: var(--primary-gradient);
            border: none;
            padding: 15px;
            border-radius: 12px;
            color: white;
            font-size: 1.1rem;
            font-weight: 600;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }
        
        .login-form .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }
        
        .login-form .btn-login:active {
            transform: translateY(0);
        }
        
        .login-form .btn-login::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -60%;
            width: 20px;
            height: 200%;
            background: rgba(255, 255, 255, 0.3);
            transform: rotate(30deg);
            transition: all 0.6s;
        }
        
        .login-form .btn-login:hover::after {
            left: 120%;
        }
        
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            font-size: 0.9rem;
        }
        
        .form-options .form-check-label {
            color: #666;
        }
        
        .form-options a {
            color: #667eea;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .form-options a:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        
        .divider {
            text-align: center;
            margin: 30px 0;
            position: relative;
        }
        
        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background: #e1e5ee;
        }
        
        .divider span {
            background: white;
            padding: 0 15px;
            color: #999;
            position: relative;
        }
        
        .social-login {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .social-btn {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.2rem;
            transition: all 0.3s;
            border: none;
        }
        
        .social-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        .btn-google {
            background: linear-gradient(135deg, #dd4b39 0%, #c23321 100%);
        }
        
        .btn-facebook {
            background: linear-gradient(135deg, #3b5998 0%, #2d4373 100%);
        }
        
        .btn-twitter {
            background: linear-gradient(135deg, #1da1f2 0%, #0d8bd9 100%);
        }
        
        .signup-link {
            text-align: center;
            color: #666;
            font-size: 0.95rem;
        }
        
        .signup-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s;
        }
        
        .signup-link a:hover {
            color: #764ba2;
            text-decoration: underline;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            font-size: 0.9rem;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
            }
            
            .login-left {
                padding: 40px 30px;
            }
            
            .login-right {
                padding: 40px 30px;
            }
            
            .brand-logo h1 {
                font-size: 2rem;
            }
            
            .welcome-text h2 {
                font-size: 1.7rem;
            }
        }
        
        /* Animation */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-fade-in {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .animate-delay-1 {
            animation-delay: 0.1s;
        }
        
        .animate-delay-2 {
            animation-delay: 0.2s;
        }
        
        .animate-delay-3 {
            animation-delay: 0.3s;
        }
    </style>
    @stack('styles')
</head>
<body>
    <div class="login-container animate-fade-in">
        <!-- Left Side - Welcome Content -->
        <div class="login-left">
            <div class="welcome-text animate-fade-in animate-delay-1">
                <h2>@yield('welcome_title', __('custom.welcome_title'))</h2>
                <p>@yield('welcome_text', __('custom.welcome_text'))</p>
                
                <ul class="features-list animate-fade-in animate-delay-2">
                    <li>
                        <i class="fas fa-check"></i>
                        <span>{{ __('custom.features.management_desc') }}</span>
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        <span>{{ __('custom.features.attendance_desc') }}</span>
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        <span>{{ __('custom.features.leaves_desc') }}</span>
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        <span>{{ __('custom.features.reports') }}</span>
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        <span>{{ __('custom.features.permissions') }}</span>
                    </li>
                </ul>
            </div>
            
            <div class="text-center mt-auto animate-fade-in animate-delay-3">
                <p class="mb-0" style="color: rgba(255, 255, 255, 0.7);">
                    <i class="fas fa-lock me-2"></i>
                    {{ __('custom.security_statement') }}
                </p>
            </div>
        </div>
        
        <!-- Right Side - Form Content -->
        <div class="login-right">
            <div class="brand-logo animate-fade-in">
                <i class="fas fa-building"></i>
                <h1>{{ __('app.app_name') }}</h1>
                <p>@yield('form_title', __('custom.login_prompt'))</p>
            </div>
            
            @yield('content')
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom Scripts -->
    <script>
        // Add animation to form elements on focus
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('.form-control');
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.parentElement.classList.add('focused');
                });
                
                input.addEventListener('blur', function() {
                    this.parentElement.parentElement.classList.remove('focused');
                });
            });
            
            // Form submission animation
            const form = document.querySelector('.login-form');
                if (form) {
                form.addEventListener('submit', function() {
                    const submitBtn = this.querySelector('.btn-login');
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> {{ addslashes(__('custom.processing')) }}';
                    submitBtn.disabled = true;
                });
            }
            
            // Validation
            'use strict'
            var forms = document.querySelectorAll('.needs-validation')
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        });
    </script>
    @stack('scripts')
</body>
</html>