<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}" dir="{{ $direction ?? (in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr') }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', __('app.app_name'))</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('images/codehorizon-bg.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" href="{{ asset('images/codehorizon-bg.png') }}">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">

    <!-- Bootstrap RTL CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

    <!-- Custom Styles -->
    <style>
        :root {
            --sidebar-bg: #2c3e50;
            --sidebar-hover: #34495e;
            --sidebar-active: #3498db;
            --topbar-bg: #ffffff;
            --border-color: #e1e5ee;
            --purple-light: #b39ddb; /* لون بنفسجي فاتح */
            --purple-dark: #8e6bbf;   /* لون بنفسجي أغمق للتحويم */
        }

        body {
            background-color: #f5f7fb;
            font-family: 'Tajawal', 'Segoe UI', sans-serif;
            overflow-x: hidden;
            direction: {{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'rtl' : 'ltr' }};
            margin: 0;
            padding: 0;
            transition: margin-right 0.3s ease;
        }

        .sidebar {
            background: var(--sidebar-bg);
            color: white;
            height: 100vh;
            position: fixed;
            right: 0;
            top: 0;
            width: 250px;
            z-index: 1000;
            box-shadow: -2px 0 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
            overflow-y: auto;
            overflow-x: hidden;
        }

        .sidebar .logo {
            padding: 20px 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar .logo h3 {
            color: white;
            margin: 0;
            font-size: 1.2rem;
        }

        .nav-link {
            color: rgba(255, 255, 255, 0.8) !important;
            padding: 12px 20px !important;
            margin: 5px 10px !important;
            border-radius: 8px !important;
            transition: all 0.3s !important;
            display: flex !important;
            align-items: center !important;
            text-decoration: none !important;
            border-left: 4px solid transparent;
        }

        .nav-link:hover,
        .nav-link.active {
            color: white !important;
            background-color: rgba(255, 255, 255, 0.1) !important;
            border-left: 4px solid #3498db !important;
        }

        .nav-link i {
            margin-left: 10px;
            width: 20px;
            text-align: center;
            color: white !important; /* اللون الأبيض الافتراضي */
        }

        /* ✅ تعطيل الرابط */
        .nav-link.disabled {
            color: rgba(255, 255, 255, 0.4) !important;
            pointer-events: none; /* تعطيل النقر */
            cursor: not-allowed;
        }

        .main-content {
            margin-right: 250px;
            transition: margin-right 0.3s ease;
            min-height: 100vh;
        }

        .topbar {
            background: var(--topbar-bg);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 15px 20px;
            position: sticky;
            top: 0;
            z-index: 999;
        }

        /* Mobile Responsive */
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(100%);
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .main-content {
                margin-right: 0;
            }
            .sidebar-toggle {
                display: block;
                position: fixed;
                top: 15px;
                right: 15px;
                z-index: 1001;
                background: var(--sidebar-bg);
                color: white;
                border: none;
                border-radius: 50%;
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
            }
            .overlay {
                position: fixed;
                top: 0;
                right: 0;
                width: 100%;
                height: 100%;
                background: rgba(0,0,0,0.5);
                z-index: 999;
                display: none;
            }
            .overlay.active {
                display: block;
            }
        }

        /* تعديلات الإشعارات */
        .notification-dropdown {
            width: 350px;
            max-height: 400px;
            overflow-y: auto;
        }

        .notification-item {
            border-bottom: 1px solid #e9ecef;
        }

        .notification-item:last-child {
            border-bottom: none;
        }

        .notification-unread {
            background-color: #f8f9fa;
        }

        .notification-badge {
            position: relative;
        }

        .notification-badge .badge {
            position: absolute;
            top: -5px;
            right: -10px;
        }

        /* أسلوب الشارة لـ "قيد التطوير" */
        .dev-badge {
            font-size: 0.7em; /* جعل الشارة أصغر */
            vertical-align: super; /* رفع الشارة قليلاً */
        }

        /* ترجمة العناصر حسب اللغة */
        [dir="ltr"] {
            direction: ltr;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        [dir="ltr"] .sidebar {
            right: auto;
            left: 0;
        }

        [dir="ltr"] .main-content {
            margin-right: 0;
            margin-left: 250px;
        }

        [dir="ltr"] .nav-link i {
            margin-left: 0;
            margin-right: 10px;
        }

        [dir="ltr"] .sidebar-toggle {
            right: auto;
            left: 15px;
        }

        [dir="ltr"] .topbar {
            padding: 15px 20px;
        }

        @media (max-width: 992px) {
            [dir="ltr"] .sidebar {
                transform: translateX(-100%);
            }
            [dir="ltr"] .sidebar.active {
                transform: translateX(0);
            }
            [dir="ltr"] .main-content {
                margin-left: 0;
            }
        }

        /* تنسيق زر الطباعة */
        .print-btn {
            margin-right: 10px;
        }

        /* تعديل تعريف الفئة لجعلها أكثر تحديدًا أو تطبيق !important */
        /* نستخدم محدد أكثر تحديدًا للOverrides قواعد .nav-link i */
        .topbar .nav-link .text-purple-light {
            color: var(--purple-light) !important; /* استخدام متغير CSS */
        }
        .topbar .nav-link .text-purple-light:hover {
            color: var(--purple-dark) !important; /* استخدام متغير CSS */
        }

        /* ✅ أنماط الشعار */
        .logo-img {
            height: 32px; /* ارتفاع موحد */
            width: auto;  /* عرض تلقائي للحفاظ على تناسق الشعار */
            object-fit: contain; /* ضمان عرض الشعار بالكامل دون تشويه */
            margin-left: 10px; /* مسافة من اليسار */
        }
        .logo-img-lg {
            height: 40px; /* ارتفاع أكبر للشريط العلوي */
            width: auto;
            object-fit: contain;
            margin-right: 10px; /* مسافة من اليمين */
        }
    </style>

    <!-- دعم @stack('styles') إن وُجد -->
    @stack('styles')
</head>
<body>
    <!-- Mobile Toggle -->
    <button class="sidebar-toggle d-lg-none"><i class="fas fa-bars"></i></button>
    <div class="overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar">
        <div class="logo">
            <!-- ✅ شعار + اسم النظام في الشريط الجانبي -->
            <h3 class="d-flex align-items-center">
                <img src="{{ asset('images/codehorizon-bg.png') }}" alt="Logo" class="logo-img">
                <span style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-weight: bold;">
                   {{ __('app.app_name') }}
                </span>
            </h3>
        </div>

        <nav class="nav flex-column mt-3">
            <!-- ✅ زر لوحة التحكم المركزية (Super Admin فقط) -->
            @auth
                @if(auth()->user()->role === 'super_admin')
                <a href="{{ route('super-admin.dashboard') }}" class="nav-link {{ request()->routeIs('super-admin.*') ? 'active' : '' }}" style="background-color: rgba(255, 193, 7, 0.2); border-left: 4px solid #ffc107;">
                    <i class="fas fa-crown me-2" style="color: #ffc107;"></i> <span class="menu-text" style="color: #ffc107; font-weight: bold;">لوحة التحكم المركزية</span>
                </a>
                <hr class="my-2" style="border-color: rgba(255, 255, 255, 0.1);">
                @endif
            @endauth

            <a href="{{ route('dashboard.index') }}" class="nav-link {{ request()->routeIs('dashboard.*') ? 'active' : '' }}">
                <i class="fas fa-tachometer-alt me-2"></i> <span class="menu-text">{{ __('app.dashboard') }}</span>
            </a>
            <a href="{{ route('employees.index') }}" class="nav-link {{ request()->routeIs('employees.*') ? 'active' : '' }}">
                <i class="fas fa-users me-2"></i> <span class="menu-text">{{ __('app.employees') }}</span>
            </a>
            <a href="{{ route('attendance.index') }}" class="nav-link {{ request()->routeIs('attendance.*') ? 'active' : '' }}">
                <i class="fas fa-clock me-2"></i> <span class="menu-text">{{ __('app.attendance') }}</span>
            </a>
            <a href="{{ route('payroll.index') }}" class="nav-link {{ request()->routeIs('payroll.*') ? 'active' : '' }}">
                <i class="fas fa-money-bill-wave me-2"></i> <span class="menu-text">{{ __('app.payroll') }}</span>
                 <span class="badge bg-info text-white dev-badge"> <span class="dev-text">{{ __('app.feature_status.developed') }}</span> </span>
            </a>
            <a href="{{ route('leaves.index') }}" class="nav-link {{ request()->routeIs('leaves.*') ? 'active' : '' }}">
                <i class="fas fa-umbrella-beach me-2"></i> <span class="menu-text">{{ __('app.leaves') }}</span>
            </a>
            <a href="{{ route('loans.index') }}" class="nav-link {{ request()->routeIs('loans.*') ? 'active' : '' }}">
                <i class="fas fa-credit-card me-2"></i> <span class="menu-text">{{ __('app.loans') }}</span>
            </a>
            <a href="{{ route('deductions.index') }}" class="nav-link {{ request()->routeIs('deductions.*') ? 'active' : '' }}">
                <i class="fas fa-minus-circle me-2"></i> <span class="menu-text">{{ __('app.deductions') }}</span>
            </a>
            <!-- ✅ السماح بالدخول مع علامة "قيد التطوير" -->
            <a href="{{ route('training.index') }}" class="nav-link {{ request()->routeIs('training.*') ? 'active' : '' }}" title="{{ __('app.feature_status.in_progress') }}">
                <i class="fas fa-graduation-cap me-2"></i> <span class="menu-text">{{ __('app.training') }}</span>
                <span class="badge bg-warning text-dark dev-badge"><span class="dev-text">{{ __('app.feature_status.in_progress') }}</span></span>
            </a>
            <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}">
                <i class="fas fa-user-cog me-2"></i> <span class="menu-text">{{ __('app.users') }}</span>
            </a>
            <a href="{{ route('notifications.index') }}" class="nav-link {{ request()->routeIs('notifications.*') ? 'active' : '' }}">
                <i class="fas fa-bell me-2"></i> <span class="menu-text">{{ __('app.notifications') }}</span>
                @auth
                    @php
                        $user = auth()->user();
                        // لا نستخدم $isAdminOrHR في هذا السياق لأنه لا يوجد فلتر مبني على الأدوار هنا.
                        // نعرض عدد الإشعارات غير المقروءة الخاصة *بهذا المستخدم فقط*.
                        $unreadNotificationsCount = $user->unreadNotifications()->count(); // هذا يشمل جميع أنواع الإشعارات
                    @endphp
                    @if ($unreadNotificationsCount > 0)
                        <span class="badge bg-danger rounded-pill">{{ $unreadNotificationsCount }}</span>
                    @endif
                @endauth
            </a>

            <!-- رابط إعدادات النظام -->
            @can('manage settings')
            <a href="{{ route('settings.index') }}" class="nav-link {{ request()->routeIs('settings.*') ? 'active' : '' }}">
                <i class="fas fa-cog me-2"></i> <span class="menu-text">{{ __('app.settings') }}</span>
            </a>
            @endcan
            <!-- رابط مباشر لإدارة العطلات الرسمية - انتقل مباشرة إلى صفحة سنوات العطلات -->
            @can('manage settings')
            <a href="{{ route('holiday-years.index') }}" class="nav-link {{ request()->routeIs('holiday-years.*') ? 'active' : (request()->routeIs('holidays.*') ? 'active' : '') }}">
                <i class="fas fa-calendar-day me-2"></i> <span class="menu-text">{{ __('app.holidays') }}</span>
            </a>
            @endcan

            @auth
            <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="nav-link">
                <i class="fas fa-sign-out-alt me-2"></i> <span class="menu-text">{{ __('app.logout') }}</span>
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">@csrf</form>
            @endauth
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="topbar d-flex justify-content-between align-items-center">
            <!-- ✅ شعار + اسم النظام في الشريط العلوي -->
            <h4 class="mb-0 d-flex align-items-center">
                <img src="{{ asset('images/codehorizon-bg.png') }}" alt="Logo" class="logo-img-lg">
                <span style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-weight: bold;">
                    @yield('page-title', __('app.app_name'))
                </span>
            </h4>
            <div>
                <!-- زر تبديل اللغة -->
                <div class="btn-group me-3">
                    <form id="language-form" method="GET" action="{{ url('/language') }}">
                        @csrf
                        <select name="locale" class="form-select form-select-sm" onchange="this.form.submit()" style="width: auto; display: inline-block;">
                            <option value="ar" {{ app()->getLocale() == 'ar' ? 'selected' : '' }}>{{ __('app.language_arabic') }}</option>
                            <option value="en" {{ app()->getLocale() == 'en' ? 'selected' : '' }}>{{ __('app.language_english') }}</option>
                            <option value="fr" {{ app()->getLocale() == 'fr' ? 'selected' : '' }}>{{ __('app.language_french') }}</option>
                            <option value="es" {{ app()->getLocale() == 'es' ? 'selected' : '' }}>{{ __('app.language_spanish') }}</option>
                        </select>
                    </form>
                </div>

                <!-- زر الطباعة -->
                <button type="button" class="btn btn-outline-secondary btn-sm print-btn no-print" onclick="window.print();">
                    <i class="fas fa-print"></i> <span class="print-text">{{ __('app.print') }}</span>
                </button>

                @auth
                <div class="dropdown d-inline">
                    <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                        <!-- ✅ أيقونة الحساب باللون البنفسجي الفاتح -->
                        <i class="fas fa-user-circle me-1 text-purple-light"></i> {{ auth()->user()->name }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="{{ route('users.edit', auth()->user()->id) }}">{{ __('app.profile') }}</a></li> <!-- ✅ تعديل الرابط -->
                        <li><a class="dropdown-item" href="{{ route('settings.index') }}">{{ __('app.settings') }}</a></li> <!-- ✅ تعديل الرابط -->
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();">{{ __('app.logout') }}</a>
                            <form id="logout-form-header" action="{{ route('logout') }}" method="POST" class="d-none">@csrf</form>
                        </li>
                    </ul>
                </div>

                <!-- Dropdown الإشعارات -->
                @php
                    $user = auth()->user();
                    // لا نستخدم $isAdminOrHR في هذا السياق لأنه لا يوجد فلتر مبني على الأدوار هنا.
                    // نعرض عدد الإشعارات غير المقروءة الخاصة *بهذا المستخدم فقط*.
                    $unreadNotificationsCount = $user->unreadNotifications()->count(); // هذا يشمل جميع أنواع الإشعارات
                @endphp
                <div class="dropdown d-inline ms-3 notification-badge">
                    <a class="nav-link dropdown-toggle position-relative" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <!-- ✅ أيقونة الإشعارات باللون البنفسجي الفاتح -->
                        <i class="fas fa-bell text-purple-light"></i>
                        @if ($unreadNotificationsCount > 0)
                            <span class="badge bg-danger rounded-pill">{{ $unreadNotificationsCount }}</span>
                        @endif
                    </a>

                    <ul class="dropdown-menu dropdown-menu-end notification-dropdown">
                        <li class="px-3 py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="m-0"><span class="notification-text">{{ __('app.notifications') }}</span></h6>
                                @if($unreadNotificationsCount > 0)
                                    <a href="#" id="markAllAsReadNavbar" class="text-sm"><span class="mark-all-text">{{ __('app.mark_all_as_read') }}</span></a>
                                @endif
                            </div>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <!-- هذا الجزء يعرض *جميع* الإشعارات (مقروءة وغير مقروءة) -->
                        @forelse(auth()->user()->notifications()->latest()->limit(10)->get() as $notification)
                            <li class="notification-item {{ $notification->read_at ? '' : 'notification-unread' }}">
                                <a class="dropdown-item d-flex align-items-start" href="{{ $notification->data['url'] ?? '#' }}" data-id="{{ $notification->id }}">
                                    <div class="flex-grow-1">
                                        <div class="d-flex w-100 justify-content-between">
                                            <h6 class="mb-1">{{ $notification->data['title'] ?? __('app.notification_new_default_title') }}</h6>
                                            <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                                        </div>
                                        <p class="mb-1">{{ $notification->data['message'] ?? __('app.notification_details_default') }}</p>
                                    </div>
                                    @if(!$notification->read_at)
                                        <span class="badge bg-success ms-2"><span class="new-text">{{ __('app.new') }}</span></span>
                                    @endif
                                </a>
                            </li>
                        @empty
                            <li><a class="dropdown-item text-center text-muted" href="#"><span class="no-notifications-text">{{ __('app.no_notifications') }}</span></a></li>
                        @endforelse
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center" href="{{ route('notifications.index') }}"><span class="view-all-text">{{ __('app.view_all') }}</span></a></li>
                    </ul>
                </div>
                @endauth
                @guest
                <a href="{{ route('login') }}" class="btn btn-primary"><span class="login-text">{{ __('app.login') }}</span></a>
                @endguest
            </div>
        </div>

        <div class="container-fluid py-4">
            @yield('content')
        </div>
    </div>

    <!-- jQuery أولًا (ضروري لـ Bootstrap و Select2) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- دعم Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <!-- تعريف دالة bindEmployeeSelect -->
    <script>
        // ✅ تعريف الدالة التي كنت تستخدمها دون تعريفها
        function bindEmployeeSelect(employeeId, scheduledInId, scheduledOutId, modalId = null) {
            const employeeEl = document.getElementById(employeeId);
            const inEl = document.getElementById(scheduledInId);
            const outEl = document.getElementById(scheduledOutId);

            function updateScheduledTimes() {
                if (!employeeEl || !inEl || !outEl) return; // تحقق من وجود العناصر

                const selectedOption = employeeEl.options[employeeEl.selectedIndex];
                if (selectedOption && selectedOption.value) {
                    inEl.value = selectedOption.dataset.checkin || '09:00';
                    outEl.value = selectedOption.dataset.checkout || '17:00';
                } else {
                    inEl.value = '';
                    outEl.value = '';
                }
            }

            // تنفيذ فوري عند تحميل الصفحة أو فتح الـ Modal
            updateScheduledTimes();

            // عند تغيير الموظف
            employeeEl?.addEventListener('change', updateScheduledTimes);

            // إذا كان داخل Modal
            if (modalId) {
                const modal = document.getElementById(modalId);
                if (modal) {
                    modal.addEventListener('show.bs.modal', updateScheduledTimes);
                }
            }
        }

        // تهيئة Select2
        $(document).ready(function () {
            const appLocale = '{{ app()->getLocale() }}';
            const isRtl = {{ in_array(app()->getLocale(), ['ar','he','fa','ur']) ? 'true' : 'false' }};
            $('.select2').select2({
                placeholder: '{{ addslashes(__('app.select_placeholder', [], app()->getLocale())) }}' || 'Select...',
                allowClear: true,
                dir: isRtl ? 'rtl' : 'ltr',
                language: appLocale
            });
        });
    </script>

    <!-- JavaScript للتحكم في الـ Sidebar -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            const sidebar = document.querySelector('.sidebar');
            const overlay = document.querySelector('.overlay');

            if (sidebarToggle) {
                sidebarToggle.addEventListener('click', function () {
                    sidebar.classList.toggle('active');
                    overlay.classList.toggle('active');
                });
            }

            if (overlay) {
                overlay.addEventListener('click', function () {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                });
            }

            // دعم تبديل اللغة
            const langOptions = document.querySelectorAll('.lang-option');
            const currentLangSpan = document.querySelector('.current-lang');
            const menuTexts = document.querySelectorAll('.menu-text');
            const devTexts = document.querySelectorAll('.dev-text');
            const notificationText = document.querySelector('.notification-text');
            const markAllText = document.querySelector('.mark-all-text');
            const newText = document.querySelector('.new-text');
            const noNotificationsText = document.querySelector('.no-notifications-text');
            const viewAllText = document.querySelector('.view-all-text');
            const loginText = document.querySelector('.login-text');
            const printText = document.querySelector('.print-text');

            const translations = {
                ar: {
                    'العربية': 'العربية',
                    'English': 'English',
                    'Français': 'Français',
                    'Español': 'Español',
                    'Dashboard': 'لوحة التحكم',
                    'Employees': 'الموظفين',
                    'Attendance': 'الحضور',
                    'Payroll': 'الرواتب',
                    'Leaves': 'الإجازات',
                    'Loans': 'القروض',
                    'Deductions': 'الاستقطاعات',
                    'Training': 'التدريب',
                    'Users': 'المستخدمين',
                    'Notifications': 'الإشعارات',
                    'Settings': 'الإعدادات',
                    'Logout': 'تسجيل الخروج',
                    'Developed': 'تم تطويره',
                    'Under Development': 'قيد التطوير',
                    'Mark All as Read': 'تعليم الكل كمقروءة',
                    'New': 'جديد',
                    'No notifications': 'لا توجد إشعارات',
                    'View all notifications': 'عرض جميع الإشعارات',
                    'Login': 'تسجيل الدخول',
                    'Print': 'طباعة',
                    'Profile': 'الملف الشخصي',
                    'لوحة التحكم': 'لوحة التحكم',
                    'الموظفين': 'الموظفين',
                    'الحضور': 'الحضور',
                    'الرواتب': 'الرواتب',
                    'الإجازات': 'الإجازات',
                    'القروض': 'القروض',
                    'الاستقطاعات': 'الاستقطاعات',
                    'التدريب': 'التدريب',
                    'المستخدمين': 'المستخدمين',
                    'الإشعارات': 'الإشعارات',
                    'الإعدادات': 'الإعدادات',
                    'تسجيل الخروج': 'تسجيل الخروج',
                    'تم تطويره': 'تم تطويره',
                    'قيد التطوير': 'قيد التطوير',
                    'الإشعارات': 'الإشعارات',
                    'تعليم الكل كمقروءة': 'تعليم الكل كمقروءة',
                    'جديد': 'جديد',
                    'لا توجد إشعارات': 'لا توجد إشعارات',
                    'عرض جميع الإشعارات': 'عرض جميع الإشعارات',
                    'تسجيل الدخول': 'تسجيل الدخول',
                    'طباعة': 'طباعة',
                    'الملف الشخصي': 'الملف الشخصي'
                },
                en: {
                    'العربية': 'Arabic',
                    'English': 'English',
                    'Français': 'French',
                    'Español': 'Spanish',
                    'Dashboard': 'Dashboard',
                    'Employees': 'Employees',
                    'Attendance': 'Attendance',
                    'Payroll': 'Payroll',
                    'Leaves': 'Leaves',
                    'Loans': 'Loans',
                    'Deductions': 'Deductions',
                    'Training': 'Training',
                    'Users': 'Users',
                    'Notifications': 'Notifications',
                    'Settings': 'Settings',
                    'Logout': 'Logout',
                    'Developed': 'Developed',
                    'Under Development': 'Under Development',
                    'Mark All as Read': 'Mark All as Read',
                    'New': 'New',
                    'No notifications': 'No notifications',
                    'View all notifications': 'View all notifications',
                    'Login': 'Login',
                    'Print': 'Print',
                    'Profile': 'Profile',
                    'لوحة التحكم': 'Dashboard',
                    'الموظفين': 'Employees',
                    'الحضور': 'Attendance',
                    'الرواتب': 'Payroll',
                    'الإجازات': 'Leaves',
                    'القروض': 'Loans',
                    'الاستقطاعات': 'Deductions',
                    'التدريب': 'Training',
                    'المستخدمين': 'Users',
                    'الإشعارات': 'Notifications',
                    'الإعدادات': 'Settings',
                    'تسجيل الخروج': 'Logout',
                    'تم تطويره': 'Developed',
                    'قيد التطوير': 'Under Development',
                    'الإشعارات': 'Notifications',
                    'تعليم الكل كمقروءة': 'Mark All as Read',
                    'جديد': 'New',
                    'لا توجد إشعارات': 'No notifications',
                    'عرض جميع الإشعارات': 'View all notifications',
                    'تسجيل الدخول': 'Login',
                    'طباعة': 'Print',
                    'الملف الشخصي': 'Profile'
                },
                fr: {
                    'العربية': 'Arabe',
                    'English': 'Anglais',
                    'Français': 'Français',
                    'Español': 'Espagnol',
                    'Dashboard': 'Tableau de bord',
                    'Employees': 'Employés',
                    'Attendance': 'Présence',
                    'Payroll': 'Paie',
                    'Leaves': 'Congés',
                    'Loans': 'Prêts',
                    'Deductions': 'Déductions',
                    'Training': 'Formation',
                    'Users': 'Utilisateurs',
                    'Notifications': 'Notifications',
                    'Settings': 'Paramètres',
                    'Logout': 'Déconnexion',
                    'Developed': 'Développé',
                    'Under Development': 'En développement',
                    'Mark All as Read': 'Marquer tout comme lu',
                    'New': 'Nouveau',
                    'No notifications': 'Aucune notification',
                    'View all notifications': 'Voir toutes les notifications',
                    'Login': 'Connexion',
                    'Print': 'Imprimer',
                    'Profile': 'Profil',
                    'لوحة التحكم': 'Tableau de bord',
                    'الموظفين': 'Employés',
                    'الحضور': 'Présence',
                    'الرواتب': 'Paie',
                    'الإجازات': 'Congés',
                    'القروض': 'Prêts',
                    'الاستقطاعات': 'Déductions',
                    'التدريب': 'Formation',
                    'المستخدمين': 'Utilisateurs',
                    'الإشعارات': 'Notifications',
                    'الإعدادات': 'Paramètres',
                    'تسجيل الخروج': 'Déconnexion',
                    'تم تطويره': 'Développé',
                    'قيد التطوير': 'En développement',
                    'الإشعارات': 'Notifications',
                    'تعليم الكل كمقروءة': 'Marquer tout comme lu',
                    'جديد': 'Nouveau',
                    'لا توجد إشعارات': 'Aucune notification',
                    'عرض جميع الإشعارات': 'Voir toutes les notifications',
                    'تسجيل الدخول': 'Connexion',
                    'طباعة': 'Imprimer',
                    'الملف الشخصي': 'Profil'
                },
                es: {
                    'العربية': 'Árabe',
                    'English': 'Inglés',
                    'Français': 'Francés',
                    'Español': 'Español',
                    'Dashboard': 'Panel de control',
                    'Employees': 'Empleados',
                    'Attendance': 'Asistencia',
                    'Payroll': 'Nómina',
                    'Leaves': 'Permisos',
                    'Loans': 'Préstamos',
                    'Deductions': 'Deducciones',
                    'Training': 'Formación',
                    'Users': 'Usuarios',
                    'Notifications': 'Notificaciones',
                    'Settings': 'Configuración',
                    'Logout': 'Cerrar sesión',
                    'Developed': 'Desarrollado',
                    'Under Development': 'En desarrollo',
                    'Mark All as Read': 'Marcar todo como leído',
                    'New': 'Nuevo',
                    'No notifications': 'Sin notificaciones',
                    'View all notifications': 'Ver todas las notificaciones',
                    'Login': 'Iniciar sesión',
                    'Print': 'Imprimir',
                    'Profile': 'Perfil',
                    'لوحة التحكم': 'Panel de control',
                    'الموظفين': 'Empleados',
                    'الحضور': 'Asistencia',
                    'الرواتب': 'Nómina',
                    'الإجازات': 'Permisos',
                    'القروض': 'Préstamos',
                    'الاستقطاعات': 'Deducciones',
                    'التدريب': 'Formación',
                    'المستخدمين': 'Usuarios',
                    'الإشعارات': 'Notificaciones',
                    'الإعدادات': 'Configuración',
                    'تسجيل الخروج': 'Cerrar sesión',
                    'تم تطويره': 'Desarrollado',
                    'قيد التطوير': 'En desarrollo',
                    'الإشعارات': 'Notificaciones',
                    'تعليم الكل كمقروءة': 'Marcar todo como leído',
                    'جديد': 'Nuevo',
                    'لا توجد إشعارات': 'Sin notificaciones',
                    'عرض جميع الإشعارات': 'Ver todas las notificaciones',
                    'تسجيل الدخول': 'Iniciar sesión',
                    'طباعة': 'Imprimir',
                    'الملف الشخصي': 'Perfil'
                }
            };

            // دالة لتغيير اللغة
            function switchLanguage(selectedLang) {
                // إنشاء نموذج إرسال
                const form = document.createElement('form');
                form.method = 'GET';
                form.action = `/language/${selectedLang}`;
                
                // إضافة حقول CSRF إذا لزم الأمر
                const csrfField = document.createElement('input');
                csrfField.type = 'hidden';
                csrfField.name = '_token';
                csrfField.value = '{{ csrf_token() }}';
                form.appendChild(csrfField);
                
                // إضافة النموذج إلى الصفحة وإرساله
                document.body.appendChild(form);
                form.submit();
            }

            // إضافة مستمعي الأحداث لأزرار تغيير اللغة
            langOptions.forEach(option => {
                option.addEventListener('click', function(e) {
                    e.preventDefault();
                    const selectedLang = this.getAttribute('data-lang');
                    switchLanguage(selectedLang);
                });
            });
        });
    </script>

    <!-- JavaScript للإشعارات -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Mark All As Read (Navbar)
            const markAllLink = document.getElementById('markAllAsReadNavbar');
            if (markAllLink) {
                markAllLink.addEventListener('click', function(e) {
                    e.preventDefault();
                    if (confirm('{{ addslashes(__('app.confirm_mark_all_notifications_read')) }}')) {
                        fetch("{{ route('notifications.read-all') }}", {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                location.reload(); // أو تحديث عدد الإشعارات فقط
                            }
                        });
                    }
                });
            }

            // Mark Single Notification as Read (Inline) - في الـ Navbar dropdown
            document.querySelectorAll('.notification-dropdown .dropdown-item').forEach(item => {
                item.addEventListener('click', function(e) {
                    // لا نمنع إعادة التوجيه إذا كان هناك رابط فعلي
                    const href = this.getAttribute('href');
                    if (!href || href === '#' || href === 'javascript:void(0)') {
                        e.preventDefault(); // منع الانتقال فقط إذا لم يكن هناك رابط صحيح
                    }

                    const notificationId = this.getAttribute('data-id');
                    if (notificationId) {
                        // نستخدم PATCH لتعليم الإشعار كمقروء
                        fetch(`/notifications/${notificationId}/read`, { // استخدم المسار المحدد في routes/web.php
                            method: 'PATCH', // أو POST حسب تعريفك
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                // تحديث واجهة المستخدم (إزالة العلامة الحمراء، تحديث العدد)
                                // هذا يتم عادةً عند إعادة تحميل الصفحة بعد الانتقال إلى الرابط
                                // لكن يمكننا محاولة تحديث العنصر مباشرة هنا
                                this.closest('.notification-item').classList.remove('notification-unread');
                                this.querySelector('.badge.bg-success')?.remove(); // إزالة علامة "جديد"

                                // تحديث العدد في الشريط العلوي
                                const badge = document.querySelector('.notification-badge .badge');
                                if (badge) {
                                    let count = parseInt(badge.textContent);
                                    if (count > 0) {
                                        count--;
                                        badge.textContent = count;
                                        if (count === 0) {
                                            badge.remove(); // إزالة العلامة إذا كان العدد صفر
                                        }
                                    }
                                }
                            }
                        }).catch(error => {
                            console.error('Error updating notification status:', error);
                        });
                    }
                });
            });
        });
    </script>

    <!-- دعم @stack('scripts') -->
    @stack('scripts')
</body>
</html>