@extends('layouts.app')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>{{ __('app.holidays') }}</h3>
        <div>
            <a href="{{ route('holiday-years.index') }}" class="btn btn-outline-secondary me-2">{{ __('app.holiday_years') }}</a>
            <a href="{{ route('holidays.create') }}" class="btn btn-primary">{{ __('app.add') }} {{ __('app.holidays') }}</a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-striped">
        <thead>
            <tr>
                <th>{{ __('app.date') }}</th>
                <th>{{ __('app.name') }}</th>
                <th>{{ __('app.paid') }}</th>
                <th>{{ __('app.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($holidays as $h)
                <tr>
                    <td>{{ $h->date->format('Y-m-d') }}</td>
                    <td>{{ $h->name }}</td>
                    <td>{{ $h->is_paid ? __('app.yes') : __('app.no') }}</td>
                    <td>
                        <a href="{{ route('holidays.edit', $h) }}" class="btn btn-sm btn-secondary">{{ __('app.edit') }}</a>
                        <form action="{{ route('holidays.destroy', $h) }}" method="POST" style="display:inline" onsubmit="return confirm('{{ addslashes(__('app.confirm_delete_item')) }}')">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger">{{ __('app.delete') }}</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $holidays->links() }}
</div>
@endsection
