@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('app.edit') }} {{ __('app.holidays') }}</h3>

    <form action="{{ route('holidays.update', $holiday) }}" method="POST">
        @csrf
        @method('PATCH')
        @if($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">الشهر</label>
                @php $selMonth = old('month', $holiday->date ? $holiday->date->format('m') : now()->format('m')); @endphp
                <select name="month" class="form-control">
                    @for($m=1;$m<=12;$m++)
                        <option value="{{ $m }}" {{ (int)$selMonth == $m ? 'selected' : '' }}>{{ sprintf('%02d', $m) }}</option>
                    @endfor
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label class="form-label">اليوم</label>
                @php $selDay = old('day', $holiday->date ? $holiday->date->format('d') : now()->format('d')); @endphp
                <select name="day" class="form-control">
                    @for($d=1;$d<=31;$d++)
                        <option value="{{ $d }}" {{ (int)$selDay == $d ? 'selected' : '' }}>{{ sprintf('%02d', $d) }}</option>
                    @endfor
                </select>
            </div>
        </div>
        <div class="mb-3">
            <label class="form-label">الاسم (اختياري)</label>
            <input type="text" name="name" class="form-control" value="{{ old('name', $holiday->name) }}">
        </div>
        <div class="form-check mb-3">
            <input type="hidden" name="is_paid" value="0">
            <input type="checkbox" name="is_paid" value="1" class="form-check-input" id="is_paid" {{ old('is_paid', $holiday->is_paid) ? 'checked' : '' }}>
            <label class="form-check-label" for="is_paid">مدفوعة</label>
        </div>
        <button class="btn btn-primary">حفظ</button>
    </form>
</div>
@endsection
